/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SwapNOperation
extends AbstractFixedCostOperation {
    public static final int OPCODE = 231;
    static final Operation.OperationResult swapSuccess = new Operation.OperationResult(3L, null);

    public SwapNOperation(GasCalculator gasCalculator) {
        super(231, "SWAPN", 0, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int pc = frame.getPC();
        int index = code.readU8(pc + 1);
        Bytes tmp = frame.getStackItem(0);
        frame.setStackItem(0, frame.getStackItem(index + 1));
        frame.setStackItem(index + 1, tmp);
        frame.setPC(pc + 1);
        return swapSuccess;
    }
}

