/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.hiero.consensus.model.event.PlatformEvent;

public interface EventGraphSource {
    @NonNull
    public PlatformEvent next();

    default public List<PlatformEvent> nextEvents(int count) {
        ArrayList<PlatformEvent> events = new ArrayList<PlatformEvent>();
        for (int i = 0; i < count; ++i) {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Requested " + count + " events, but only " + i + " are available.");
            }
            events.add(this.next());
        }
        return events;
    }

    public boolean hasNext();

    default public void forEachRemaining(@NonNull Consumer<PlatformEvent> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }
}

