/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public interface SimpleFeeContext
extends FeeContext {
    @Override
    public int numTxnSignatures();

    @Override
    public int numTxnBytes();

    @Nullable
    public FeeContext feeContext();

    @Nullable
    public QueryContext queryContext();

    @NonNull
    default public FeeContext requireFeeContext() {
        FeeContext context = this.feeContext();
        if (context == null) {
            throw new UnsupportedOperationException("FeeContext not available for this SimpleFeeContext");
        }
        return context;
    }

    @Override
    @NonNull
    default public AccountID payer() {
        return this.requireFeeContext().payer();
    }

    @Override
    @NonNull
    default public TransactionBody body() {
        return this.requireFeeContext().body();
    }

    @Override
    @NonNull
    default public FeeCalculatorFactory feeCalculatorFactory() {
        return this.requireFeeContext().feeCalculatorFactory();
    }

    @Override
    default public SimpleFeeCalculator getSimpleFeeCalculator() {
        return this.requireFeeContext().getSimpleFeeCalculator();
    }

    @Override
    @NonNull
    default public ReadableStoreFactory readableStoreFactory() {
        return this.requireFeeContext().readableStoreFactory();
    }

    @Override
    @NonNull
    default public <T> T readableStore(@NonNull Class<T> storeInterface) {
        return this.requireFeeContext().readableStore(storeInterface);
    }

    @Override
    @NonNull
    default public Configuration configuration() {
        return this.requireFeeContext().configuration();
    }

    @Override
    @Nullable
    default public Authorizer authorizer() {
        return this.requireFeeContext().authorizer();
    }

    @Override
    @NonNull
    default public Fees dispatchComputeFees(@NonNull TransactionBody txBody, @NonNull AccountID syntheticPayerId) {
        return this.requireFeeContext().dispatchComputeFees(txBody, syntheticPayerId);
    }

    @Override
    default public ExchangeRate activeRate() {
        return this.requireFeeContext().activeRate();
    }

    @Override
    default public long getGasPriceInTinycents() {
        return this.requireFeeContext().getGasPriceInTinycents();
    }
}

