/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.builder;

import com.swirlds.common.merkle.utility.SerializableLong;
import com.swirlds.platform.SwirldsPlatform;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.branching.DefaultBranchDetector;
import com.swirlds.platform.event.branching.DefaultBranchReporter;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.stream.DefaultConsensusEventStream;
import com.swirlds.platform.eventhandling.DefaultTransactionHandler;
import com.swirlds.platform.eventhandling.DefaultTransactionPrehandler;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.DefaultStateHasher;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.DefaultHashLogger;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.DefaultIssDetector;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.iss.IssScratchpad;
import com.swirlds.platform.state.iss.internal.DefaultIssHandler;
import com.swirlds.platform.state.signed.DefaultSignedStateSentinel;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signer.DefaultStateSigner;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.DefaultStateSnapshotManager;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.DefaultPlatformMonitor;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.pces.config.PcesConfig;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.DefaultStateGarbageCollector;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.StateGarbageCollector;

public class PlatformComponentBuilder {
    private final PlatformBuildingBlocks blocks;
    private StateGarbageCollector stateGarbageCollector;
    private ConsensusEventStream consensusEventStream;
    private SignedStateSentinel signedStateSentinel;
    private PlatformMonitor platformMonitor;
    private TransactionPrehandler transactionPrehandler;
    private IssDetector issDetector;
    private IssHandler issHandler;
    private StateHasher stateHasher;
    private StateSnapshotManager stateSnapshotManager;
    private HashLogger hashLogger;
    private BranchDetector branchDetector;
    private BranchReporter branchReporter;
    private StateSigner stateSigner;
    private TransactionHandler transactionHandler;
    private SwirldsPlatform swirldsPlatform;
    private boolean used;

    public PlatformComponentBuilder(@NonNull PlatformBuildingBlocks blocks) {
        this.blocks = Objects.requireNonNull(blocks);
    }

    @NonNull
    public PlatformBuildingBlocks getBuildingBlocks() {
        return this.blocks;
    }

    private void throwIfAlreadyUsed() {
        if (this.used) {
            throw new IllegalStateException("PlatformBuilder has already been used");
        }
    }

    @NonNull
    public Platform build() {
        this.throwIfAlreadyUsed();
        this.used = true;
        try {
            SwirldsPlatform swirldsPlatform;
            block9: {
                ReservedSignedState ignored = this.blocks.initialState();
                try {
                    swirldsPlatform = this.swirldsPlatform = new SwirldsPlatform(this);
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return swirldsPlatform;
        }
        finally {
            StaticPlatformBuilder.getMetricsProvider().start();
        }
    }

    public PlatformComponentBuilder withStateGarbageCollector(@NonNull StateGarbageCollector stateGarbageCollector) {
        this.throwIfAlreadyUsed();
        if (this.stateGarbageCollector != null) {
            throw new IllegalStateException("State garbage collector has already been set");
        }
        this.stateGarbageCollector = Objects.requireNonNull(stateGarbageCollector);
        return this;
    }

    @NonNull
    public StateGarbageCollector buildStateGarbageCollector() {
        if (this.stateGarbageCollector == null) {
            this.stateGarbageCollector = new DefaultStateGarbageCollector(this.blocks.platformContext().getMetrics());
        }
        return this.stateGarbageCollector;
    }

    @NonNull
    public PlatformComponentBuilder withConsensusEventStream(@NonNull ConsensusEventStream consensusEventStream) {
        this.throwIfAlreadyUsed();
        if (this.consensusEventStream != null) {
            throw new IllegalStateException("Consensus event stream has already been set");
        }
        this.consensusEventStream = Objects.requireNonNull(consensusEventStream);
        return this;
    }

    @NonNull
    public ConsensusEventStream buildConsensusEventStream() {
        if (this.consensusEventStream == null) {
            this.consensusEventStream = new DefaultConsensusEventStream(this.blocks.platformContext(), this.blocks.selfId(), data -> new PlatformSigner(this.blocks.keysAndCerts()).sign(data), this.blocks.consensusEventStreamName(), event -> event.isLastInRoundReceived() && this.blocks.freezeChecker().isInFreezePeriod(event.getPlatformEvent().getConsensusTimestamp()));
        }
        return this.consensusEventStream;
    }

    @NonNull
    public PlatformComponentBuilder withPlatformMonitor(@NonNull PlatformMonitor platformMonitor) {
        this.throwIfAlreadyUsed();
        if (this.platformMonitor != null) {
            throw new IllegalStateException("Status state machine has already been set");
        }
        this.platformMonitor = Objects.requireNonNull(platformMonitor);
        return this;
    }

    @NonNull
    public PlatformMonitor buildPlatformMonitor() {
        if (this.platformMonitor == null) {
            this.platformMonitor = new DefaultPlatformMonitor(this.blocks.platformContext(), this.blocks.selfId());
        }
        return this.platformMonitor;
    }

    @NonNull
    public PlatformComponentBuilder withSignedStateSentinel(@NonNull SignedStateSentinel signedStateSentinel) {
        this.throwIfAlreadyUsed();
        if (this.signedStateSentinel != null) {
            throw new IllegalStateException("Signed state sentinel has already been set");
        }
        this.signedStateSentinel = Objects.requireNonNull(signedStateSentinel);
        return this;
    }

    @NonNull
    public SignedStateSentinel buildSignedStateSentinel() {
        if (this.signedStateSentinel == null) {
            this.signedStateSentinel = new DefaultSignedStateSentinel(this.blocks.platformContext());
        }
        return this.signedStateSentinel;
    }

    @NonNull
    public PlatformComponentBuilder withTransactionPrehandler(@NonNull TransactionPrehandler transactionPrehandler) {
        this.throwIfAlreadyUsed();
        if (this.transactionPrehandler != null) {
            throw new IllegalStateException("Transaction prehandler has already been set");
        }
        this.transactionPrehandler = Objects.requireNonNull(transactionPrehandler);
        return this;
    }

    @NonNull
    public TransactionPrehandler buildTransactionPrehandler() {
        if (this.transactionPrehandler == null) {
            this.transactionPrehandler = new DefaultTransactionPrehandler(this.blocks.platformContext(), () -> this.blocks.latestImmutableStateProviderReference().get().apply("transaction prehandle"), this.blocks.consensusStateEventHandler());
        }
        return this.transactionPrehandler;
    }

    @NonNull
    public PlatformComponentBuilder withIssDetector(@NonNull IssDetector issDetector) {
        this.throwIfAlreadyUsed();
        if (this.issDetector != null) {
            throw new IllegalStateException("ISS detector has already been set");
        }
        this.issDetector = Objects.requireNonNull(issDetector);
        return this;
    }

    @NonNull
    public IssDetector buildIssDetector() {
        if (this.issDetector == null) {
            SerializableLong issRound = (SerializableLong)this.blocks.issScratchpad().get(IssScratchpad.LAST_ISS_ROUND);
            boolean forceIgnorePcesSignatures = ((PcesConfig)this.blocks.platformContext().getConfiguration().getConfigData(PcesConfig.class)).forceIgnorePcesSignatures();
            long initialStateRound = this.blocks.initialState().get().getRound();
            boolean ignorePreconsensusSignatures = forceIgnorePcesSignatures ? true : issRound != null && issRound.getValue() >= initialStateRound;
            long roundToIgnore = ((StateConfig)this.blocks.platformContext().getConfiguration().getConfigData(StateConfig.class)).validateInitialState() ? -1L : initialStateRound;
            long latestFreezeRound = PlatformStateUtils.latestFreezeRoundOf((State)this.blocks.initialState().get().getState());
            this.issDetector = new DefaultIssDetector(this.blocks.platformContext(), this.blocks.rosterHistory().getCurrentRoster(), ignorePreconsensusSignatures, roundToIgnore, latestFreezeRound);
        }
        return this.issDetector;
    }

    @NonNull
    public PlatformComponentBuilder withIssHandler(@NonNull IssHandler issHandler) {
        this.throwIfAlreadyUsed();
        if (this.issHandler != null) {
            throw new IllegalStateException("ISS handler has already been set");
        }
        this.issHandler = Objects.requireNonNull(issHandler);
        return this;
    }

    @NonNull
    public IssHandler buildIssHandler() {
        if (this.issHandler == null) {
            this.issHandler = new DefaultIssHandler(this.blocks.platformContext(), SystemExitUtils::handleFatalError, this.blocks.issScratchpad());
        }
        return this.issHandler;
    }

    @NonNull
    public PlatformComponentBuilder withStateHasher(@NonNull StateHasher stateHasher) {
        this.throwIfAlreadyUsed();
        if (this.stateHasher != null) {
            throw new IllegalStateException("Signed state hasher has already been set");
        }
        this.stateHasher = Objects.requireNonNull(stateHasher);
        return this;
    }

    @NonNull
    public StateHasher buildStateHasher() {
        if (this.stateHasher == null) {
            this.stateHasher = new DefaultStateHasher(this.blocks.platformContext());
        }
        return this.stateHasher;
    }

    @NonNull
    public PlatformComponentBuilder withStateSnapshotManager(@NonNull StateSnapshotManager stateSnapshotManager) {
        this.throwIfAlreadyUsed();
        if (this.stateSnapshotManager != null) {
            throw new IllegalStateException("State snapshot manager has already been set");
        }
        this.stateSnapshotManager = Objects.requireNonNull(stateSnapshotManager);
        return this;
    }

    @NonNull
    public StateSnapshotManager buildStateSnapshotManager() {
        if (this.stateSnapshotManager == null) {
            StateConfig stateConfig = (StateConfig)this.blocks.platformContext().getConfiguration().getConfigData(StateConfig.class);
            String actualMainClassName = stateConfig.getMainClassName(this.blocks.mainClassName());
            this.stateSnapshotManager = new DefaultStateSnapshotManager(this.blocks.platformContext(), actualMainClassName, this.blocks.selfId(), this.blocks.swirldName(), this.blocks.stateLifecycleManager());
        }
        return this.stateSnapshotManager;
    }

    @NonNull
    public PlatformComponentBuilder withHashLogger(@NonNull HashLogger hashLogger) {
        this.throwIfAlreadyUsed();
        if (this.hashLogger != null) {
            throw new IllegalStateException("Hash logger has already been set");
        }
        this.hashLogger = Objects.requireNonNull(hashLogger);
        return this;
    }

    @NonNull
    public HashLogger buildHashLogger() {
        if (this.hashLogger == null) {
            this.hashLogger = new DefaultHashLogger(this.blocks.platformContext());
        }
        return this.hashLogger;
    }

    @NonNull
    public PlatformComponentBuilder withBranchDetector(@NonNull BranchDetector branchDetector) {
        this.throwIfAlreadyUsed();
        if (this.branchDetector != null) {
            throw new IllegalStateException("Branch detector has already been set");
        }
        this.branchDetector = Objects.requireNonNull(branchDetector);
        return this;
    }

    @NonNull
    public BranchDetector buildBranchDetector() {
        if (this.branchDetector == null) {
            this.branchDetector = new DefaultBranchDetector(this.blocks.rosterHistory().getCurrentRoster());
        }
        return this.branchDetector;
    }

    @NonNull
    public PlatformComponentBuilder withBranchReporter(@NonNull BranchReporter branchReporter) {
        this.throwIfAlreadyUsed();
        if (this.branchReporter != null) {
            throw new IllegalStateException("Branch reporter has already been set");
        }
        this.branchReporter = Objects.requireNonNull(branchReporter);
        return this;
    }

    @NonNull
    public BranchReporter buildBranchReporter() {
        if (this.branchReporter == null) {
            this.branchReporter = new DefaultBranchReporter(this.blocks.platformContext(), this.blocks.rosterHistory().getCurrentRoster());
        }
        return this.branchReporter;
    }

    public PlatformComponentBuilder withStateSigner(@NonNull StateSigner stateSigner) {
        this.throwIfAlreadyUsed();
        if (this.stateSigner != null) {
            throw new IllegalStateException("State signer has already been set");
        }
        this.stateSigner = Objects.requireNonNull(stateSigner);
        return this;
    }

    @NonNull
    public StateSigner buildStateSigner() {
        if (this.stateSigner == null) {
            this.stateSigner = new DefaultStateSigner(new PlatformSigner(this.blocks.keysAndCerts()));
        }
        return this.stateSigner;
    }

    @NonNull
    public PlatformComponentBuilder withTransactionHandler(@NonNull TransactionHandler transactionHandler) {
        this.throwIfAlreadyUsed();
        if (this.transactionHandler != null) {
            throw new IllegalStateException("Transaction handler has already been set");
        }
        this.transactionHandler = Objects.requireNonNull(transactionHandler);
        return this;
    }

    @NonNull
    public TransactionHandler buildTransactionHandler() {
        if (this.transactionHandler == null) {
            this.transactionHandler = new DefaultTransactionHandler(this.blocks.platformContext(), this.blocks.stateLifecycleManager(), this.blocks.statusActionSubmitterReference().get(), this.blocks.appVersion(), this.blocks.consensusStateEventHandler(), this.blocks.selfId());
        }
        return this.transactionHandler;
    }
}

