/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.transaction.ThrottleBucket;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ThrottleBucketJsonCodec
implements JsonCodec<ThrottleBucket> {
    @NonNull
    public ThrottleBucket parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth, int maxSize) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_name = "";
            long temp_burstPeriodMs = 0L;
            List temp_throttleGroups = Collections.emptyList();
            boolean temp_high_volume = false;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "name": {
                        temp_name = JsonTools.unescape((String)JsonTools.checkSize((String)"name", (String)kvPair.value().STRING().getText(), (int)maxSize));
                        continue block14;
                    }
                    case "burstPeriodMs": {
                        temp_burstPeriodMs = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "throttleGroups": {
                        temp_throttleGroups = JsonTools.parseObjArray((List)JsonTools.checkSize((String)"throttleGroups", (List)kvPair.value().arr().value(), (int)maxSize), ThrottleGroup.JSON, (int)(maxDepth - 1), (int)maxSize);
                        continue block14;
                    }
                    case "highVolume": {
                        temp_high_volume = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ThrottleBucket(temp_name, temp_burstPeriodMs, temp_throttleGroups, temp_high_volume);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ThrottleBucket data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.name() != null && !data.name().isEmpty()) {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.burstPeriodMs() != 0L) {
            fieldLines.add(JsonTools.field((String)"burstPeriodMs", (long)data.burstPeriodMs()));
        }
        if (!data.throttleGroups().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"throttleGroups", ThrottleGroup.JSON, data.throttleGroups()));
        }
        if (data.highVolume()) {
            fieldLines.add(JsonTools.field((String)"highVolume", (boolean)data.highVolume()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

