/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl;

import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.file.FileService;
import com.hedera.node.app.service.file.impl.calculator.FileAppendFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileCreateFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileDeleteFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileGetContentsFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileGetInfoFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileSystemDeleteFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileSystemUndeleteFeeCalculator;
import com.hedera.node.app.service.file.impl.calculator.FileUpdateFeeCalculator;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.workflows.SystemContext;
import com.hedera.node.config.data.FeesConfig;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import javax.inject.Inject;

public final class FileServiceImpl
implements FileService {
    public static final long THREE_MONTHS_IN_SECONDS = 7776000L;
    public static final String DEFAULT_MEMO = "";
    private final V0490FileSchema fileSchema = new V0490FileSchema();

    @Inject
    public FileServiceImpl() {
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.register((Schema)this.fileSchema);
    }

    public void createSystemEntities(@NonNull SystemContext context, @NonNull ReadableNodeStore nodeStore) {
        this.fileSchema.createGenesisAddressBookAndNodeDetails(context, nodeStore);
        this.fileSchema.createGenesisFeeSchedule(context);
        this.fileSchema.createGenesisExchangeRate(context);
        if (((FeesConfig)context.configuration().getConfigData(FeesConfig.class)).createSimpleFeeSchedule()) {
            this.fileSchema.createGenesisSimpleFeesSchedule(context);
        }
        this.fileSchema.createGenesisNetworkProperties(context);
        this.fileSchema.createGenesisHapiPermissions(context);
        this.fileSchema.createGenesisThrottleDefinitions(context);
        this.fileSchema.createGenesisSoftwareUpdateFiles(context);
    }

    public V0490FileSchema fileSchema() {
        return this.fileSchema;
    }

    public void updateAddressBookAndNodeDetailsAfterFreeze(@NonNull SystemContext context, @NonNull ReadableNodeStore nodeStore) {
        this.fileSchema.updateAddressBookAndNodeDetailsAfterFreeze(context, nodeStore);
    }

    public Set<ServiceFeeCalculator> serviceFeeCalculators() {
        return Set.of(new FileCreateFeeCalculator(), new FileUpdateFeeCalculator(), new FileDeleteFeeCalculator(), new FileAppendFeeCalculator(), new FileSystemDeleteFeeCalculator(), new FileSystemUndeleteFeeCalculator());
    }

    public Set<QueryFeeCalculator> queryFeeCalculators() {
        return Set.of(new FileGetContentsFeeCalculator(), new FileGetInfoFeeCalculator());
    }
}

