/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.stream.RunningEventHashOverride;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.StateInitializer;
import com.swirlds.platform.builder.ConsensusModuleBuilder;
import com.swirlds.platform.builder.PlatformBuildingBlocks;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.builder.internal.StaticPlatformBuilder;
import com.swirlds.platform.components.DefaultAppNotifier;
import com.swirlds.platform.components.DefaultEventWindowManager;
import com.swirlds.platform.components.DefaultSavedStateController;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.metrics.RuntimeMetrics;
import com.swirlds.platform.reconnect.ReconnectModule;
import com.swirlds.platform.state.address.RosterMetrics;
import com.swirlds.platform.state.nexus.DefaultLatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.DefaultStateSignatureCollector;
import com.swirlds.platform.state.signed.SignedStateMetrics;
import com.swirlds.platform.state.snapshot.SavedStateInfo;
import com.swirlds.platform.state.snapshot.SignedStateFilePath;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformCoordinator;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.hashgraph.config.ConsensusConfig;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.round.EventWindowUtils;
import org.hiero.consensus.state.config.StateConfig;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class SwirldsPlatform
implements Platform {
    private static final Logger logger = LogManager.getLogger(SwirldsPlatform.class);
    private final NodeId selfId;
    private final Roster currentRoster;
    private final KeysAndCerts keysAndCerts;
    private final long initialAncientThreshold;
    private final long startingRound;
    private final SignedStateNexus latestImmutableStateNexus;
    private final NotificationEngine notificationEngine;
    private final PlatformContext platformContext;
    private final SavedStateController savedStateController;
    private final PlatformComponents platformComponents;
    private final long pcesReplayLowerBound;
    private final PlatformCoordinator platformCoordinator;

    public SwirldsPlatform(@NonNull PlatformComponentBuilder builder) {
        PlatformBuildingBlocks blocks = builder.getBuildingBlocks();
        this.platformContext = blocks.platformContext();
        SignedState initialState = blocks.initialState().get();
        this.selfId = blocks.selfId();
        this.notificationEngine = blocks.notificationEngine();
        logger.info(LogMarker.STARTUP.getMarker(), "Starting with roster history:\n{}", (Object)blocks.rosterHistory());
        this.currentRoster = blocks.rosterHistory().getCurrentRoster();
        Metrics metrics = this.platformContext.getMetrics();
        RosterMetrics.registerRosterMetrics(metrics, this.currentRoster, this.selfId);
        RuntimeMetrics.setup(metrics);
        this.keysAndCerts = blocks.keysAndCerts();
        DefaultLatestCompleteStateNexus latestCompleteStateNexus = new DefaultLatestCompleteStateNexus(this.platformContext);
        this.savedStateController = new DefaultSavedStateController(this.platformContext);
        SignedStateMetrics signedStateMetrics = new SignedStateMetrics(metrics);
        DefaultStateSignatureCollector stateSignatureCollector = new DefaultStateSignatureCollector(this.platformContext, signedStateMetrics);
        this.platformComponents = blocks.platformComponents();
        this.platformCoordinator = blocks.platformCoordinator();
        this.latestImmutableStateNexus = blocks.latestImmutableStateNexus();
        blocks.statusActionSubmitterReference().set(this.platformCoordinator);
        Configuration configuration = this.platformContext.getConfiguration();
        StateInitializer.initializeState(this, initialState, blocks.consensusStateEventHandler());
        StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager = blocks.stateLifecycleManager();
        VirtualMapState state = initialState.getState();
        stateLifecycleManager.initState((Object)state);
        if (!initialState.isGenesisState()) {
            PlatformStateUtils.setCreationSoftwareVersionTo((State)((State)stateLifecycleManager.getMutableState()), (SemanticVersion)blocks.appVersion());
        }
        DefaultEventWindowManager eventWindowManager = new DefaultEventWindowManager();
        DefaultAppNotifier appNotifier = new DefaultAppNotifier(blocks.notificationEngine());
        ReconnectModule reconnectModule = ConsensusModuleBuilder.createReconnectModule();
        reconnectModule.initialize(configuration, this.platformContext.getTime(), this.currentRoster, this.platformComponents, this, this.platformCoordinator, stateLifecycleManager, this.savedStateController, blocks.consensusStateEventHandler(), blocks.reservedSignedStateResultPromise(), this.selfId, blocks.fallenBehindMonitor());
        this.platformComponents.bind(builder, stateSignatureCollector, eventWindowManager, this.latestImmutableStateNexus, latestCompleteStateNexus, this.savedStateController, appNotifier);
        Hash legacyRunningEventHash = PlatformStateUtils.legacyRunningEventHashOf((State)initialState.getState()) == null ? Cryptography.NULL_HASH : PlatformStateUtils.legacyRunningEventHashOf((State)initialState.getState());
        RunningEventHashOverride runningEventHashOverride = new RunningEventHashOverride(legacyRunningEventHash, false);
        this.platformCoordinator.updateRunningHash(runningEventHashOverride);
        String actualMainClassName = ((StateConfig)configuration.getConfigData(StateConfig.class)).getMainClassName(blocks.mainClassName());
        SignedStateFilePath statePath = new SignedStateFilePath((StateCommonConfig)configuration.getConfigData(StateCommonConfig.class));
        List<SavedStateInfo> savedStates = statePath.getSavedStateFiles(actualMainClassName, this.selfId, blocks.swirldName());
        if (!savedStates.isEmpty()) {
            long minimumGenerationNonAncientForOldestState = savedStates.get(savedStates.size() - 1).metadata().minimumBirthRoundNonAncient();
            this.platformCoordinator.injectPcesMinimumBirthRoundToStore(minimumGenerationNonAncientForOldestState);
        }
        boolean startedFromGenesis = initialState.isGenesisState();
        this.latestImmutableStateNexus.setState(initialState.reserve("set latest immutable to initial state"));
        if (startedFromGenesis) {
            this.initialAncientThreshold = 0L;
            this.startingRound = 0L;
            this.platformCoordinator.updateEventWindow(EventWindow.getGenesisEventWindow());
        } else {
            this.initialAncientThreshold = PlatformStateUtils.ancientThresholdOf((State)initialState.getState());
            this.startingRound = initialState.getRound();
            this.platformCoordinator.sendStateToHashLogger(initialState);
            this.platformCoordinator.injectSignatureCollectorState(initialState.reserve("loading initial state into sig collector"));
            this.savedStateController.registerSignedStateFromDisk(initialState);
            ConsensusSnapshot consensusSnapshot = Objects.requireNonNull(PlatformStateUtils.consensusSnapshotOf((State)initialState.getState()));
            this.platformCoordinator.consensusSnapshotOverride(consensusSnapshot);
            int roundsNonAncient = ((ConsensusConfig)configuration.getConfigData(ConsensusConfig.class)).roundsNonAncient();
            this.platformCoordinator.updateEventWindow(EventWindowUtils.createEventWindow((ConsensusSnapshot)consensusSnapshot, (int)roundsNonAncient));
            this.platformCoordinator.overrideIssDetectorState(initialState.reserve("initialize issDetector"));
        }
        blocks.getLatestCompleteStateReference().set(() -> latestCompleteStateNexus.getState("get latest complete state for reconnect"));
        blocks.latestImmutableStateProviderReference().set(this.latestImmutableStateNexus::getState);
        this.pcesReplayLowerBound = !initialState.isGenesisState() ? this.initialAncientThreshold : 0L;
    }

    @Override
    @NonNull
    public NodeId getSelfId() {
        return this.selfId;
    }

    @Override
    public void start() {
        logger.info(LogMarker.STARTUP.getMarker(), "Starting platform {}", (Object)this.selfId);
        this.platformContext.getRecycleBin().start();
        this.platformContext.getMetrics().start();
        this.platformCoordinator.start();
        this.platformComponents.pcesModule().replayPcesEvents(this.pcesReplayLowerBound, this.startingRound);
        this.platformCoordinator.startGossip();
    }

    @Override
    public void destroy() throws InterruptedException {
        this.notificationEngine.shutdown();
        this.platformContext.getRecycleBin().stop();
        this.platformCoordinator.stop();
        StaticPlatformBuilder.getMetricsProvider().removePlatformMetrics(this.selfId);
    }

    @Override
    @NonNull
    public PlatformContext getContext() {
        return this.platformContext;
    }

    @Override
    @NonNull
    public NotificationEngine getNotificationEngine() {
        return this.notificationEngine;
    }

    @Override
    @NonNull
    public Signature sign(@NonNull byte[] data) {
        return new PlatformSigner(this.keysAndCerts).sign(data);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        this.platformCoordinator.quiescenceCommand(quiescenceCommand);
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.currentRoster;
    }

    @Override
    @NonNull
    public <T extends State> AutoCloseableWrapper<T> getLatestImmutableState(@NonNull String reason) {
        ReservedSignedState wrapper = this.latestImmutableStateNexus.getState(reason);
        return wrapper == null ? AutoCloseableWrapper.empty() : new AutoCloseableWrapper((Object)wrapper.get().getState(), () -> ((ReservedSignedState)wrapper).close());
    }
}

