/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event;

import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.metrics.FunctionGauge;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class FutureEventBuffer {
    private static final Function<Long, List<PlatformEvent>> BUILD_LIST = x -> new ArrayList();
    private final FutureEventBufferingOption bufferingOption;
    private EventWindow eventWindow;
    private final SequenceMap<Long, List<PlatformEvent>> futureEvents = new StandardSequenceMap(1L, 8, true, x -> x);
    private final AtomicLong bufferedEventCount = new AtomicLong(0L);
    final LongGauge maxBufferedBirthRoundMetric;

    public FutureEventBuffer(@NonNull Metrics metrics, @NonNull FutureEventBufferingOption bufferingOption, @NonNull String name) {
        this.bufferingOption = bufferingOption;
        this.eventWindow = EventWindow.getGenesisEventWindow();
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("platform", "futureEventBuffer_%s_count".formatted(name), Long.class, this.bufferedEventCount::get).withDescription(String.format("the number of events sitting in the %s future event buffer", name)).withUnit("count"));
        this.maxBufferedBirthRoundMetric = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config("platform", "futureEventBuffer_%s_maxBR".formatted(name)).withDescription("the maximum birth round of events in the future event buffer").withUnit("BR"));
    }

    @Nullable
    public PlatformEvent addEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            return null;
        }
        if (event.getBirthRound() <= this.bufferingOption.getMaximumReleasableRound(this.eventWindow)) {
            return event;
        }
        ((List)this.futureEvents.computeIfAbsent((Object)event.getBirthRound(), BUILD_LIST)).add(event);
        this.bufferedEventCount.incrementAndGet();
        this.maxBufferedBirthRoundMetric.set(Math.max(this.maxBufferedBirthRoundMetric.get(), event.getBirthRound()));
        return null;
    }

    @NonNull
    public List<PlatformEvent> updateEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        long oldestRoundToBuffer = this.bufferingOption.getOldestRoundToBuffer(eventWindow);
        ArrayList<PlatformEvent> events = new ArrayList<PlatformEvent>();
        this.futureEvents.shiftWindow(oldestRoundToBuffer, (round, roundEvents) -> {
            for (PlatformEvent event : roundEvents) {
                if (eventWindow.isAncient(event)) continue;
                events.add(event);
            }
        });
        this.bufferedEventCount.addAndGet(-events.size());
        return events;
    }

    public void clear() {
        this.futureEvents.clear();
    }
}

