/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.system.status.logic;

import com.swirlds.platform.system.status.IllegalPlatformStatusException;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.system.status.actions.CatastrophicFailureAction;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import com.swirlds.platform.system.status.actions.FreezePeriodEnteredAction;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.platform.system.status.actions.SelfEventReachedConsensusAction;
import com.swirlds.platform.system.status.actions.StateWrittenToDiskAction;
import com.swirlds.platform.system.status.actions.TimeElapsedAction;
import com.swirlds.platform.system.status.logic.ActiveStatusLogic;
import com.swirlds.platform.system.status.logic.BehindStatusLogic;
import com.swirlds.platform.system.status.logic.CatastrophicFailureStatusLogic;
import com.swirlds.platform.system.status.logic.FreezeCompleteStatusLogic;
import com.swirlds.platform.system.status.logic.FreezingStatusLogic;
import com.swirlds.platform.system.status.logic.PlatformStatusLogic;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.pces.actions.DoneReplayingEventsAction;
import org.hiero.consensus.pces.actions.StartedReplayingEventsAction;

public class CheckingStatusLogic
implements PlatformStatusLogic {
    private final PlatformStatusConfig config;

    public CheckingStatusLogic(@NonNull PlatformStatusConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processCatastrophicFailureAction(@NonNull CatastrophicFailureAction action) {
        return new CatastrophicFailureStatusLogic();
    }

    @Override
    @NonNull
    public PlatformStatusLogic processDoneReplayingEventsAction(@NonNull DoneReplayingEventsAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException((PlatformStatusAction)action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFallenBehindAction(@NonNull FallenBehindAction action) {
        return new BehindStatusLogic(this.config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processFreezePeriodEnteredAction(@NonNull FreezePeriodEnteredAction action) {
        return new FreezingStatusLogic(action.freezeRound());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processReconnectCompleteAction(@NonNull ReconnectCompleteAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException(action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processSelfEventReachedConsensusAction(@NonNull SelfEventReachedConsensusAction action) {
        return new ActiveStatusLogic(action.wallClockTime(), this.config);
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStartedReplayingEventsAction(@NonNull StartedReplayingEventsAction action) {
        Objects.requireNonNull(action);
        throw new IllegalPlatformStatusException((PlatformStatusAction)action, this.getStatus());
    }

    @Override
    @NonNull
    public PlatformStatusLogic processStateWrittenToDiskAction(@NonNull StateWrittenToDiskAction action) {
        Objects.requireNonNull(action);
        return action.isFreezeState() ? new FreezeCompleteStatusLogic() : this;
    }

    @Override
    @NonNull
    public PlatformStatusLogic processTimeElapsedAction(@NonNull TimeElapsedAction action) {
        if (action.quiescingStatus().isQuiescing()) {
            return new ActiveStatusLogic(action.instant(), this.config);
        }
        return this;
    }

    @Override
    @NonNull
    public PlatformStatus getStatus() {
        return PlatformStatus.CHECKING;
    }
}

