/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;

public final class HandlerUtility {
    private HandlerUtility() {
    }

    @NonNull
    public static TransactionBody childAsOrdinary(@NonNull Schedule scheduleInState) {
        TransactionID scheduledTransactionId = HandlerUtility.transactionIdForScheduled(scheduleInState);
        TransactionBody.Builder ordinary = TransactionBody.newBuilder();
        SchedulableTransactionBody scheduledBody = scheduleInState.scheduledTransaction();
        if (scheduledBody != null) {
            ordinary.transactionFee(scheduledBody.transactionFee()).memo(scheduledBody.memo()).maxCustomFees(scheduledBody.maxCustomFees()).transactionID(scheduledTransactionId);
            switch ((SchedulableTransactionBody.DataOneOfType)scheduledBody.data().kind()) {
                case CONSENSUS_CREATE_TOPIC: {
                    ordinary.consensusCreateTopic(scheduledBody.consensusCreateTopicOrThrow());
                    break;
                }
                case CONSENSUS_UPDATE_TOPIC: {
                    ordinary.consensusUpdateTopic(scheduledBody.consensusUpdateTopicOrThrow());
                    break;
                }
                case CONSENSUS_DELETE_TOPIC: {
                    ordinary.consensusDeleteTopic(scheduledBody.consensusDeleteTopicOrThrow());
                    break;
                }
                case CONSENSUS_SUBMIT_MESSAGE: {
                    ordinary.consensusSubmitMessage(scheduledBody.consensusSubmitMessageOrThrow());
                    break;
                }
                case CRYPTO_CREATE_ACCOUNT: {
                    ordinary.cryptoCreateAccount(scheduledBody.cryptoCreateAccountOrThrow());
                    break;
                }
                case CRYPTO_UPDATE_ACCOUNT: {
                    ordinary.cryptoUpdateAccount(scheduledBody.cryptoUpdateAccountOrThrow());
                    break;
                }
                case CRYPTO_TRANSFER: {
                    ordinary.cryptoTransfer(scheduledBody.cryptoTransferOrThrow());
                    break;
                }
                case CRYPTO_DELETE: {
                    ordinary.cryptoDelete(scheduledBody.cryptoDeleteOrThrow());
                    break;
                }
                case FILE_CREATE: {
                    ordinary.fileCreate(scheduledBody.fileCreateOrThrow());
                    break;
                }
                case FILE_APPEND: {
                    ordinary.fileAppend(scheduledBody.fileAppendOrThrow());
                    break;
                }
                case FILE_UPDATE: {
                    ordinary.fileUpdate(scheduledBody.fileUpdateOrThrow());
                    break;
                }
                case FILE_DELETE: {
                    ordinary.fileDelete(scheduledBody.fileDeleteOrThrow());
                    break;
                }
                case CONTRACT_CREATE_INSTANCE: {
                    ordinary.contractCreateInstance(scheduledBody.contractCreateInstanceOrThrow());
                    break;
                }
                case CONTRACT_UPDATE_INSTANCE: {
                    ordinary.contractUpdateInstance(scheduledBody.contractUpdateInstanceOrThrow());
                    break;
                }
                case CONTRACT_CALL: {
                    ordinary.contractCall(scheduledBody.contractCallOrThrow());
                    break;
                }
                case CONTRACT_DELETE_INSTANCE: {
                    ordinary.contractDeleteInstance(scheduledBody.contractDeleteInstanceOrThrow());
                    break;
                }
                case SYSTEM_DELETE: {
                    ordinary.systemDelete(scheduledBody.systemDeleteOrThrow());
                    break;
                }
                case SYSTEM_UNDELETE: {
                    ordinary.systemUndelete(scheduledBody.systemUndeleteOrThrow());
                    break;
                }
                case FREEZE: {
                    ordinary.freeze(scheduledBody.freezeOrThrow());
                    break;
                }
                case TOKEN_CREATION: {
                    ordinary.tokenCreation(scheduledBody.tokenCreationOrThrow());
                    break;
                }
                case TOKEN_FREEZE: {
                    ordinary.tokenFreeze(scheduledBody.tokenFreezeOrThrow());
                    break;
                }
                case TOKEN_UNFREEZE: {
                    ordinary.tokenUnfreeze(scheduledBody.tokenUnfreezeOrThrow());
                    break;
                }
                case TOKEN_GRANT_KYC: {
                    ordinary.tokenGrantKyc(scheduledBody.tokenGrantKycOrThrow());
                    break;
                }
                case TOKEN_REVOKE_KYC: {
                    ordinary.tokenRevokeKyc(scheduledBody.tokenRevokeKycOrThrow());
                    break;
                }
                case TOKEN_DELETION: {
                    ordinary.tokenDeletion(scheduledBody.tokenDeletionOrThrow());
                    break;
                }
                case TOKEN_UPDATE: {
                    ordinary.tokenUpdate(scheduledBody.tokenUpdateOrThrow());
                    break;
                }
                case TOKEN_MINT: {
                    ordinary.tokenMint(scheduledBody.tokenMintOrThrow());
                    break;
                }
                case TOKEN_BURN: {
                    ordinary.tokenBurn(scheduledBody.tokenBurnOrThrow());
                    break;
                }
                case TOKEN_WIPE: {
                    ordinary.tokenWipe(scheduledBody.tokenWipeOrThrow());
                    break;
                }
                case TOKEN_ASSOCIATE: {
                    ordinary.tokenAssociate(scheduledBody.tokenAssociateOrThrow());
                    break;
                }
                case TOKEN_DISSOCIATE: {
                    ordinary.tokenDissociate(scheduledBody.tokenDissociateOrThrow());
                    break;
                }
                case SCHEDULE_DELETE: {
                    ordinary.scheduleDelete(scheduledBody.scheduleDeleteOrThrow());
                    break;
                }
                case TOKEN_PAUSE: {
                    ordinary.tokenPause(scheduledBody.tokenPauseOrThrow());
                    break;
                }
                case TOKEN_UNPAUSE: {
                    ordinary.tokenUnpause(scheduledBody.tokenUnpauseOrThrow());
                    break;
                }
                case CRYPTO_APPROVE_ALLOWANCE: {
                    ordinary.cryptoApproveAllowance(scheduledBody.cryptoApproveAllowanceOrThrow());
                    break;
                }
                case CRYPTO_DELETE_ALLOWANCE: {
                    ordinary.cryptoDeleteAllowance(scheduledBody.cryptoDeleteAllowanceOrThrow());
                    break;
                }
                case TOKEN_FEE_SCHEDULE_UPDATE: {
                    ordinary.tokenFeeScheduleUpdate(scheduledBody.tokenFeeScheduleUpdateOrThrow());
                    break;
                }
                case UTIL_PRNG: {
                    ordinary.utilPrng(scheduledBody.utilPrngOrThrow());
                    break;
                }
                case TOKEN_REJECT: {
                    ordinary.tokenReject(scheduledBody.tokenRejectOrThrow());
                    break;
                }
                case NODE_CREATE: {
                    ordinary.nodeCreate(scheduledBody.nodeCreateOrThrow());
                    break;
                }
                case NODE_UPDATE: {
                    ordinary.nodeUpdate(scheduledBody.nodeUpdateOrThrow());
                    break;
                }
                case NODE_DELETE: {
                    ordinary.nodeDelete(scheduledBody.nodeDeleteOrThrow());
                    break;
                }
                case UNSET: {
                    throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION);
                }
            }
        }
        return ordinary.build();
    }

    public static HederaFunctionality functionalityForType(@NonNull SchedulableTransactionBody.DataOneOfType transactionType) {
        Objects.requireNonNull(transactionType);
        return switch (transactionType) {
            default -> throw new MatchException(null, null);
            case SchedulableTransactionBody.DataOneOfType.CONSENSUS_CREATE_TOPIC -> HederaFunctionality.CONSENSUS_CREATE_TOPIC;
            case SchedulableTransactionBody.DataOneOfType.CONSENSUS_UPDATE_TOPIC -> HederaFunctionality.CONSENSUS_UPDATE_TOPIC;
            case SchedulableTransactionBody.DataOneOfType.CONSENSUS_DELETE_TOPIC -> HederaFunctionality.CONSENSUS_DELETE_TOPIC;
            case SchedulableTransactionBody.DataOneOfType.CONSENSUS_SUBMIT_MESSAGE -> HederaFunctionality.CONSENSUS_SUBMIT_MESSAGE;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_CREATE_ACCOUNT -> HederaFunctionality.CRYPTO_CREATE;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_UPDATE_ACCOUNT -> HederaFunctionality.CRYPTO_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_TRANSFER -> HederaFunctionality.CRYPTO_TRANSFER;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_DELETE -> HederaFunctionality.CRYPTO_DELETE;
            case SchedulableTransactionBody.DataOneOfType.FILE_CREATE -> HederaFunctionality.FILE_CREATE;
            case SchedulableTransactionBody.DataOneOfType.FILE_APPEND -> HederaFunctionality.FILE_APPEND;
            case SchedulableTransactionBody.DataOneOfType.FILE_UPDATE -> HederaFunctionality.FILE_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.FILE_DELETE -> HederaFunctionality.FILE_DELETE;
            case SchedulableTransactionBody.DataOneOfType.SYSTEM_DELETE -> HederaFunctionality.SYSTEM_DELETE;
            case SchedulableTransactionBody.DataOneOfType.SYSTEM_UNDELETE -> HederaFunctionality.SYSTEM_UNDELETE;
            case SchedulableTransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE -> HederaFunctionality.CONTRACT_CREATE;
            case SchedulableTransactionBody.DataOneOfType.CONTRACT_UPDATE_INSTANCE -> HederaFunctionality.CONTRACT_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.CONTRACT_CALL -> HederaFunctionality.CONTRACT_CALL;
            case SchedulableTransactionBody.DataOneOfType.CONTRACT_DELETE_INSTANCE -> HederaFunctionality.CONTRACT_DELETE;
            case SchedulableTransactionBody.DataOneOfType.FREEZE -> HederaFunctionality.FREEZE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_CREATION -> HederaFunctionality.TOKEN_CREATE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_FREEZE -> HederaFunctionality.TOKEN_FREEZE_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_UNFREEZE -> HederaFunctionality.TOKEN_UNFREEZE_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_GRANT_KYC -> HederaFunctionality.TOKEN_GRANT_KYC_TO_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_REVOKE_KYC -> HederaFunctionality.TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_DELETION -> HederaFunctionality.TOKEN_DELETE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_UPDATE -> HederaFunctionality.TOKEN_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_MINT -> HederaFunctionality.TOKEN_MINT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_BURN -> HederaFunctionality.TOKEN_BURN;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_WIPE -> HederaFunctionality.TOKEN_ACCOUNT_WIPE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_ASSOCIATE -> HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_DISSOCIATE -> HederaFunctionality.TOKEN_DISSOCIATE_FROM_ACCOUNT;
            case SchedulableTransactionBody.DataOneOfType.SCHEDULE_DELETE -> HederaFunctionality.SCHEDULE_DELETE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_PAUSE -> HederaFunctionality.TOKEN_PAUSE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_UNPAUSE -> HederaFunctionality.TOKEN_UNPAUSE;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_APPROVE_ALLOWANCE -> HederaFunctionality.CRYPTO_APPROVE_ALLOWANCE;
            case SchedulableTransactionBody.DataOneOfType.CRYPTO_DELETE_ALLOWANCE -> HederaFunctionality.CRYPTO_DELETE_ALLOWANCE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE -> HederaFunctionality.TOKEN_FEE_SCHEDULE_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.UTIL_PRNG -> HederaFunctionality.UTIL_PRNG;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_UPDATE_NFTS -> HederaFunctionality.TOKEN_UPDATE_NFTS;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_REJECT -> HederaFunctionality.TOKEN_REJECT;
            case SchedulableTransactionBody.DataOneOfType.NODE_CREATE -> HederaFunctionality.NODE_CREATE;
            case SchedulableTransactionBody.DataOneOfType.NODE_UPDATE -> HederaFunctionality.NODE_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.NODE_DELETE -> HederaFunctionality.NODE_DELETE;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_CANCEL_AIRDROP -> HederaFunctionality.TOKEN_CANCEL_AIRDROP;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_CLAIM_AIRDROP -> HederaFunctionality.TOKEN_CLAIM_AIRDROP;
            case SchedulableTransactionBody.DataOneOfType.TOKEN_AIRDROP -> HederaFunctionality.TOKEN_AIRDROP;
            case SchedulableTransactionBody.DataOneOfType.REGISTERED_NODE_CREATE -> HederaFunctionality.REGISTERED_NODE_CREATE;
            case SchedulableTransactionBody.DataOneOfType.REGISTERED_NODE_UPDATE -> HederaFunctionality.REGISTERED_NODE_UPDATE;
            case SchedulableTransactionBody.DataOneOfType.REGISTERED_NODE_DELETE -> HederaFunctionality.REGISTERED_NODE_DELETE;
            case SchedulableTransactionBody.DataOneOfType.UNSET -> HederaFunctionality.NONE;
        };
    }

    @NonNull
    static Schedule createProvisionalSchedule(@NonNull TransactionBody body, @NonNull Instant consensusNow, long defaultLifetime, boolean longTermEnabled) {
        TransactionID txnId = body.transactionIDOrThrow();
        ScheduleCreateTransactionBody op = body.scheduleCreateOrThrow();
        AccountID payerId = txnId.accountIDOrThrow();
        long expiry = HandlerUtility.calculateExpiration(op.expirationTime(), consensusNow, defaultLifetime, longTermEnabled);
        Schedule.Builder builder = Schedule.newBuilder();
        if (longTermEnabled) {
            builder.waitForExpiry(op.waitForExpiry());
        }
        return builder.scheduleId((ScheduleID)null).deleted(false).executed(false).adminKey(op.adminKey()).schedulerAccountId(payerId).payerAccountId(op.payerAccountIDOrElse(payerId)).schedulerAccountId(payerId).scheduleValidStart(txnId.transactionValidStart()).calculatedExpirationSecond(expiry).providedExpirationSecond(op.expirationTimeOrElse(Timestamp.DEFAULT).seconds()).originalCreateTransaction(body).memo(op.memo()).scheduledTransaction(op.scheduledTransactionBody()).build();
    }

    @NonNull
    static TransactionID transactionIdForScheduled(@NonNull Schedule schedule) {
        return HandlerUtility.scheduledTxnIdFrom(schedule.originalCreateTransactionOrThrow().transactionIDOrThrow());
    }

    public static TransactionID scheduledTxnIdFrom(@NonNull TransactionID schedulingTxnId) {
        Objects.requireNonNull(schedulingTxnId);
        return schedulingTxnId.scheduled() ? schedulingTxnId.copyBuilder().nonce(schedulingTxnId.nonce() + 1).build() : schedulingTxnId.copyBuilder().scheduled(true).build();
    }

    private static long calculateExpiration(@Nullable Timestamp givenExpiration, @NonNull Instant consensusNow, long defaultLifetime, boolean longTermEnabled) {
        if (givenExpiration != null && longTermEnabled) {
            return givenExpiration.seconds();
        }
        return consensusNow.plusSeconds(defaultLifetime).getEpochSecond();
    }
}

