/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoGetAccountRecordsQuery;
import com.hedera.hapi.node.token.CryptoGetAccountRecordsResponse;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.CryptoFeeBuilder;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.records.RecordCache;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class CryptoGetAccountRecordsHandler
extends PaidQueryHandler {
    private final RecordCache recordCache;
    private final CryptoFeeBuilder usageEstimator = new CryptoFeeBuilder();

    @Inject
    public CryptoGetAccountRecordsHandler(@NonNull RecordCache recordCache) {
        this.recordCache = Objects.requireNonNull(recordCache);
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.cryptoGetAccountRecordsOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        CryptoGetAccountRecordsResponse.Builder response = CryptoGetAccountRecordsResponse.newBuilder().header(header);
        return Response.newBuilder().cryptoGetAccountRecords(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.createStore(ReadableAccountStore.class);
        Query query = context.query();
        CryptoGetAccountRecordsQuery op = query.cryptoGetAccountRecords();
        PreCheckException.validateTruePreCheck((op != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        Account account = accountStore.getAccountById(op.accountIDOrElse(AccountID.DEFAULT));
        PreCheckException.validateTruePreCheck((account != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
        PreCheckException.validateFalsePreCheck((boolean)account.deleted(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_DELETED);
        PreCheckException.validateFalsePreCheck((boolean)account.smartContract(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_ACCOUNT_ID);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        CryptoGetAccountRecordsQuery op = context.query().cryptoGetAccountRecordsOrThrow();
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        AccountID accountId = op.accountIDOrElse(AccountID.DEFAULT);
        CryptoGetAccountRecordsResponse.Builder response = CryptoGetAccountRecordsResponse.newBuilder().header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK) {
            response.accountID(accountId);
            if (responseType != ResponseType.COST_ANSWER) {
                List acctRecords = this.recordCache.getRecords(accountId);
                response.records(acctRecords);
            }
        }
        return Response.newBuilder().cryptoGetAccountRecords(response).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        Query query = queryContext.query();
        ReadableAccountStore accountStore = (ReadableAccountStore)queryContext.createStore(ReadableAccountStore.class);
        CryptoGetAccountRecordsQuery op = query.cryptoGetAccountRecordsOrThrow();
        AccountID accountId = op.accountIDOrElse(AccountID.DEFAULT);
        Account account = accountStore.getAccountById(accountId);
        List records = this.recordCache.getRecords(accountId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGivenFor(account, records));
    }

    private FeeData usageGivenFor(Account account, List<TransactionRecord> pbjRecords) {
        if (account == null) {
            return Fees.CONSTANT_FEE_DATA;
        }
        List<com.hederahashgraph.api.proto.java.TransactionRecord> records = pbjRecords.stream().map(CommonPbjConverters::fromPbj).toList();
        return this.usageEstimator.getCryptoAccountRecordsQueryFeeMatrices(records, null);
    }
}

