/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.protocol.rpc;

import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.platform.message.GossipKnownTips;
import com.hedera.hapi.platform.message.GossipPing;
import com.hedera.hapi.platform.message.GossipSyncData;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.ThrowingRunnable;
import org.hiero.consensus.concurrent.pool.ParallelExecutionException;
import org.hiero.consensus.concurrent.pool.ParallelExecutor;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.gossip.config.BroadcastConfig;
import org.hiero.consensus.gossip.config.SyncConfig;
import org.hiero.consensus.gossip.impl.gossip.permits.SyncPermitProvider;
import org.hiero.consensus.gossip.impl.gossip.rpc.GossipRpcReceiver;
import org.hiero.consensus.gossip.impl.gossip.rpc.GossipRpcReceiverHandler;
import org.hiero.consensus.gossip.impl.gossip.rpc.GossipRpcSender;
import org.hiero.consensus.gossip.impl.gossip.rpc.SyncData;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncPhase;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.SyncTimeoutException;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncInputStream;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncOutputStream;
import org.hiero.consensus.gossip.impl.gossip.sync.protocol.SyncStatusChecker;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.NetworkMetrics;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcInternalExceptionHandler;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcOverloadMonitor;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcPingHandler;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.StreamWriter;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class RpcPeerProtocol
implements PeerProtocol,
GossipRpcSender {
    private static final Logger logger = LogManager.getLogger(RpcPeerProtocol.class);
    static final short END_OF_CONVERSATION = -1;
    private static final int EVENT_BATCH_SIZE = 512;
    private final BlockingQueue<StreamWriter> outputQueue;
    private final BlockingQueue<Runnable> inputQueue;
    private final RpcPingHandler pingHandler;
    private static final Duration SOCKET_EXCEPTION_DURATION = Duration.ofMinutes(1L);
    private final RateLimiter exceptionRateLimiter;
    private final RpcInternalExceptionHandler exceptionHandler;
    private final SyncConfig syncConfig;
    private GossipRpcReceiverHandler rpcPeerHandler;
    private GossipRpcReceiver receiver;
    private final NodeId remotePeerId;
    private final ParallelExecutor executor;
    private final Supplier<Boolean> gossipHalted;
    private final Supplier<PlatformStatus> platformStatus;
    private final SyncPermitProvider permitProvider;
    private final Time time;
    private final SyncMetrics syncMetrics;
    private volatile boolean processMessages = false;
    private volatile long conversationFinishPending;
    private SyncPhase previousPhase = SyncPhase.IDLE;
    private static final Runnable POISON_PILL = () -> logger.error(LogMarker.EXCEPTION.getMarker(), "Poison pill should never be executed");
    private final RpcOverloadMonitor overloadMonitor;

    public RpcPeerProtocol(@NonNull NodeId peerId, @NonNull ParallelExecutor executor, @NonNull Supplier<Boolean> gossipHalted, @NonNull Supplier<PlatformStatus> platformStatus, @NonNull SyncPermitProvider permitProvider, @NonNull NetworkMetrics networkMetrics, @NonNull Time time, @NonNull SyncMetrics syncMetrics, @NonNull SyncConfig syncConfig, @NonNull BroadcastConfig broadcastConfig, @NonNull RpcInternalExceptionHandler exceptionHandler) {
        this.executor = Objects.requireNonNull(executor);
        this.remotePeerId = Objects.requireNonNull(peerId);
        this.gossipHalted = Objects.requireNonNull(gossipHalted);
        this.platformStatus = Objects.requireNonNull(platformStatus);
        this.permitProvider = Objects.requireNonNull(permitProvider);
        this.time = Objects.requireNonNull(time);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.syncConfig = syncConfig;
        this.pingHandler = new RpcPingHandler(time, networkMetrics, this.remotePeerId, this, syncConfig.pingPeriod());
        this.exceptionRateLimiter = new RateLimiter(time, SOCKET_EXCEPTION_DURATION);
        this.exceptionHandler = exceptionHandler;
        this.inputQueue = syncMetrics.createMeasuredQueue("rpc_input_%02d".formatted(peerId.id()), new LinkedBlockingQueue());
        this.outputQueue = syncMetrics.createMeasuredQueue("rpc_output_%02d".formatted(peerId.id()), new LinkedBlockingQueue());
        this.overloadMonitor = new RpcOverloadMonitor(broadcastConfig, syncMetrics, time, overload -> this.rpcPeerHandler.setCommunicationOverloaded((boolean)overload));
    }

    @Override
    public boolean shouldInitiate() {
        return this.shouldSwitchToRpc();
    }

    @Override
    public boolean shouldAccept() {
        return this.shouldSwitchToRpc();
    }

    private boolean shouldSwitchToRpc() {
        if (this.gossipHalted.get().booleanValue()) {
            this.syncMetrics.doNotSyncHalted();
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.GOSSIP_HALTED);
            return false;
        }
        if (!SyncStatusChecker.doesStatusPermitSync(this.platformStatus.get())) {
            this.syncMetrics.doNotSyncPlatformStatus();
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.PLATFORM_STATUS_PREVENTING_SYNC);
            return false;
        }
        if (!this.permitProvider.acquire()) {
            this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.NO_PERMIT);
            this.syncMetrics.doNotSyncNoPermits();
            return false;
        }
        return true;
    }

    @Override
    public void acceptFailed() {
        this.permitProvider.release();
    }

    @Override
    public void initiateFailed() {
        this.permitProvider.release();
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return true;
    }

    @Override
    public void runProtocol(@NonNull Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        Objects.requireNonNull(connection);
        this.processMessages = true;
        this.conversationFinishPending = -1L;
        this.syncMetrics.reportSyncPhase(this.remotePeerId, this.previousPhase);
        try {
            this.executor.doParallelWithHandler(connection::disconnect, (Callable)((ThrowingRunnable)this::dispatchInputMessages), new ThrowingRunnable[]{() -> this.readMessages(connection), () -> this.writeMessages(connection)});
        }
        catch (ParallelExecutionException e) {
            this.exceptionHandler.handleNetworkException((Exception)((Object)e), connection, this.exceptionRateLimiter);
        }
        finally {
            this.inputQueue.clear();
            this.outputQueue.clear();
            this.rpcPeerHandler.cleanup();
            this.permitProvider.release();
            this.previousPhase = this.syncMetrics.reportSyncPhase(this.remotePeerId, SyncPhase.OUTSIDE_OF_RPC);
        }
    }

    private void dispatchInputMessages() throws InterruptedException {
        this.syncMetrics.rpcDispatchThreadRunning(1);
        try {
            while (true) {
                boolean wantToExit;
                Runnable message;
                if ((message = this.inputQueue.poll(this.syncConfig.rpcIdleDispatchPollTimeout().toMillis(), TimeUnit.MILLISECONDS)) != null) {
                    if (message == POISON_PILL) {
                        break;
                    }
                    message.run();
                }
                if (!this.rpcPeerHandler.checkForPeriodicActions(wantToExit = this.gossipHalted.get() != false || !this.permitProvider.isHealthy() && !this.syncConfig.keepSendingEventsWhenUnhealthy(), !this.permitProvider.isHealthy())) {
                    this.processMessages = false;
                }
                this.overloadMonitor.reportOutputQueueSize(this.outputQueue.size());
            }
        }
        finally {
            this.syncMetrics.rpcDispatchThreadRunning(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessages(@NonNull Connection connection) throws IOException {
        Objects.requireNonNull(connection);
        SyncOutputStream output = connection.getDos();
        this.syncMetrics.rpcWriteThreadRunning(1);
        try {
            while (this.shouldContinueProcessingMessages()) {
                GossipPing ping;
                StreamWriter message;
                try {
                    long startNanos = this.time.nanoTime();
                    message = this.outputQueue.poll(this.syncConfig.rpcIdleWritePollTimeout().toMillis(), TimeUnit.MILLISECONDS);
                    this.syncMetrics.outputQueuePollTime(this.time.nanoTime() - startNanos);
                }
                catch (InterruptedException e) {
                    this.processMessages = false;
                    logger.warn(LogMarker.EXCEPTION.getMarker(), "Interrupted while waiting for message", (Throwable)e);
                    break;
                }
                if (message != null) {
                    message.write(output);
                }
                if ((ping = this.pingHandler.possiblyInitiatePing()) != null) {
                    this.sendPingSameThread(ping, output);
                    output.flush();
                }
                if (!this.outputQueue.isEmpty()) continue;
                output.flush();
            }
            output.writeShort(-1);
            output.flush();
        }
        finally {
            this.syncMetrics.rpcWriteThreadRunning(-1);
        }
    }

    private boolean shouldContinueProcessingMessages() {
        return this.processMessages && this.gossipHalted.get() == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMessages(@NonNull Connection connection) throws IOException, SyncTimeoutException {
        SyncInputStream input = connection.getDis();
        this.syncMetrics.rpcReadThreadRunning(1);
        try {
            block12: while (true) {
                if (this.conversationFinishPending > 0L && this.time.currentTimeMillis() - this.conversationFinishPending > this.syncConfig.maxSyncTime().toMillis()) {
                    this.inputQueue.clear();
                    throw new SyncTimeoutException(Duration.ofMillis(this.time.currentTimeMillis() - this.conversationFinishPending), this.syncConfig.maxSyncTime());
                }
                int incomingBatchSize = input.readShort();
                if (incomingBatchSize == -1) {
                    break;
                }
                int i = 0;
                while (true) {
                    if (i >= incomingBatchSize) continue block12;
                    int messageType = input.read();
                    switch (messageType) {
                        case 1: {
                            GossipSyncData gossipSyncData = (GossipSyncData)input.readPbjRecord(GossipSyncData.PROTOBUF);
                            this.inputQueue.add(() -> this.receiver.receiveSyncData(SyncData.fromProtobuf(gossipSyncData)));
                            break;
                        }
                        case 2: {
                            GossipKnownTips knownTips = (GossipKnownTips)input.readPbjRecord(GossipKnownTips.PROTOBUF);
                            this.inputQueue.add(() -> this.receiver.receiveTips(knownTips.knownTips()));
                            break;
                        }
                        case 3: {
                            List<GossipEvent> events = Collections.singletonList((GossipEvent)input.readPbjRecord(GossipEvent.PROTOBUF));
                            this.inputQueue.add(() -> this.receiver.receiveEvents(events));
                            break;
                        }
                        case 7: {
                            GossipEvent event = (GossipEvent)input.readPbjRecord(GossipEvent.PROTOBUF);
                            this.inputQueue.add(() -> this.receiver.receiveBroadcastEvent(event));
                            break;
                        }
                        case 4: {
                            this.inputQueue.add(this.receiver::receiveEventsFinished);
                            break;
                        }
                        case 5: {
                            this.pingHandler.handleIncomingPing((GossipPing)input.readPbjRecord(GossipPing.PROTOBUF));
                            break;
                        }
                        case 6: {
                            GossipPing pingReply = (GossipPing)input.readPbjRecord(GossipPing.PROTOBUF);
                            long pingMillis = TimeUnit.NANOSECONDS.toMillis(this.pingHandler.handleIncomingPingReply(pingReply));
                            this.overloadMonitor.reportPing(pingMillis);
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        finally {
            this.inputQueue.add(POISON_PILL);
            this.processMessages = false;
            this.syncMetrics.rpcReadThreadRunning(-1);
        }
    }

    @Override
    public void sendSyncData(@NonNull SyncData syncMessage) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(1);
            out.writePbjRecord(syncMessage.toProtobuf(), GossipSyncData.PROTOBUF);
        });
    }

    @Override
    public void sendTips(@NonNull List<Boolean> tips) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(2);
            out.writePbjRecord(GossipKnownTips.newBuilder().knownTips(tips).build(), GossipKnownTips.PROTOBUF);
        });
    }

    @Override
    public void sendEvents(@NonNull List<GossipEvent> gossipEvents) {
        this.outputQueue.add(out -> {
            for (int i = 0; i < gossipEvents.size(); i += 512) {
                List batch = gossipEvents.subList(i, Math.min(i + 512, gossipEvents.size()));
                if (batch.isEmpty()) continue;
                out.writeShort(batch.size());
                for (GossipEvent gossipEvent : batch) {
                    out.write(3);
                    out.writePbjRecord(gossipEvent, GossipEvent.PROTOBUF);
                }
            }
        });
    }

    @Override
    public void sendBroadcastEvent(@NonNull GossipEvent gossipEvent) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(7);
            out.writePbjRecord(gossipEvent, GossipEvent.PROTOBUF);
        });
    }

    @Override
    public void sendEndOfEvents() {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(4);
        });
    }

    void sendPingReply(GossipPing reply) {
        this.outputQueue.add(out -> {
            out.writeShort(1);
            out.write(6);
            out.writePbjRecord(reply, GossipPing.PROTOBUF);
        });
    }

    private void sendPingSameThread(GossipPing ping, SyncOutputStream output) throws IOException {
        output.writeShort(1);
        output.write(5);
        output.writePbjRecord(ping, GossipPing.PROTOBUF);
    }

    @Override
    public void breakConversation() {
        this.conversationFinishPending = this.time.currentTimeMillis();
        this.processMessages = false;
    }

    public void setRpcPeerHandler(GossipRpcReceiverHandler rpcPeerHandler) {
        this.rpcPeerHandler = rpcPeerHandler;
        this.receiver = rpcPeerHandler;
    }
}

