/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.node.app.hapi.utils.throttles.CongestibleThrottle;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.LeakyBucketThrottle;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;

public class LeakyBucketDeterministicThrottle
implements CongestibleThrottle {
    private final String throttleName;
    private final LeakyBucketThrottle delegate;
    private Instant lastDecisionTime;

    public LeakyBucketDeterministicThrottle(long capacity, String name, int burstSeconds) {
        this.throttleName = name;
        this.delegate = new LeakyBucketThrottle(capacity, burstSeconds);
    }

    public boolean allow(@NonNull Instant now, long throttleLimit) {
        Objects.requireNonNull(now);
        long elapsedNanos = DeterministicThrottle.nanosBetween(this.lastDecisionTime, now);
        if (elapsedNanos < 0L) {
            throw new IllegalArgumentException("Throttle timeline must advance, but " + String.valueOf(now) + " is not after " + String.valueOf(this.lastDecisionTime));
        }
        if (throttleLimit < 0L) {
            throw new IllegalArgumentException("Throttle limit must be non-negative, but was " + throttleLimit);
        }
        this.lastDecisionTime = now;
        return this.delegate.allow(throttleLimit, elapsedNanos);
    }

    public void leakUntil(@NonNull Instant now) {
        Objects.requireNonNull(now);
        long elapsedNanos = DeterministicThrottle.nanosBetween(this.lastDecisionTime, now);
        this.lastDecisionTime = now;
        this.delegate.leakFor(elapsedNanos);
    }

    public long instantaneousFreeToUsedRatio() {
        return this.delegate.freeToUsedRatio();
    }

    public double percentUsed(Instant now) {
        if (this.lastDecisionTime == null) {
            return 0.0;
        }
        long elapsedNanos = Math.max(0L, DeterministicThrottle.nanosBetween(this.lastDecisionTime, now));
        return this.delegate.percentUsed(elapsedNanos);
    }

    public long capacityFree(@NonNull Instant now) {
        if (this.lastDecisionTime == null) {
            return this.delegate().capacityFree();
        }
        long elapsedNanos = Math.max(0L, DeterministicThrottle.nanosBetween(this.lastDecisionTime, now));
        return this.delegate.capacityFree(elapsedNanos);
    }

    @Override
    public double instantaneousPercentUsed() {
        if (this.lastDecisionTime == null) {
            return 0.0;
        }
        return this.delegate.instantaneousPercentUsed();
    }

    @Override
    public long capacity() {
        return this.delegate.bucket().nominalCapacity();
    }

    @Override
    public long mtps() {
        return this.capacity() * 1000L;
    }

    @Override
    public String name() {
        return this.throttleName;
    }

    @Override
    public long used() {
        return this.delegate.bucket().capacityUsed();
    }

    public void leakUnusedGasPreviouslyReserved(long value) {
        this.delegate().bucket().leak(value);
    }

    LeakyBucketThrottle delegate() {
        return this.delegate;
    }

    public ThrottleUsageSnapshot usageSnapshot() {
        return new ThrottleUsageSnapshot(this.delegate.bucket().capacityUsed(), this.lastDecisionTime == null ? null : new Timestamp(this.lastDecisionTime.getEpochSecond(), this.lastDecisionTime.getNano()));
    }

    public void resetUsageTo(@NonNull ThrottleUsageSnapshot usageSnapshot) {
        Objects.requireNonNull(usageSnapshot);
        this.lastDecisionTime = usageSnapshot.lastDecisionTime() == null ? null : Instant.ofEpochSecond(usageSnapshot.lastDecisionTime().seconds(), usageSnapshot.lastDecisionTime().nanos());
        this.delegate.bucket().resetUsed(usageSnapshot.used());
    }

    public void resetUsage() {
        this.resetLastAllowedUse();
        this.delegate.bucket().resetUsed(0L);
    }

    public void reclaimLastAllowedUse() {
        this.delegate.reclaimLastAllowedUse();
    }

    public void resetLastAllowedUse() {
        this.delegate.resetLastAllowedUse();
    }
}

