/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces.impl;

import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.pces.actions.DoneReplayingEventsAction;
import org.hiero.consensus.pces.actions.StartedReplayingEventsAction;
import org.hiero.consensus.pces.impl.common.PcesFileTracker;
import org.hiero.consensus.pces.impl.common.PcesMultiFileIterator;
import org.hiero.consensus.pces.impl.replayer.PcesReplayerWiring;

public class PcesCoordinator {
    private static final Logger logger = LogManager.getLogger();
    private final Time time;
    private final PcesFileTracker initialPcesFiles;
    private final PcesReplayerWiring pcesReplayerWiring;
    private final Consumer<PlatformStatusAction> statusActionConsumer;
    private final Runnable stateHasherFlusher;
    private final Runnable signalEndOfPcesReplay;

    public PcesCoordinator(@NonNull Time time, @NonNull PcesFileTracker initialPcesFiles, @NonNull PcesReplayerWiring pcesReplayerWiring, @NonNull Consumer<PlatformStatusAction> statusActionConsumer, @NonNull Runnable stateHasherFlusher, @NonNull Runnable signalEndOfPcesReplay) {
        this.time = Objects.requireNonNull(time);
        this.initialPcesFiles = Objects.requireNonNull(initialPcesFiles);
        this.pcesReplayerWiring = Objects.requireNonNull(pcesReplayerWiring);
        this.statusActionConsumer = Objects.requireNonNull(statusActionConsumer);
        this.stateHasherFlusher = Objects.requireNonNull(stateHasherFlusher);
        this.signalEndOfPcesReplay = Objects.requireNonNull(signalEndOfPcesReplay);
    }

    public void replayPcesEvents(long pcesReplayLowerBound, long startingRound) {
        Objects.requireNonNull(this.initialPcesFiles, "Not initialized");
        this.statusActionConsumer.accept((PlatformStatusAction)new StartedReplayingEventsAction());
        PcesMultiFileIterator iterator = this.initialPcesFiles.getEventIterator(pcesReplayLowerBound, startingRound);
        logger.info(LogMarker.STARTUP.getMarker(), "replaying preconsensus event stream starting at {}", (Object)pcesReplayLowerBound);
        this.pcesReplayerWiring.pcesIteratorInputWire().inject((Object)iterator);
        this.stateHasherFlusher.run();
        this.signalEndOfPcesReplay.run();
        this.statusActionConsumer.accept((PlatformStatusAction)new DoneReplayingEventsAction(this.time.now()));
    }
}

