/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.records.CryptoCreateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class AutoAccountCreator {
    private WritableAccountStore accountStore;
    private HandleContext handleContext;

    public AutoAccountCreator(@NonNull HandleContext handleContext) {
        this.handleContext = Objects.requireNonNull(handleContext);
        this.accountStore = (WritableAccountStore)handleContext.storeFactory().writableStore(WritableAccountStore.class);
    }

    public AccountID create(@NonNull Bytes alias, int requiredAutoAssociations, boolean highVolume) {
        CryptoCreateStreamBuilder streamBuilder;
        TransactionBody.Builder syntheticCreation;
        int autoAssociations;
        Objects.requireNonNull(alias);
        AccountsConfig accountsConfig = (AccountsConfig)this.handleContext.configuration().getConfigData(AccountsConfig.class);
        HandleException.validateTrue((this.accountStore.sizeOfAccountState() + 1L <= accountsConfig.maxNumber() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        boolean isAliasEVMAddress = AliasUtils.isOfEvmAddressSize((Bytes)alias);
        EntitiesConfig entitiesConfig = (EntitiesConfig)this.handleContext.configuration().getConfigData(EntitiesConfig.class);
        int n = autoAssociations = entitiesConfig.unlimitedAutoAssociationsEnabled() ? -1 : requiredAutoAssociations;
        if (isAliasEVMAddress) {
            syntheticCreation = this.createHollowAccount(alias, 0L, autoAssociations);
        } else {
            Key key = AliasUtils.asKeyFromAlias((Bytes)alias);
            syntheticCreation = this.createZeroBalanceAccount(alias, key, autoAssociations);
        }
        if (highVolume) {
            syntheticCreation.highVolume(true);
        }
        HandleException.validateTrue(((streamBuilder = (CryptoCreateStreamBuilder)this.handleContext.dispatch(DispatchOptions.setupDispatch((AccountID)this.handleContext.payer(), (TransactionBody)syntheticCreation.build(), CryptoCreateStreamBuilder.class, (FeeCharging)this.handleContext.dispatchMetadata().getMetadata(HandleContext.DispatchMetadata.Type.CUSTOM_FEE_CHARGING, FeeCharging.class).orElse(null)))).status() == ResponseCodeEnum.SUCCESS ? 1 : 0) != 0, (ResponseCodeEnum)streamBuilder.status());
        HederaConfig config = (HederaConfig)this.handleContext.configuration().getConfigData(HederaConfig.class);
        AccountID createdAccountId = this.accountStore.getAccountIDByAlias(config.shard(), config.realm(), alias);
        HandleException.validateTrue((createdAccountId != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FAIL_INVALID);
        return createdAccountId;
    }

    public TransactionBody.Builder createHollowAccount(@NonNull Bytes alias, long balance, int maxAutoAssociations) {
        Objects.requireNonNull(alias);
        CryptoCreateTransactionBody.Builder baseBuilder = this.createAccountBase(balance, maxAutoAssociations);
        baseBuilder.key(KeyUtils.IMMUTABILITY_SENTINEL_KEY).alias(alias);
        return TransactionBody.newBuilder().cryptoCreateAccount(baseBuilder.build());
    }

    private CryptoCreateTransactionBody.Builder createAccountBase(long balance, int maxAutoAssociations) {
        return CryptoCreateTransactionBody.newBuilder().initialBalance(balance).maxAutomaticTokenAssociations(maxAutoAssociations).autoRenewPeriod(Duration.newBuilder().seconds(7776000L));
    }

    private TransactionBody.Builder createZeroBalanceAccount(@NonNull Bytes alias, @NonNull Key key, int maxAutoAssociations) {
        CryptoCreateTransactionBody.Builder baseBuilder = this.createAccountBase(0L, maxAutoAssociations);
        baseBuilder.key(key).alias(alias).receiverSigRequired(false);
        return TransactionBody.newBuilder().cryptoCreateAccount(baseBuilder.build());
    }
}

