/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event;

import com.hedera.hapi.node.state.roster.Roster;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.model.node.NodeId;

public class DefaultIntakeEventCounter
implements IntakeEventCounter {
    private static final IntUnaryOperator EXIT_INTAKE = count -> {
        if (count > 0) {
            return count - 1;
        }
        throw new IllegalStateException("Event processed from peer, but no events from that peer were in the intake pipeline. This shouldn't be possible.");
    };
    private final Map<NodeId, AtomicInteger> unprocessedEventCounts = new HashMap<NodeId, AtomicInteger>();

    public DefaultIntakeEventCounter(@NonNull Roster roster) {
        roster.rosterEntries().forEach(entry -> this.unprocessedEventCounts.put(NodeId.of((long)entry.nodeId()), new AtomicInteger(0)));
    }

    @Override
    public boolean hasUnprocessedEvents(@NonNull NodeId peer) {
        Objects.requireNonNull(peer);
        return this.unprocessedEventCounts.get(peer).get() > 0;
    }

    @Override
    public void eventEnteredIntakePipeline(@NonNull NodeId peer) {
        Objects.requireNonNull(peer);
        this.unprocessedEventCounts.get(peer).incrementAndGet();
    }

    @Override
    public void eventExitedIntakePipeline(@Nullable NodeId peer) {
        if (peer == null) {
            return;
        }
        this.unprocessedEventCounts.get(peer).getAndUpdate(EXIT_INTAKE);
    }

    @Override
    public void reset() {
        this.unprocessedEventCounts.forEach((nodeId, unprocessedEventCount) -> unprocessedEventCount.set(0));
    }
}

