/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.protocol.rpc;

import com.hedera.hapi.platform.message.GossipPing;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.gossip.impl.network.NetworkMetrics;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcPeerProtocol;
import org.hiero.consensus.model.node.NodeId;

final class RpcPingHandler {
    private static final Logger logger = LogManager.getLogger(RpcPingHandler.class);
    private final Time time;
    private final ConcurrentMap<Long, Long> sentPings = new ConcurrentHashMap<Long, Long>();
    private final NetworkMetrics networkMetrics;
    private final NodeId remotePeerId;
    private final RpcPeerProtocol rpcPeerProtocol;
    private final long pingPeriod;
    private long pingId = 1L;
    private long lastPingInitiationTime;

    RpcPingHandler(@NonNull Time time, NetworkMetrics networkMetrics, NodeId remotePeerId, RpcPeerProtocol rpcPeerProtocol, @NonNull Duration pingPeriod) {
        this.time = Objects.requireNonNull(time);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.remotePeerId = Objects.requireNonNull(remotePeerId);
        this.rpcPeerProtocol = Objects.requireNonNull(rpcPeerProtocol);
        this.pingPeriod = TimeUnit.NANOSECONDS.convert(pingPeriod);
    }

    void handleIncomingPing(GossipPing ping) {
        this.rpcPeerProtocol.sendPingReply(ping);
    }

    GossipPing possiblyInitiatePing() {
        long timestamp = this.time.nanoTime();
        if (timestamp - this.lastPingInitiationTime < this.pingPeriod) {
            return null;
        }
        this.lastPingInitiationTime = timestamp;
        GossipPing ping = new GossipPing(this.pingId++);
        this.sentPings.put(ping.correlationId(), timestamp);
        return ping;
    }

    long handleIncomingPingReply(@NonNull GossipPing pingReply) {
        Long original = (Long)this.sentPings.remove(pingReply.correlationId());
        if (original == null) {
            logger.error(LogMarker.NETWORK.getMarker(), "Received unexpected gossip ping reply from peer {} for correlation id {}", (Object)this.remotePeerId, (Object)pingReply.correlationId());
            return 0L;
        }
        long lastPingNanos = this.time.nanoTime() - original;
        logger.debug(LogMarker.NETWORK.getMarker(), "Ping {}", (Object)lastPingNanos);
        this.networkMetrics.recordPingTime(this.remotePeerId, lastPingNanos);
        return lastPingNanos;
    }
}

