/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.ModuleInfoProvidesBlueprint;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ModuleInfoProvides
extends ModuleInfoProvidesBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleInfoProvides instance) {
        return (Builder)ModuleInfoProvides.builder().from(instance);
    }

    public static ModuleInfoProvides create() {
        return ModuleInfoProvides.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ModuleInfoProvides>
    implements io.helidon.common.Builder<Builder, ModuleInfoProvides> {
        private Builder() {
        }

        public ModuleInfoProvides buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleInfoProvidesImpl(this);
        }

        public ModuleInfoProvides build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ModuleInfoProvides>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final List<TypeName> implementations = new ArrayList<TypeName>();
        private boolean isImplementationsMutated;
        private TypeName service;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleInfoProvides prototype) {
            this.service(prototype.service());
            if (!this.isImplementationsMutated) {
                this.implementations.clear();
            }
            this.addImplementations(prototype.implementations());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.service().ifPresent(this::service);
            if (this.isImplementationsMutated) {
                if (builder.isImplementationsMutated) {
                    this.addImplementations(builder.implementations);
                }
            } else {
                this.implementations.clear();
                this.addImplementations(builder.implementations);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(TypeName service) {
            Objects.requireNonNull(service);
            this.service = service;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.service(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.service(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER implementations(List<? extends TypeName> implementations) {
            Objects.requireNonNull(implementations);
            this.isImplementationsMutated = true;
            this.implementations.clear();
            this.implementations.addAll(implementations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addImplementations(List<? extends TypeName> implementations) {
            Objects.requireNonNull(implementations);
            this.isImplementationsMutated = true;
            this.implementations.addAll(implementations);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addImplementation(TypeName implementation) {
            Objects.requireNonNull(implementation);
            this.implementations.add(implementation);
            this.isImplementationsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addImplementation(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.implementations.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> service() {
            return Optional.ofNullable(this.service);
        }

        public List<TypeName> implementations() {
            return this.implementations;
        }

        public String toString() {
            return "ModuleInfoProvidesBuilder{service=" + String.valueOf(this.service) + ",implementations=" + String.valueOf(this.implementations) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.service == null) {
                collector.fatal(this.getClass(), "Property \"service\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ModuleInfoProvidesImpl
        implements ModuleInfoProvides {
            private final List<TypeName> implementations;
            private final TypeName service;

            protected ModuleInfoProvidesImpl(BuilderBase<?, ?> builder) {
                this.service = builder.service().get();
                this.implementations = List.copyOf(builder.implementations());
            }

            @Override
            public TypeName service() {
                return this.service;
            }

            @Override
            public List<TypeName> implementations() {
                return this.implementations;
            }

            public String toString() {
                return "ModuleInfoProvides{service=" + String.valueOf(this.service) + ",implementations=" + String.valueOf(this.implementations) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleInfoProvides)) {
                    return false;
                }
                ModuleInfoProvides other = (ModuleInfoProvides)o;
                return Objects.equals(this.service, other.service()) && Objects.equals(this.implementations, other.implementations());
            }

            public int hashCode() {
                return Objects.hash(this.service, this.implementations);
            }
        }
    }
}

