/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.mapper.Value;
import io.helidon.http.HeaderName;
import io.helidon.http.HttpToken;
import java.nio.charset.StandardCharsets;
import java.util.List;

public interface Header
extends Value<String> {
    public String name();

    @Deprecated(forRemoval=true, since="4.0.0")
    default public String value() {
        return (String)this.get();
    }

    public HeaderName headerName();

    default public String values() {
        return String.join((CharSequence)", ", this.allValues());
    }

    public List<String> allValues();

    default public List<String> allValues(boolean split) {
        if (split) {
            List<String> values = this.allValues();
            if (values.size() == 1) {
                String value = values.get(0);
                if (value.contains(", ")) {
                    return List.of(value.split(", "));
                }
                return List.of(value);
            }
            return values;
        }
        return this.allValues();
    }

    public int valueCount();

    public boolean sensitive();

    public boolean changing();

    default public byte[] valueBytes() {
        return ((String)this.get()).getBytes(StandardCharsets.US_ASCII);
    }

    default public void writeHttp1Header(BufferData buffer) {
        byte[] nameBytes = this.name().getBytes(StandardCharsets.US_ASCII);
        if (this.valueCount() == 1) {
            this.writeHeader(buffer, nameBytes, this.valueBytes());
        } else {
            for (String value : this.allValues()) {
                this.writeHeader(buffer, nameBytes, value.getBytes(StandardCharsets.US_ASCII));
            }
        }
    }

    default public void validate() throws IllegalArgumentException {
        String name = this.name();
        HttpToken.validate(name);
        Header.validateValue(name, this.values());
    }

    private static void validateValue(String name, String value) throws IllegalArgumentException {
        char[] vChars = value.toCharArray();
        int vLength = vChars.length;
        for (int i = 0; i < vLength; ++i) {
            char vChar = vChars[i];
            if (i == 0) {
                if (vChar >= '!' && vChar != '\u007f') continue;
                throw new IllegalArgumentException("First character of the header value is invalid for header '" + name + "'");
            }
            if ((vChar >= ' ' || vChar == '\t') && vChar != '\u007f') continue;
            throw new IllegalArgumentException("Character at position " + (i + 1) + " of the header value is invalid for header '" + name + "'");
        }
    }

    private void writeHeader(BufferData buffer, byte[] nameBytes, byte[] valueBytes) {
        buffer.write(nameBytes);
        buffer.write(58);
        buffer.write(32);
        buffer.write(valueBytes);
        buffer.write(13);
        buffer.write(10);
    }
}

