/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.TokenAssociateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNftStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.NFTOwnersChangeStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContext;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferStep;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.ComputeDispatchFeesAsTopLevel;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.data.EntitiesConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AssociateTokenRecipientsStep
extends BaseTokenHandler
implements TransferStep {
    public static final TransactionBody PLACEHOLDER_SYNTHETIC_ASSOCIATION = TransactionBody.newBuilder().tokenAssociate(TokenAssociateTransactionBody.newBuilder().account(AccountID.DEFAULT).tokens(new TokenID[]{TokenID.DEFAULT}).build()).build();
    public static final TransactionBody PLACEHOLDER_SYNTHETIC_ASSOCIATION_HV = TransactionBody.newBuilder().tokenAssociate(TokenAssociateTransactionBody.newBuilder().account(AccountID.DEFAULT).tokens(new TokenID[]{TokenID.DEFAULT}).build()).highVolume(true).build();
    private final CryptoTransferTransactionBody op;

    public AssociateTokenRecipientsStep(@NonNull CryptoTransferTransactionBody op) {
        this.op = Objects.requireNonNull(op);
    }

    @Override
    public void doIn(@NonNull TransferContext transferContext) {
        Objects.requireNonNull(transferContext);
        HandleContext handleContext = transferContext.getHandleContext();
        StoreFactory storeFactory = handleContext.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableNftStore nftStore = (WritableNftStore)storeFactory.writableStore(WritableNftStore.class);
        ArrayList<TokenAssociation> newAssociations = new ArrayList<TokenAssociation>();
        for (TokenTransferList xfers : this.op.tokenTransfers()) {
            TokenID tokenId = xfers.tokenOrThrow();
            Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
            for (AccountAmount aa : xfers.transfers()) {
                TokenAssociation newAssociation;
                AccountID accountId = aa.accountIDOrElse(AccountID.DEFAULT);
                try {
                    newAssociation = this.validateAndBuildAutoAssociation(accountId, tokenId, token, accountStore, tokenRelStore, handleContext);
                }
                catch (HandleException e) {
                    if (this.mayNeedTranslation(e, aa)) {
                        this.validateFungibleAllowance(Objects.requireNonNull(accountStore.getAccountById(aa.accountIDOrThrow())), handleContext.payer(), tokenId, aa.amount());
                    }
                    throw e;
                }
                if (newAssociation == null) continue;
                newAssociations.add(newAssociation);
            }
            for (NftTransfer nftTransfer : xfers.nftTransfers()) {
                AccountID receiverId = nftTransfer.receiverAccountIDOrElse(AccountID.DEFAULT);
                AccountID senderId = nftTransfer.senderAccountIDOrElse(AccountID.DEFAULT);
                Nft nft = nftStore.get(tokenId, nftTransfer.serialNumber());
                try {
                    HandleException.validateTrue((tokenRelStore.get(senderId, tokenId) != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
                }
                catch (HandleException e) {
                    if (nft != null && this.mayNeedTranslation(e, nftTransfer)) {
                        NFTOwnersChangeStep.validateSpenderHasAllowance(Objects.requireNonNull(accountStore.getAccountById(senderId)), handleContext.payer(), tokenId, nft);
                    }
                    throw e;
                }
                HandleException.validateTrue((nft != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
                TokenAssociation newAssociation = this.validateAndBuildAutoAssociation(receiverId, tokenId, token, accountStore, tokenRelStore, handleContext);
                if (newAssociation == null) continue;
                newAssociations.add(newAssociation);
            }
        }
        for (TokenAssociation newAssociation : newAssociations) {
            transferContext.addToAutomaticAssociations(newAssociation);
        }
    }

    private boolean mayNeedTranslation(HandleException exception, AccountAmount adjustment) {
        return exception.getStatus() == ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT && adjustment.isApproval() && adjustment.amount() < 0L;
    }

    private boolean mayNeedTranslation(HandleException exception, NftTransfer nftTransfer) {
        return exception.getStatus() == ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT && nftTransfer.isApproval();
    }

    private TokenAssociation validateAndBuildAutoAssociation(@NonNull AccountID accountId, @NonNull TokenID tokenId, @NonNull Token token, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore, @NonNull HandleContext context) {
        Account account = TokenHandlerHelper.getIfUsableForAliasedId(accountId, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
        TokenRelation tokenRel = tokenRelStore.get(account.accountIdOrThrow(), tokenId);
        Configuration config = context.configuration();
        EntitiesConfig entitiesConfig = (EntitiesConfig)config.getConfigData(EntitiesConfig.class);
        if (tokenRel == null && account.maxAutoAssociations() != 0) {
            long autoAssociationFee;
            boolean unlimitedAssociationsEnabled;
            boolean validAssociations = AssociateTokenRecipientsStep.hasUnlimitedAutoAssociations(account, entitiesConfig) || account.usedAutoAssociations() < account.maxAutoAssociations();
            HandleException.validateTrue((boolean)validAssociations, (ResponseCodeEnum)ResponseCodeEnum.NO_REMAINING_AUTOMATIC_ASSOCIATIONS);
            HandleException.validateFalse((boolean)token.hasKycKey(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN);
            HandleException.validateFalse((boolean)token.accountsFrozenByDefault(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
            if (context.savepointStack().getBaseBuilder(StreamBuilder.class).isUserDispatch() && (unlimitedAssociationsEnabled = ((EntitiesConfig)config.getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled()) && !context.tryToChargePayer(autoAssociationFee = AssociateTokenRecipientsStep.associationFeeFor(context, context.body().highVolume() ? PLACEHOLDER_SYNTHETIC_ASSOCIATION_HV : PLACEHOLDER_SYNTHETIC_ASSOCIATION))) {
                throw new HandleException(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
            }
            TokenRelation newRelation = this.autoAssociate(account.accountIdOrThrow(), token, accountStore, tokenRelStore, config);
            return AssociateTokenRecipientsStep.asTokenAssociation(newRelation.tokenId(), newRelation.accountId());
        }
        HandleException.validateTrue((tokenRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT);
        HandleException.validateFalse((boolean)tokenRel.frozen(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
        return null;
    }

    public static long associationFeeFor(@NonNull HandleContext context, @NonNull TransactionBody txnBody) {
        return context.dispatchComputeFees(txnBody, context.payer(), ComputeDispatchFeesAsTopLevel.NO).totalFee();
    }

    private void validateFungibleAllowance(@NonNull Account account, @NonNull AccountID topLevelPayer, @NonNull TokenID tokenId, long amount) {
        List tokenAllowances = account.tokenAllowances();
        for (AccountFungibleTokenAllowance allowance : tokenAllowances) {
            if (!topLevelPayer.equals((Object)allowance.spenderId()) || !tokenId.equals((Object)allowance.tokenId())) continue;
            long newAllowanceAmount = allowance.amount() + amount;
            HandleException.validateTrue((newAllowanceAmount >= 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE);
            return;
        }
        throw new HandleException(ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE);
    }
}

