/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.reconnect.impl;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectFailurePayload;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.signed.SignedStateValidationData;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import com.swirlds.platform.system.status.actions.FallenBehindAction;
import com.swirlds.platform.system.status.actions.ReconnectCompleteAction;
import com.swirlds.state.State;
import com.swirlds.state.StateLifecycleManager;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.BlockingResourceProvider;
import org.hiero.base.concurrent.locks.locked.LockedResource;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.gossip.ReservedSignedStateResult;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatusAction;
import org.hiero.consensus.monitoring.FallenBehindMonitor;
import org.hiero.consensus.platformstate.PlatformStateUtils;
import org.hiero.consensus.reconnect.config.ReconnectConfig;
import org.hiero.consensus.reconnect.impl.ReconnectCoordinator;
import org.hiero.consensus.roster.RosterRetriever;
import org.hiero.consensus.state.signed.SignedState;

public class ReconnectController
implements Runnable {
    private static final Logger logger = LogManager.getLogger(ReconnectController.class);
    private final Roster roster;
    private final SignedStateValidator signedStateValidator;
    private final Platform platform;
    private final Configuration configuration;
    private final ReconnectCoordinator reconnectCoordinator;
    private final StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager;
    private final SavedStateController savedStateController;
    private final ConsensusStateEventHandler consensusStateEventHandler;
    private final BlockingResourceProvider<ReservedSignedStateResult> peerReservedSignedStateResultProvider;
    private final NodeId selfId;
    private final ReconnectConfig reconnectConfig;
    private final Time time;
    private final Instant startupTime;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final AtomicBoolean run = new AtomicBoolean(true);

    public ReconnectController(@NonNull Configuration configuration, @NonNull Time time, @NonNull Roster roster, @NonNull Platform platform, @NonNull ReconnectCoordinator reconnectCoordinator, @NonNull StateLifecycleManager<VirtualMapState, VirtualMap> stateLifecycleManager, @NonNull SavedStateController savedStateController, @NonNull ConsensusStateEventHandler consensusStateEventHandler, @NonNull BlockingResourceProvider<ReservedSignedStateResult> peerReservedSignedStateResultProvider, @NonNull NodeId selfId, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull SignedStateValidator signedStateValidator) {
        this.roster = Objects.requireNonNull(roster);
        this.reconnectCoordinator = Objects.requireNonNull(reconnectCoordinator);
        this.peerReservedSignedStateResultProvider = Objects.requireNonNull(peerReservedSignedStateResultProvider);
        this.fallenBehindMonitor = Objects.requireNonNull(fallenBehindMonitor);
        this.signedStateValidator = Objects.requireNonNull(signedStateValidator);
        this.reconnectConfig = (ReconnectConfig)configuration.getConfigData(ReconnectConfig.class);
        this.platform = Objects.requireNonNull(platform);
        this.configuration = Objects.requireNonNull(configuration);
        this.stateLifecycleManager = Objects.requireNonNull(stateLifecycleManager);
        this.savedStateController = Objects.requireNonNull(savedStateController);
        this.consensusStateEventHandler = Objects.requireNonNull(consensusStateEventHandler);
        this.time = Objects.requireNonNull(time);
        this.selfId = selfId;
        this.startupTime = time.now();
    }

    public void stopReconnectLoop() {
        this.run.set(false);
    }

    @Override
    public void run() {
        block6: {
            logger.info(LogMarker.RECONNECT.getMarker(), "Starting the ReconnectController");
            try {
                block3: while (this.run.get()) {
                    this.fallenBehindMonitor.awaitFallenBehind();
                    this.exitIf();
                    this.reconnectCoordinator.submitStatusAction((PlatformStatusAction)new FallenBehindAction());
                    logger.info(LogMarker.RECONNECT.getMarker(), "Preparing for reconnect, stopping gossip");
                    this.reconnectCoordinator.pauseGossip();
                    this.fallenBehindMonitor.awaitGossipPaused();
                    logger.info(LogMarker.RECONNECT.getMarker(), "Preparing for reconnect, start clearing queues");
                    this.reconnectCoordinator.clear();
                    logger.info(LogMarker.RECONNECT.getMarker(), "Queues have been cleared");
                    State currentState = (State)this.stateLifecycleManager.getMutableState();
                    currentState.getHash();
                    int failedReconnectsInARow = 0;
                    do {
                        AttemptReconnectResult result;
                        if ((result = this.attemptReconnect(currentState)).success()) {
                            this.fallenBehindMonitor.clear();
                            logger.info(LogMarker.RECONNECT.getMarker(), "Reconnect almost done resuming gossip");
                            this.reconnectCoordinator.resumeGossip();
                            continue block3;
                        }
                        this.reconnectCoordinator.clear();
                        this.exitIfMaxRetriesOrWait(++failedReconnectsInARow, result.throwable());
                    } while (this.run.get());
                }
            }
            catch (RuntimeException e) {
                logger.error(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFailurePayload("Unexpected error occurred while reconnecting", ReconnectFailurePayload.CauseOfFailure.ERROR), (Throwable)e);
                SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.RECONNECT_FAILURE);
            }
            catch (InterruptedException e) {
                if (!this.run.get()) break block6;
                logger.error(LogMarker.RECONNECT.getMarker(), () -> new ReconnectFailurePayload("Thread was interrupted unexpectedly", ReconnectFailurePayload.CauseOfFailure.ERROR), (Throwable)e);
                Thread.currentThread().interrupt();
                SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.RECONNECT_FAILURE);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private AttemptReconnectResult attemptReconnect(@NonNull State currentState) throws InterruptedException {
        logger.info(LogMarker.RECONNECT.getMarker(), "Waiting for a state to be obtained from a peer");
        try (LockedResource reservedStateResource = Objects.requireNonNull(this.peerReservedSignedStateResultProvider.waitForResource());){
            AttemptReconnectResult attemptReconnectResult;
            block18: {
                ReservedSignedStateResult result;
                block16: {
                    AttemptReconnectResult attemptReconnectResult2;
                    block17: {
                        result = Objects.requireNonNull((ReservedSignedStateResult)reservedStateResource.getResource());
                        try {
                            if (!result.isError()) break block16;
                            attemptReconnectResult2 = AttemptReconnectResult.error(Objects.requireNonNull(result.throwable()));
                            if (result == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return attemptReconnectResult2;
                }
                logger.info(LogMarker.RECONNECT.getMarker(), "A state was obtained from a peer");
                SignedStateValidationData data = new SignedStateValidationData(currentState, this.roster);
                SignedStateFileReader.registerServiceStates((SignedState)result.reservedSignedState().get());
                this.signedStateValidator.validate(result.reservedSignedState().get(), this.roster, data);
                logger.info(LogMarker.RECONNECT.getMarker(), "The state obtained from a peer was validated");
                this.loadState(result.reservedSignedState().get());
                this.reconnectCoordinator.sendReconnectCompleteNotification(result.reservedSignedState().get());
                attemptReconnectResult = AttemptReconnectResult.ok();
                if (result == null) break block18;
                result.close();
            }
            return attemptReconnectResult;
        }
        catch (RuntimeException e) {
            return AttemptReconnectResult.error(e);
        }
    }

    private void loadState(@NonNull SignedState signedState) {
        logger.info(LogMarker.STATE_HASH.getMarker(), "RECONNECT: loadState: reloading state");
        logger.debug(LogMarker.RECONNECT.getMarker(), "`loadState` : reloading state");
        Hash reconnectHash = signedState.getState().getHash();
        VirtualMapState state = signedState.getState();
        SemanticVersion creationSoftwareVersion = PlatformStateUtils.creationSoftwareVersionOf((State)state);
        this.consensusStateEventHandler.onStateInitialized((State)state, this.platform, InitTrigger.RECONNECT, creationSoftwareVersion);
        if (!Objects.equals(signedState.getState().getHash(), reconnectHash)) {
            throw new IllegalStateException("State hash is not permitted to change during a reconnect init() call. Previous hash was " + String.valueOf(reconnectHash) + ", new hash is " + String.valueOf(signedState.getState().getHash()));
        }
        long round = signedState.getRound();
        Roster stateRoster = RosterRetriever.retrieveActive((State)state, (long)round);
        if (!this.roster.equals((Object)stateRoster)) {
            throw new IllegalStateException("Current roster and state-based roster do not contain the same nodes  (currentRoster=" + Roster.JSON.toJSON((Object)this.roster) + ") (stateRoster=" + Roster.JSON.toJSON((Object)stateRoster) + ")");
        }
        this.stateLifecycleManager.initStateOnReconnect((Object)state);
        this.reconnectCoordinator.submitStatusAction((PlatformStatusAction)new ReconnectCompleteAction(signedState.getRound()));
        this.savedStateController.reconnectStateReceived(signedState.reserve("savedStateController.reconnectStateReceived"));
        this.reconnectCoordinator.loadReconnectState(this.configuration, signedState);
    }

    private void exitIfMaxRetriesOrWait(int failedReconnectsInARow, @Nullable Throwable throwable) throws InterruptedException {
        if (failedReconnectsInARow >= this.reconnectConfig.maximumReconnectFailuresBeforeShutdown()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectFailurePayload("Too many reconnect failures in a row (%s), killing node".formatted(this.reconnectConfig.maximumReconnectFailuresBeforeShutdown()), ReconnectFailurePayload.CauseOfFailure.ERROR), throwable);
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.RECONNECT_FAILURE);
        } else {
            if (throwable != null) {
                logger.warn(LogMarker.EXCEPTION.getMarker(), () -> new ReconnectFailurePayload("Unexpected exception during reconnect", ReconnectFailurePayload.CauseOfFailure.ERROR), throwable);
            }
            logger.info(LogMarker.RECONNECT.getMarker(), "Reconnect (try {} of {}) failed with error. Will try again after {}.", (Object)failedReconnectsInARow, (Object)this.reconnectConfig.maximumReconnectFailuresBeforeShutdown(), (Object)this.reconnectConfig.minimumTimeBetweenReconnects());
            Thread.sleep(this.reconnectConfig.minimumTimeBetweenReconnects().toMillis());
        }
    }

    private void exitIf() {
        if (!this.reconnectConfig.active()) {
            logger.error(LogMarker.RECONNECT.getMarker(), "Node {} has fallen behind, reconnect is disabled, will die", (Object)this.selfId.id());
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.BEHIND_RECONNECT_DISABLED);
        } else if (this.reconnectConfig.reconnectWindowSeconds() >= 0 && (long)this.reconnectConfig.reconnectWindowSeconds() < Duration.between(this.startupTime, this.time.now()).toSeconds()) {
            logger.error(LogMarker.RECONNECT.getMarker(), "Node {} has fallen behind, reconnect is disabled outside of time window, will die", (Object)this.selfId.id());
            SystemExitUtils.exitSystem((SystemExitCode)SystemExitCode.RECONNECT_FAILURE);
        }
    }

    private record AttemptReconnectResult(boolean success, @Nullable Throwable throwable) {
        static AttemptReconnectResult ok() {
            return new AttemptReconnectResult(true, null);
        }

        static AttemptReconnectResult error(@NonNull Throwable error) {
            return new AttemptReconnectResult(false, error);
        }
    }
}

