/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hyperledger.besu.collections.undo.Undoable;

public class UndoMap<K, V>
implements Map<K, V>,
Undoable {
    Map<K, V> delegate;
    List<UndoEntry<K, V>> undoLog;

    public UndoMap(Map<K, V> delegate) {
        this.delegate = delegate;
        this.undoLog = new ArrayList<UndoEntry<K, V>>();
    }

    @Override
    public void undo(long mark) {
        for (int pos = this.undoLog.size() - 1; pos >= 0 && this.undoLog.get((int)pos).level > mark; --pos) {
            UndoEntry<K, V> entry = this.undoLog.get(pos);
            this.undoLog.remove(pos);
            if (entry.value() == null) {
                this.delegate.remove(entry.key());
                continue;
            }
            this.delegate.put(entry.key(), entry.value());
        }
    }

    @Override
    public long lastUpdate() {
        return this.undoLog.isEmpty() ? 0L : this.undoLog.get((int)(this.undoLog.size() - 1)).level;
    }

    public boolean updated() {
        return !this.undoLog.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(@Nonnull K key, @Nonnull V value) {
        Objects.requireNonNull(value);
        V oldValue = this.delegate.put(key, value);
        if (!value.equals(oldValue)) {
            this.undoLog.add(new UndoEntry<K, V>(key, oldValue));
        }
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        V oldValue = this.delegate.remove(key);
        if (oldValue != null) {
            this.undoLog.add(new UndoEntry<Object, V>(key, oldValue));
        }
        return oldValue;
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.delegate.forEach((k, v) -> this.undoLog.add(new UndoEntry<Object, Object>(k, v)));
        this.delegate.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.delegate.values());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.delegate.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof UndoMap && this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode() ^ 0xDE1E647E;
    }

    record UndoEntry<K, V>(K key, V value, long level) {
        UndoEntry(K key, V value) {
            this(key, value, Undoable.incrementMarkStatic());
        }
    }
}

