/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.frame;

import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.evm.internal.Words;

public class Memory {
    private static final long MAX_BYTES = Integer.MAX_VALUE;
    private byte[] memBytes = new byte[0];
    private int activeWords;

    private static RuntimeException overflow(long v) {
        return Memory.overflow(String.valueOf(v));
    }

    private static RuntimeException overflow(String v) {
        String msg = "Memory index or length %s too large, cannot be larger than %d";
        throw new IllegalStateException(String.format("Memory index or length %s too large, cannot be larger than %d", v, Integer.MAX_VALUE));
    }

    private void checkByteIndex(long v) {
        if (v < 0L || v >= Integer.MAX_VALUE) {
            throw Memory.overflow(v);
        }
    }

    private int asByteIndex(long w) {
        try {
            long v = Math.toIntExact(w);
            this.checkByteIndex(v);
            return (int)v;
        }
        catch (ArithmeticException | IllegalStateException e) {
            throw Memory.overflow(w);
        }
    }

    private static int asByteLength(long l) {
        try {
            return Math.toIntExact(l);
        }
        catch (ArithmeticException | IllegalStateException e) {
            throw Memory.overflow(l);
        }
    }

    long calculateNewActiveWords(long location, long numBytes) {
        if (numBytes == 0L) {
            return this.activeWords;
        }
        try {
            long byteSize = Words.clampedAdd(Words.clampedAdd(location, numBytes), 31L);
            long wordSize = byteSize / 32L;
            return Math.max(wordSize, (long)this.activeWords);
        }
        catch (ArithmeticException ae) {
            return 0x3FFFFFFFFFFFFFFL;
        }
    }

    void ensureCapacityForBytes(long offset, long numBytes) {
        if (numBytes == 0L) {
            return;
        }
        long lastByteIndex = Math.addExact(offset, numBytes);
        long lastWordRequired = (lastByteIndex - 1L) / 32L;
        this.maybeExpandCapacity((int)lastWordRequired + 1);
    }

    private void maybeExpandCapacity(int newActiveWords) {
        if (this.activeWords >= newActiveWords) {
            return;
        }
        int neededSize = newActiveWords * 32;
        if (neededSize > this.memBytes.length) {
            int newSize = Math.max(neededSize, this.memBytes.length * 2);
            byte[] newMem = new byte[newSize];
            System.arraycopy(this.memBytes, 0, newMem, 0, this.memBytes.length);
            this.memBytes = newMem;
        }
        this.activeWords = newActiveWords;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Memory)) {
            return false;
        }
        return Arrays.equals(this.memBytes, ((Memory)other).memBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.memBytes);
    }

    int getActiveBytes() {
        return this.activeWords * 32;
    }

    public int getActiveWords() {
        return this.activeWords;
    }

    public Bytes getBytes(long location, long numBytes) {
        int length = Memory.asByteLength(numBytes);
        if (length == 0) {
            return Bytes.EMPTY;
        }
        int start = this.asByteIndex(location);
        this.ensureCapacityForBytes(start, length);
        return Bytes.wrap((byte[])Arrays.copyOfRange(this.memBytes, start, start + length));
    }

    public Bytes getBytesWithoutGrowth(long location, long numBytes) {
        int length = Memory.asByteLength(numBytes);
        if (length == 0) {
            return Bytes.EMPTY;
        }
        int start = this.asByteIndex(location);
        if (start > this.memBytes.length) {
            return Bytes.wrap((byte[])new byte[(int)numBytes]);
        }
        return Bytes.wrap((byte[])Arrays.copyOfRange(this.memBytes, start, start + length));
    }

    public MutableBytes getMutableBytes(long location, long numBytes) {
        int length = Memory.asByteLength(numBytes);
        if (length == 0) {
            return MutableBytes.EMPTY;
        }
        int start = this.asByteIndex(location);
        this.ensureCapacityForBytes(start, length);
        return MutableBytes.wrap((byte[])this.memBytes, (int)start, (int)length);
    }

    public void setBytes(long memOffset, long offset, long length, Bytes bytes) {
        if (offset >= (long)bytes.size()) {
            this.clearBytes(memOffset, length);
            return;
        }
        Bytes toCopy = bytes.slice((int)offset, Math.min((int)length, bytes.size() - (int)offset));
        this.setBytes(memOffset, length, toCopy);
    }

    public void setBytes(long location, long numBytes, Bytes taintedValue) {
        if (numBytes == 0L) {
            return;
        }
        int start = this.asByteIndex(location);
        int length = Memory.asByteLength(numBytes);
        int srcLength = taintedValue.size();
        int end = Math.addExact(start, length);
        this.ensureCapacityForBytes(start, length);
        if (srcLength >= length) {
            System.arraycopy(taintedValue.toArrayUnsafe(), 0, this.memBytes, start, length);
        } else {
            Arrays.fill(this.memBytes, start + srcLength, end, (byte)0);
            if (srcLength > 0) {
                System.arraycopy(taintedValue.toArrayUnsafe(), 0, this.memBytes, start, srcLength);
            }
        }
    }

    public void setBytesRightAligned(long location, long numBytes, Bytes value) {
        if (numBytes == 0L) {
            return;
        }
        int start = this.asByteIndex(location);
        int length = Memory.asByteLength(numBytes);
        int srcLength = value.size();
        int end = Math.addExact(start, length);
        this.ensureCapacityForBytes(start, length);
        if (srcLength >= length) {
            System.arraycopy(value.toArrayUnsafe(), 0, this.memBytes, start, length);
        } else {
            int divider = end - srcLength;
            Arrays.fill(this.memBytes, start, divider, (byte)0);
            if (srcLength > 0) {
                System.arraycopy(value.toArrayUnsafe(), 0, this.memBytes, divider, srcLength);
            }
        }
    }

    private void clearBytes(long location, long numBytes) {
        int length = Memory.asByteLength(numBytes);
        if (length == 0) {
            return;
        }
        this.clearBytes(this.asByteIndex(location), length);
    }

    private void clearBytes(int location, int numBytes) {
        if (numBytes == 0) {
            return;
        }
        this.ensureCapacityForBytes(location, numBytes);
        Arrays.fill(this.memBytes, location, location + numBytes, (byte)0);
    }

    void setByte(long location, byte value) {
        int start = this.asByteIndex(location);
        this.ensureCapacityForBytes(start, 1L);
        this.memBytes[start] = value;
    }

    public Bytes32 getWord(long location) {
        int start = this.asByteIndex(location);
        this.ensureCapacityForBytes(start, 32L);
        return Bytes32.wrap((byte[])Arrays.copyOfRange(this.memBytes, start, start + 32));
    }

    public void setWord(long location, Bytes32 bytes) {
        int start = this.asByteIndex(location);
        this.ensureCapacityForBytes(start, 32L);
        System.arraycopy(bytes.toArrayUnsafe(), 0, this.memBytes, start, 32);
    }

    public void copy(long dst, long src, long length) {
        this.ensureCapacityForBytes(Math.max(dst, src), length);
        System.arraycopy(this.memBytes, this.asByteIndex(src), this.memBytes, this.asByteIndex(dst), Memory.asByteLength(length));
    }

    public String toString() {
        return Bytes.wrap((byte[])this.memBytes).toHexString();
    }
}

