/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockNodeStats {
    private final Queue<Instant> endOfStreamTimestamps = new ConcurrentLinkedQueue<Instant>();
    private final Queue<Instant> behindPublisherTimestamps = new ConcurrentLinkedQueue<Instant>();
    private Instant behindPublisherIgnoreUntil;
    private final Map<Long, Instant> blockProofSendTimestamps = new ConcurrentHashMap<Long, Instant>();
    private final AtomicInteger consecutiveHighLatencyEvents = new AtomicInteger(0);

    public int getEndOfStreamCount() {
        return this.endOfStreamTimestamps.size();
    }

    public int getBehindPublisherCount() {
        return this.behindPublisherTimestamps.size();
    }

    public boolean addEndOfStreamAndCheckLimit(@NonNull Instant timestamp, int maxAllowed, @NonNull Duration timeFrame) {
        Instant endOfStreamTimestamp;
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        Objects.requireNonNull(timeFrame, "timeFrame must not be null");
        this.endOfStreamTimestamps.add(timestamp);
        Instant now = Instant.now();
        Instant cutoff = now.minus(timeFrame);
        Iterator it = this.endOfStreamTimestamps.iterator();
        while (it.hasNext() && (endOfStreamTimestamp = (Instant)it.next()).isBefore(cutoff)) {
            it.remove();
        }
        return this.endOfStreamTimestamps.size() > maxAllowed;
    }

    public boolean addBehindPublisherAndCheckLimit(@NonNull Instant timestamp, int maxAllowed, @NonNull Duration timeFrame) {
        Instant behindPublisherTimestamp;
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        Objects.requireNonNull(timeFrame, "timeFrame must not be null");
        this.behindPublisherTimestamps.add(timestamp);
        Instant now = Instant.now();
        Instant cutoff = now.minus(timeFrame);
        Iterator it = this.behindPublisherTimestamps.iterator();
        while (it.hasNext() && (behindPublisherTimestamp = (Instant)it.next()).isBefore(cutoff)) {
            it.remove();
        }
        return this.behindPublisherTimestamps.size() > maxAllowed;
    }

    public boolean shouldIgnoreBehindPublisher(@NonNull Instant now, @NonNull Duration ignorePeriod, @NonNull Duration timeFrame) {
        Instant timestamp;
        Objects.requireNonNull(now, "now must not be null");
        Objects.requireNonNull(ignorePeriod, "ignorePeriod must not be null");
        Objects.requireNonNull(timeFrame, "timeFrame must not be null");
        Instant cutoff = now.minus(timeFrame);
        Iterator it = this.behindPublisherTimestamps.iterator();
        while (it.hasNext() && (timestamp = (Instant)it.next()).isBefore(cutoff)) {
            it.remove();
        }
        if (this.behindPublisherTimestamps.isEmpty()) {
            this.behindPublisherIgnoreUntil = null;
        }
        if (this.behindPublisherIgnoreUntil != null && now.isBefore(this.behindPublisherIgnoreUntil)) {
            return true;
        }
        this.behindPublisherIgnoreUntil = now.plus(ignorePeriod);
        return false;
    }

    public void recordBlockProofSent(long blockNumber, @NonNull Instant timestamp) {
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        this.blockProofSendTimestamps.put(blockNumber, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighLatencyResult recordAcknowledgementAndEvaluate(long blockNumber, @NonNull Instant acknowledgedTime, Duration highLatencyThreshold, int eventsBeforeSwitching) {
        int consecutiveCount;
        Objects.requireNonNull(acknowledgedTime, "acknowledgedTime must not be null");
        Instant sendTime = this.blockProofSendTimestamps.get(blockNumber);
        this.blockProofSendTimestamps.keySet().removeIf(key -> key <= blockNumber);
        if (sendTime == null) {
            return new HighLatencyResult(0L, this.consecutiveHighLatencyEvents.get(), false, false);
        }
        long latencyMs = Duration.between(sendTime, acknowledgedTime).toMillis();
        boolean isHighLatency = latencyMs > highLatencyThreshold.toMillis();
        boolean shouldSwitch = false;
        AtomicInteger atomicInteger = this.consecutiveHighLatencyEvents;
        synchronized (atomicInteger) {
            if (isHighLatency) {
                consecutiveCount = this.consecutiveHighLatencyEvents.incrementAndGet();
                if (consecutiveCount >= eventsBeforeSwitching) {
                    shouldSwitch = true;
                    this.consecutiveHighLatencyEvents.set(0);
                }
            } else {
                this.consecutiveHighLatencyEvents.set(0);
                consecutiveCount = 0;
            }
        }
        return new HighLatencyResult(latencyMs, consecutiveCount, isHighLatency, shouldSwitch);
    }

    public record HighLatencyResult(long latencyMs, int consecutiveHighLatencyEvents, boolean isHighLatency, boolean shouldSwitch) {
    }
}

