/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.netty;

import com.hedera.pbj.runtime.io.buffer.BufferedData;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.Drainable;
import io.grpc.KnownLength;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

final class KnownLengthStream
extends InputStream
implements KnownLength,
Drainable {
    private final BufferedData buf;

    public KnownLengthStream(BufferedData buf) {
        this.buf = Objects.requireNonNull(buf);
    }

    @Override
    public int read() {
        if (this.available() == 0) {
            return -1;
        }
        return this.buf.readUnsignedByte();
    }

    @Override
    public int read(@NonNull byte[] b) {
        int remaining = this.available();
        if (remaining == 0) {
            return -1;
        }
        int numBytesToRead = Math.min(remaining, b.length);
        this.buf.readBytes(b, 0, numBytesToRead);
        return numBytesToRead;
    }

    @Override
    public int read(@NonNull byte[] b, int off, int len) {
        int remaining = this.available();
        if (remaining == 0) {
            return -1;
        }
        int numBytesToRead = Math.min(remaining, len);
        this.buf.readBytes(b, off, numBytesToRead);
        return numBytesToRead;
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        int remaining = this.available();
        if (remaining == 0) {
            return 0L;
        }
        int numBytesToSkip = Math.min(remaining, (int)n);
        this.buf.skip((long)numBytesToSkip);
        return numBytesToSkip;
    }

    @Override
    public int available() {
        return (int)this.buf.remaining();
    }

    public int drainTo(OutputStream outputStream) {
        int remaining = this.available();
        if (remaining > 0) {
            this.buf.writeTo(outputStream);
        }
        return remaining;
    }
}

