/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.node.app.records.schemas.V0490BlockRecordSchema;
import com.hedera.node.app.records.schemas.V0560BlockRecordSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Singleton;

@Singleton
public final class BlockRecordService
implements Service {
    private static final Bytes GENESIS_HASH = Bytes.wrap((byte[])new byte[48]);
    public static final String NAME = "BlockRecordService";
    public static final Timestamp EPOCH = new Timestamp(0L, 0);
    public static final BlockInfo GENESIS_BLOCK_INFO = new BlockInfo(-1L, EPOCH, Bytes.EMPTY, EPOCH, true, EPOCH, EPOCH, EPOCH);
    public static final RunningHashes GENESIS_RUNNING_HASHES = RunningHashes.newBuilder().runningHash(GENESIS_HASH).build();

    @NonNull
    public String getServiceName() {
        return NAME;
    }

    public void registerSchemas(@NonNull SchemaRegistry registry) {
        registry.register((Schema)new V0490BlockRecordSchema());
        registry.register((Schema)new V0560BlockRecordSchema());
    }

    public boolean doGenesisSetup(@NonNull WritableStates writableStates, @NonNull Configuration configuration) {
        Objects.requireNonNull(writableStates);
        Objects.requireNonNull(configuration);
        writableStates.getSingleton(V0490BlockRecordSchema.BLOCKS_STATE_ID).put((Object)GENESIS_BLOCK_INFO);
        writableStates.getSingleton(V0490BlockRecordSchema.RUNNING_HASHES_STATE_ID).put((Object)GENESIS_RUNNING_HASHES);
        return true;
    }
}

