/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.record;

import com.hedera.hapi.node.addressbook.NodeCreateTransactionBody;
import com.hedera.hapi.node.addressbook.NodeDeleteTransactionBody;
import com.hedera.hapi.node.addressbook.NodeUpdateTransactionBody;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.CurrentAndNextFeeSchedule;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.transaction.NodeStakeUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.tss.LedgerIdNodeContribution;
import com.hedera.hapi.node.tss.LedgerIdPublicationTransactionBody;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.addressbook.impl.schemas.V053AddressBookSchema;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.entityid.ReadableEntityIdStore;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.entityid.impl.schemas.V0490EntityIdSchema;
import com.hedera.node.app.service.entityid.impl.schemas.V0590EntityIdSchema;
import com.hedera.node.app.service.file.impl.FileServiceImpl;
import com.hedera.node.app.service.file.impl.schemas.V0490FileSchema;
import com.hedera.node.app.service.token.impl.BlocklistParser;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.EndOfStakingPeriodUtils;
import com.hedera.node.app.service.token.impl.schemas.V0610TokenSchema;
import com.hedera.node.app.services.ServicesRegistry;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.app.spi.records.RecordSource;
import com.hedera.node.app.spi.records.SelfNodeAccountIdManager;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.SystemContext;
import com.hedera.node.app.state.HederaRecordCache;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.node.app.state.recordcache.LegacyListRecordSource;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.HandleOutput;
import com.hedera.node.app.workflows.handle.TransactionType;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.app.workflows.handle.steps.ParentTxnFactory;
import com.hedera.node.app.workflows.handle.steps.StakePeriodChanges;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.BootstrapConfig;
import com.hedera.node.config.data.ConsensusConfig;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hedera.node.config.data.StakingConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.node.internal.network.Network;
import com.hedera.node.internal.network.NodeMetadata;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.Service;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.LongStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.node.NodeUtilities;
import org.hiero.consensus.platformstate.V0540PlatformStateSchema;
import org.hiero.consensus.roster.ReadableRosterStore;
import org.hiero.hapi.support.fees.FeeSchedule;

@Singleton
public class SystemTransactions {
    private static final Logger log = LogManager.getLogger(SystemTransactions.class);
    private static final int DEFAULT_GENESIS_WEIGHT = 500;
    private static final long FIRST_RESERVED_SYSTEM_CONTRACT = 350L;
    private static final long LAST_RESERVED_SYSTEM_CONTRACT = 399L;
    private static final long FIRST_POST_SYSTEM_FILE_ENTITY = 200L;
    private static final long FIRST_MISC_ACCOUNT_NUM = 900L;
    private static final List<ServiceEndpoint> UNKNOWN_HAPI_ENDPOINT = List.of(V053AddressBookSchema.endpointFor((String)"1.0.0.0", (int)1));
    private static final EnumSet<ResponseCodeEnum> SUCCESSES = EnumSet.of(ResponseCodeEnum.SUCCESS, ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION);
    private static final Consumer<Dispatch> DEFAULT_DISPATCH_ON_SUCCESS = dispatch -> {};
    private final InitTrigger initTrigger;
    private final BlocklistParser blocklistParser = new BlocklistParser();
    private final FileServiceImpl fileService;
    private final ParentTxnFactory parentTxnFactory;
    private final StreamMode streamMode;
    private final NetworkInfo networkInfo;
    private final DispatchProcessor dispatchProcessor;
    private final ConfigProvider configProvider;
    private final EntityIdFactory idFactory;
    private final ServicesRegistry servicesRegistry;
    private final BlockRecordManager blockRecordManager;
    private final BlockStreamManager blockStreamManager;
    private final ExchangeRateManager exchangeRateManager;
    private final HederaRecordCache recordCache;
    private final StartupNetworks startupNetworks;
    private final StakePeriodChanges stakePeriodChanges;
    private final SelfNodeAccountIdManager selfNodeAccountIdManager;
    private int nextDispatchNonce = 1;

    @Inject
    public SystemTransactions(@NonNull InitTrigger initTrigger, @NonNull ParentTxnFactory parentTxnFactory, @NonNull FileServiceImpl fileService, @NonNull NetworkInfo networkInfo, @NonNull ConfigProvider configProvider, @NonNull DispatchProcessor dispatchProcessor, @NonNull AppContext appContext, @NonNull ServicesRegistry servicesRegistry, @NonNull BlockRecordManager blockRecordManager, @NonNull BlockStreamManager blockStreamManager, @NonNull ExchangeRateManager exchangeRateManager, @NonNull HederaRecordCache recordCache, @NonNull StartupNetworks startupNetworks, @NonNull StakePeriodChanges stakePeriodChanges, @NonNull SelfNodeAccountIdManager selfNodeAccountIdManager) {
        this.initTrigger = Objects.requireNonNull(initTrigger);
        this.fileService = Objects.requireNonNull(fileService);
        this.parentTxnFactory = Objects.requireNonNull(parentTxnFactory);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.streamMode = ((BlockStreamConfig)configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamMode();
        this.idFactory = appContext.idFactory();
        this.servicesRegistry = Objects.requireNonNull(servicesRegistry);
        this.blockRecordManager = Objects.requireNonNull(blockRecordManager);
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.recordCache = Objects.requireNonNull(recordCache);
        this.startupNetworks = Objects.requireNonNull(startupNetworks);
        this.stakePeriodChanges = Objects.requireNonNull(stakePeriodChanges);
        this.selfNodeAccountIdManager = Objects.requireNonNull(selfNodeAccountIdManager);
    }

    public void resetNextDispatchNonce() {
        this.nextDispatchNonce = 1;
    }

    public void doGenesisSetup(@NonNull Instant now, @NonNull State state, @NonNull StateChangeStreaming stateChangeStreaming) {
        Objects.requireNonNull(now);
        Objects.requireNonNull(state);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        WritableStates writablePlatformStates = state.getWritableStates("PlatformStateService");
        stateChangeStreaming.doStreamingChanges(writablePlatformStates, null, () -> {
            WritableSingletonState platformStateSingleton = writablePlatformStates.getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID);
            platformStateSingleton.put((Object)((PlatformState)platformStateSingleton.get()));
        });
        for (ServicesRegistry.Registration r : this.servicesRegistry.registrations()) {
            Service service = r.service();
            if ("PlatformStateService".equals(service.getServiceName())) continue;
            WritableStates writableStates = state.getWritableStates(service.getServiceName());
            stateChangeStreaming.doStreamingChanges(writableStates, null, () -> service.doGenesisSetup(writableStates, (Configuration)config));
        }
        AtomicReference<Consumer<Dispatch>> onSuccess = new AtomicReference<Consumer<Dispatch>>(DEFAULT_DISPATCH_ON_SUCCESS);
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> ((Consumer)onSuccess.get()).accept(dispatch), UseReservedConsensusTimes.YES, TriggerStakePeriodSideEffects.NO);
        LedgerConfig ledgerConfig = (LedgerConfig)config.getConfigData(LedgerConfig.class);
        AccountsConfig accountsConfig = (AccountsConfig)config.getConfigData(AccountsConfig.class);
        BootstrapConfig bootstrapConfig = (BootstrapConfig)config.getConfigData(BootstrapConfig.class);
        Key systemKey = Key.newBuilder().ed25519(bootstrapConfig.genesisPublicKey()).build();
        Duration systemAutoRenewPeriod = new Duration(ledgerConfig.autoRenewPeriodMaxDuration());
        int n = ledgerConfig.numSystemAccounts();
        for (int i = 1; i <= n; ++i) {
            long num = i;
            systemContext.dispatchCreation(b -> b.memo("Synthetic system creation").cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(systemKey).autoRenewPeriod(systemAutoRenewPeriod).initialBalance(num == accountsConfig.treasury() ? ledgerConfig.totalTinyBarFloat() : 0L).build()).build(), (long)i);
        }
        for (long i : LongStream.rangeClosed(200L, ledgerConfig.numReservedSystemEntities()).filter(j -> j < 350L || j > 399L).toArray()) {
            systemContext.dispatchCreation(b -> b.memo("Synthetic zero-balance treasury clone").cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(systemKey).autoRenewPeriod(systemAutoRenewPeriod).build()).build(), i);
        }
        Object i = List.of(Long.valueOf(accountsConfig.stakingRewardAccount()), Long.valueOf(accountsConfig.nodeRewardAccount())).iterator();
        while (i.hasNext()) {
            long i2 = (Long)i.next();
            systemContext.dispatchCreation(b -> b.memo("Release 0.24.1 migration record").cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(KeyUtils.IMMUTABILITY_SENTINEL_KEY).autoRenewPeriod(systemAutoRenewPeriod).build()).build(), i2);
        }
        systemContext.dispatchCreation(b -> b.memo("Fee collection account creation record").cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(KeyUtils.IMMUTABILITY_SENTINEL_KEY).autoRenewPeriod(systemAutoRenewPeriod).build()).build(), accountsConfig.feeCollectionAccount());
        HederaConfig hederaConfig = (HederaConfig)config.getConfigData(HederaConfig.class);
        for (long i3 : LongStream.range(900L, hederaConfig.firstUserEntity()).toArray()) {
            systemContext.dispatchCreation(b -> b.cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(systemKey).autoRenewPeriod(systemAutoRenewPeriod).build()).build(), i3);
        }
        if (accountsConfig.blocklistEnabled()) {
            Object i2 = this.blocklistParser.parse(accountsConfig.blocklistResource()).iterator();
            while (i2.hasNext()) {
                BlocklistParser.BlockedInfo info = (BlocklistParser.BlockedInfo)i2.next();
                systemContext.dispatchAdmin(b -> b.cryptoCreateAccount(CryptoCreateTransactionBody.newBuilder().key(systemKey).autoRenewPeriod(systemAutoRenewPeriod).receiverSigRequired(true).declineReward(true).alias(info.evmAddress()).memo(info.memo()).build()));
            }
        }
        StakingConfig stakingConfig = (StakingConfig)config.getConfigData(StakingConfig.class);
        int numStoredPeriods = stakingConfig.rewardHistoryNumStoredPeriods();
        Map nodeAdminKeys = V053AddressBookSchema.parseEd25519NodeAdminKeysFrom((String)bootstrapConfig.nodeAdminKeysPath());
        ArrayList nodeStakes = new ArrayList();
        for (NodeInfo nodeInfo : this.networkInfo.addressBook()) {
            Key adminKey = nodeAdminKeys.getOrDefault(nodeInfo.nodeId(), systemKey);
            if (adminKey != systemKey) {
                log.info("Override admin key for node{} is :: {}", (Object)nodeInfo.nodeId(), (Object)adminKey);
            }
            List hapiEndpoints = nodeInfo.hapiEndpoints().isEmpty() ? UNKNOWN_HAPI_ENDPOINT : nodeInfo.hapiEndpoints();
            onSuccess.set(dispatch -> {
                SavepointStackImpl stack = dispatch.stack();
                WritableStakingInfoStore writableStakingInfoStore = new WritableStakingInfoStore(stack.getWritableStates("TokenService"), (WritableEntityCounters)new WritableEntityIdStoreImpl(stack.getWritableStates("EntityIdService")));
                if (writableStakingInfoStore.get(nodeInfo.nodeId()) == null) {
                    log.info("Creating staking info for node{}", (Object)nodeInfo.nodeId());
                    Object[] rewardSumHistory = new Long[numStoredPeriods + 1];
                    Arrays.fill(rewardSumHistory, (Object)0L);
                    StakingNodeInfo stakingNodeInfo = StakingNodeInfo.newBuilder().nodeNumber(nodeInfo.nodeId()).maxStake(stakingConfig.maxStake()).minStake(stakingConfig.minStake()).rewardSumHistory(Arrays.asList(rewardSumHistory)).weight(500).build();
                    writableStakingInfoStore.putAndIncrementCount(nodeInfo.nodeId(), stakingNodeInfo);
                    stack.commitFullStack();
                    nodeStakes.add(EndOfStakingPeriodUtils.fromStakingInfo((long)0L, (StakingNodeInfo)stakingNodeInfo));
                }
            });
            systemContext.dispatchCreation(b -> {
                NodeCreateTransactionBody.Builder nodeCreate = NodeCreateTransactionBody.newBuilder().adminKey(adminKey).accountId(nodeInfo.accountId()).description(NodeUtilities.formatNodeName((long)nodeInfo.nodeId())).gossipEndpoint(nodeInfo.gossipEndpoints()).gossipCaCertificate(nodeInfo.sigCertBytes()).serviceEndpoint(hapiEndpoints).declineReward(true);
                Optional.ofNullable(nodeInfo.grpcCertHash()).ifPresent(arg_0 -> ((NodeCreateTransactionBody.Builder)nodeCreate).grpcCertificateHash(arg_0));
                b.nodeCreate(nodeCreate.build());
            }, nodeInfo.nodeId());
        }
        this.networkInfo.updateFrom(state);
        onSuccess.set(DEFAULT_DISPATCH_ON_SUCCESS);
        ReadableNodeStore nodeStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableNodeStore.class);
        this.fileService.createSystemEntities(systemContext, nodeStore);
        NodeStakeUpdateTransactionBody nodeStakeUpdate = EndOfStakingPeriodUtils.newNodeStakeUpdate((Timestamp)EndOfStakingPeriodUtils.lastInstantOfPreviousPeriodFor((Instant)now), nodeStakes, (StakingConfig)stakingConfig, (long)0L, (long)0L, (long)0L, (long)0L);
        systemContext.dispatchAdmin(b -> b.memo("End of staking period calculation record").nodeStakeUpdate(nodeStakeUpdate));
    }

    public void doPostUpgradeSetup(@NonNull Instant now, @NonNull State state) {
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> {}, UseReservedConsensusTimes.YES, TriggerStakePeriodSideEffects.YES);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        NodesConfig nodesConfig = (NodesConfig)config.getConfigData(NodesConfig.class);
        if (nodesConfig.enableDAB()) {
            ReadableNodeStore nodeStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableNodeStore.class);
            this.fileService.updateAddressBookAndNodeDetailsAfterFreeze(systemContext, nodeStore);
        }
        this.selfNodeAccountIdManager.setSelfNodeAccountId(this.networkInfo.selfNodeInfo().accountId());
        FilesConfig filesConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        NetworkAdminConfig adminConfig = (NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class);
        ArrayList<AutoEntityUpdate<Bytes>> autoSysFileUpdates = new ArrayList<AutoEntityUpdate<Bytes>>(List.of(new AutoEntityUpdate<Bytes>((ctx, bytes) -> V0490FileSchema.dispatchSynthFileUpdate((SystemContext)ctx, (FileID)FileUtilities.createFileID(filesConfig.feeSchedules(), (Configuration)config), (Bytes)bytes), adminConfig.upgradeFeeSchedulesFile(), SystemTransactions::parseFeeSchedules), new AutoEntityUpdate<Bytes>((ctx, bytes) -> V0490FileSchema.dispatchSynthFileUpdate((SystemContext)ctx, (FileID)FileUtilities.createFileID(filesConfig.throttleDefinitions(), (Configuration)config), (Bytes)bytes), adminConfig.upgradeThrottlesFile(), SystemTransactions::parseThrottles), new AutoEntityUpdate<Bytes>((ctx, bytes) -> V0490FileSchema.dispatchSynthFileUpdate((SystemContext)ctx, (FileID)FileUtilities.createFileID(filesConfig.networkProperties(), (Configuration)config), (Bytes)bytes), adminConfig.upgradePropertyOverridesFile(), in -> SystemTransactions.parseConfig("override network properties", in)), new AutoEntityUpdate<Bytes>((ctx, bytes) -> V0490FileSchema.dispatchSynthFileUpdate((SystemContext)ctx, (FileID)FileUtilities.createFileID(filesConfig.hapiPermissions(), (Configuration)config), (Bytes)bytes), adminConfig.upgradePermissionOverridesFile(), in -> SystemTransactions.parseConfig("override HAPI permissions", in))));
        FeesConfig feesConfig = (FeesConfig)config.getConfigData(FeesConfig.class);
        if (feesConfig.createSimpleFeeSchedule()) {
            FileID simpleFeesFileId = FileUtilities.createFileID(filesConfig.simpleFeesSchedules(), (Configuration)config);
            ReadableKVState filesState = state.getReadableStates("FileService").get(V0490FileSchema.FILES_STATE_ID);
            if (filesState.get((Object)simpleFeesFileId) == null) {
                log.info("Creating simple fee schedule file {}.{}.{} (upgrading from pre-simple-fees version)", (Object)simpleFeesFileId.shardNum(), (Object)simpleFeesFileId.realmNum(), (Object)simpleFeesFileId.fileNum());
                this.fileService.fileSchema().createGenesisSimpleFeesSchedule(systemContext);
            }
            autoSysFileUpdates.add(new AutoEntityUpdate<Bytes>((ctx, bytes) -> V0490FileSchema.dispatchSynthFileUpdate((SystemContext)ctx, (FileID)FileUtilities.createFileID(filesConfig.simpleFeesSchedules(), (Configuration)config), (Bytes)bytes), adminConfig.upgradeSimpleFeeSchedulesFile(), SystemTransactions::parseSimpleFeesSchedules));
        }
        autoSysFileUpdates.forEach(update -> update.tryIfPresent(adminConfig.upgradeSysFilesLoc(), systemContext));
        AutoEntityUpdate<Map> autoNodeAdminKeyUpdates = new AutoEntityUpdate<Map>((ctx, nodeAdminKeys) -> nodeAdminKeys.forEach((nodeId, key) -> ctx.dispatchAdmin(b -> b.nodeUpdate(NodeUpdateTransactionBody.newBuilder().nodeId(nodeId.longValue()).adminKey(key).build()))), adminConfig.upgradeNodeAdminKeysFile(), SystemTransactions::parseNodeAdminKeys);
        autoNodeAdminKeyUpdates.tryIfPresent(adminConfig.upgradeSysFilesLoc(), systemContext);
    }

    public void dispatchNodePayments(@NonNull State state, @NonNull Instant now, @NonNull TransferList transfers) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(now);
        Objects.requireNonNull(transfers);
        if (transfers.accountAmounts().isEmpty()) {
            log.info("No fees to distribute for nodes");
            return;
        }
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> {}, UseReservedConsensusTimes.NO, TriggerStakePeriodSideEffects.YES);
        systemContext.dispatchAdmin(b -> b.memo("Synthetic node fees payment").cryptoTransfer(CryptoTransferTransactionBody.newBuilder().transfers(transfers).build()).build());
    }

    public void externalizeLedgerId(@NonNull State state, @NonNull Instant now, @NonNull Bytes ledgerId, @NonNull List<ProofKey> proofKeys, @NonNull SortedMap<Long, Long> targetNodeWeights, @NonNull Bytes historyProofVerificationKey) {
        Objects.requireNonNull(now);
        Objects.requireNonNull(ledgerId);
        Objects.requireNonNull(proofKeys);
        Objects.requireNonNull(targetNodeWeights);
        Objects.requireNonNull(historyProofVerificationKey);
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> {}, UseReservedConsensusTimes.NO, TriggerStakePeriodSideEffects.YES);
        List<LedgerIdNodeContribution> contributions = proofKeys.stream().map(proofKey -> LedgerIdNodeContribution.newBuilder().nodeId(proofKey.nodeId()).historyProofKey(proofKey.key()).weight(((Long)targetNodeWeights.get(proofKey.nodeId())).longValue()).build()).toList();
        systemContext.dispatchAdmin(b -> b.memo("Ledger id").ledgerIdPublication(LedgerIdPublicationTransactionBody.newBuilder().ledgerId(ledgerId).nodeContributions(contributions).historyProofVerificationKey(historyProofVerificationKey).build()));
    }

    public void dispatchNodeRewards(@NonNull State state, @NonNull Instant now, @NonNull List<Long> activeNodeIds, long perNodeReward, @NonNull AccountID nodeRewardsAccountId, long rewardAccountBalance, long minNodeReward, @NonNull List<RosterEntry> rosterEntries) {
        long inactiveTotal;
        Objects.requireNonNull(state);
        Objects.requireNonNull(now);
        Objects.requireNonNull(activeNodeIds);
        Objects.requireNonNull(nodeRewardsAccountId);
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> {}, UseReservedConsensusTimes.NO, TriggerStakePeriodSideEffects.YES);
        List<AccountID> activeNodeAccountIds = activeNodeIds.stream().map(id -> systemContext.networkInfo().nodeInfo(id.longValue())).filter(nodeInfo -> nodeInfo != null && !nodeInfo.declineReward()).map(NodeInfo::accountId).toList();
        List<AccountID> inactiveNodeAccountIds = rosterEntries.stream().map(RosterEntry::nodeId).filter(id -> !activeNodeIds.contains(id)).map(id -> systemContext.networkInfo().nodeInfo(id.longValue())).filter(nodeInfo -> nodeInfo != null && !nodeInfo.declineReward()).map(NodeInfo::accountId).toList();
        if (activeNodeAccountIds.isEmpty() && (minNodeReward <= 0L || inactiveNodeAccountIds.isEmpty())) {
            return;
        }
        log.info("Found active node accounts {}", activeNodeAccountIds);
        if (minNodeReward > 0L && !inactiveNodeAccountIds.isEmpty()) {
            log.info("Found inactive node accounts {} that will receive minimum node reward {}", inactiveNodeAccountIds, (Object)minNodeReward);
        }
        long activeTotal = (long)activeNodeAccountIds.size() * perNodeReward;
        long l = inactiveTotal = minNodeReward > 0L ? (long)inactiveNodeAccountIds.size() * minNodeReward : 0L;
        if (rewardAccountBalance <= activeTotal) {
            long activeNodeReward = rewardAccountBalance / (long)activeNodeAccountIds.size();
            log.info("Balance insufficient for all, rewarding active nodes only: {} tinybars each", (Object)activeNodeReward);
            if (activeNodeReward > 0L) {
                V0610TokenSchema.dispatchSynthNodeRewards((SystemContext)systemContext, activeNodeAccountIds, (AccountID)nodeRewardsAccountId, (long)activeNodeReward);
            }
        } else {
            long activeNodeReward = activeNodeAccountIds.isEmpty() ? 0L : activeTotal / (long)activeNodeAccountIds.size();
            long totalInactiveNodesReward = Math.min(Math.max(0L, rewardAccountBalance - activeTotal), inactiveTotal);
            long inactiveNodeReward = inactiveNodeAccountIds.isEmpty() ? 0L : totalInactiveNodesReward / (long)inactiveNodeAccountIds.size();
            log.info("Paying active nodes {} tinybars each, inactive nodes {} tinybars each", (Object)activeNodeReward, (Object)inactiveNodeReward);
            V0610TokenSchema.dispatchSynthNodeRewards((SystemContext)systemContext, activeNodeAccountIds, (AccountID)nodeRewardsAccountId, (long)activeNodeReward, inactiveNodeAccountIds, (long)inactiveNodeReward);
        }
    }

    public boolean dispatchTransplantUpdates(State state, Instant now, long currentRoundNum) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(now);
        ReadableStoreFactoryImpl readableStoreFactory = new ReadableStoreFactoryImpl(state);
        ReadableRosterStore rosterStore = readableStoreFactory.readableStore(ReadableRosterStore.class);
        ReadableNodeStore nodeStore = readableStoreFactory.readableStore(ReadableNodeStore.class);
        SystemContext systemContext = this.newSystemContext(now, state, dispatch -> {}, UseReservedConsensusTimes.YES, TriggerStakePeriodSideEffects.YES);
        Optional network = this.startupNetworks.overrideNetworkFor(currentRoundNum - 1L, (Configuration)this.configProvider.getConfiguration());
        if (rosterStore.isTransplantInProgress() && network.isPresent()) {
            log.info("Roster transplant in progress, dispatching node updates for round {}", (Object)(currentRoundNum - 1L));
            List<Long> overrideNodes = ((Network)network.get()).nodeMetadata().stream().filter(NodeMetadata::hasRosterEntry).map(NodeMetadata::rosterEntryOrThrow).map(RosterEntry::nodeId).toList();
            for (NodeMetadata meta : ((Network)network.get()).nodeMetadata()) {
                Node node = meta.node();
                if (node == null) continue;
                Node currentNode = nodeStore.get(node.nodeId());
                if (currentNode == null || currentNode.deleted()) {
                    systemContext.dispatchCreation(b -> b.memo("Synthetic node creation").nodeCreate(NodeCreateTransactionBody.newBuilder().adminKey(node.adminKey()).accountId(node.accountId()).description(node.description()).gossipEndpoint(node.gossipEndpoint()).gossipCaCertificate(node.gossipCaCertificate()).serviceEndpoint(node.serviceEndpoint()).declineReward(node.declineReward()).grpcProxyEndpoint(node.grpcProxyEndpoint()).grpcCertificateHash(node.grpcCertificateHash()).build()).build(), node.nodeId());
                    log.info("Node {} is new in override network and is being created", (Object)node.nodeId());
                    continue;
                }
                systemContext.dispatchAdmin(b -> b.memo("Synthetic node update").nodeUpdate(NodeUpdateTransactionBody.newBuilder().nodeId(node.nodeId()).adminKey(node.adminKey()).description(node.description()).gossipEndpoint(node.gossipEndpoint()).gossipCaCertificate(node.gossipCaCertificate()).serviceEndpoint(node.serviceEndpoint()).declineReward(Boolean.valueOf(node.declineReward())).grpcProxyEndpoint(node.grpcProxyEndpoint()).grpcCertificateHash(node.grpcCertificateHash()).build()));
                log.info("Node {} in state is part of the override network and is being updated", (Object)node.nodeId());
            }
            long numNodes = readableStoreFactory.readableStore(ReadableEntityIdStore.class).numNodes();
            int i = 0;
            while ((long)i < numNodes) {
                long nodeId = i;
                Node existingNode = nodeStore.get((long)i);
                if (existingNode != null && !overrideNodes.contains(nodeId) && !existingNode.deleted()) {
                    systemContext.dispatchAdmin(b -> b.memo("Synthetic node deletion").nodeDelete(NodeDeleteTransactionBody.newBuilder().nodeId(nodeId).build()));
                    log.info("Node {} in state is not part of the override network and is being marked deleted", (Object)i);
                }
                ++i;
            }
            log.info("Roster transplant completed, node updates dispatched");
            return true;
        }
        return false;
    }

    public Instant firstReservedSystemTimeFor(@NonNull Instant firstEventTime) {
        Objects.requireNonNull(firstEventTime);
        VersionedConfiguration config = this.configProvider.getConfiguration();
        ConsensusConfig consensusConfig = (ConsensusConfig)config.getConfigData(ConsensusConfig.class);
        return firstEventTime.minusNanos(1L).minusNanos(consensusConfig.handleMaxPrecedingRecords()).minusNanos(((SchedulingConfig)config.getConfigData(SchedulingConfig.class)).reservedSystemTxnNanos()).minusNanos(this.initTrigger == InitTrigger.GENESIS ? (long)((int)((HederaConfig)config.getConfigData(HederaConfig.class)).firstUserEntity()) : 0L);
    }

    private SystemContext newSystemContext(@NonNull Instant now, final @NonNull State state, final @NonNull Consumer<Dispatch> onSuccess, @NonNull UseReservedConsensusTimes useReservedConsensusTimes, final @NonNull TriggerStakePeriodSideEffects triggerStakePeriodSideEffects) {
        boolean applyStakePeriodSideEffects;
        final VersionedConfiguration config = this.configProvider.getConfiguration();
        boolean useReserved = useReservedConsensusTimes == UseReservedConsensusTimes.YES;
        Instant firstConsTime = useReserved ? this.firstReservedSystemTimeFor(now) : now;
        boolean bl = applyStakePeriodSideEffects = triggerStakePeriodSideEffects == TriggerStakePeriodSideEffects.YES;
        final AtomicInteger remainingDispatches = new AtomicInteger(useReserved ? (int)java.time.Duration.between(firstConsTime, now).toNanos() / (applyStakePeriodSideEffects ? 2 : 1) : 1);
        final AtomicReference<Instant> nextConsTime = new AtomicReference<Instant>(firstConsTime);
        final AccountID systemAdminId = this.idFactory.newAccountId(((AccountsConfig)config.getConfigData(AccountsConfig.class)).systemAdmin());
        final NodeInfo creatorInfo = (NodeInfo)this.networkInfo.addressBook().getFirst();
        final Duration validDuration = new Duration(((HederaConfig)config.getConfigData(HederaConfig.class)).transactionMaxValidDuration());
        return new SystemContext(){

            public boolean hasDispatchesRemaining() {
                return remainingDispatches.get() > 0;
            }

            public void dispatchAdmin(@NonNull Consumer<TransactionBody.Builder> spec) {
                Objects.requireNonNull(spec);
                TransactionBody.Builder builder = TransactionBody.newBuilder().transactionValidDuration(validDuration).transactionID(TransactionID.newBuilder().accountID(systemAdminId).transactionValidStart(HapiUtils.asTimestamp((Instant)this.now())).nonce(SystemTransactions.this.nextDispatchNonce++).build());
                spec.accept(builder);
                TransactionBody body = builder.build();
                HandleOutput output = this.dispatch(body, 0L, triggerStakePeriodSideEffects);
                List<ResponseCodeEnum> statuses = output.preferringBlockRecordSource().identifiedReceipts().stream().map(RecordSource.IdentifiedReceipt::receipt).map(TransactionReceipt::status).toList();
                if (!SUCCESSES.containsAll(statuses)) {
                    log.warn("Failed to dispatch system transaction {} - {}", (Object)body, statuses);
                }
            }

            public void dispatchCreation(@NonNull Consumer<TransactionBody.Builder> spec, long entityNum) {
                Objects.requireNonNull(spec);
                TransactionBody.Builder builder = TransactionBody.newBuilder().transactionValidDuration(validDuration).transactionID(TransactionID.newBuilder().accountID(systemAdminId).transactionValidStart(HapiUtils.asTimestamp((Instant)this.now())).nonce(SystemTransactions.this.nextDispatchNonce++).build());
                spec.accept(builder);
                this.dispatchCreation(builder.build(), entityNum);
            }

            public void dispatchCreation(@NonNull TransactionBody body, long entityNum) {
                Objects.requireNonNull(body);
                this.dispatch(body, entityNum, triggerStakePeriodSideEffects);
            }

            @NonNull
            public Configuration configuration() {
                return config;
            }

            @NonNull
            public NetworkInfo networkInfo() {
                return SystemTransactions.this.networkInfo;
            }

            @NonNull
            public Instant now() {
                return (Instant)nextConsTime.get();
            }

            private HandleOutput dispatch(@NonNull TransactionBody body, long entityNum, @NonNull TriggerStakePeriodSideEffects triggerStakePeriodSideEffects2) {
                if (remainingDispatches.decrementAndGet() < 0) {
                    throw new IllegalStateException("No more dispatches remaining in the system context");
                }
                boolean applyStakePeriodSideEffects = triggerStakePeriodSideEffects2 == TriggerStakePeriodSideEffects.YES;
                int maxNanosUsed = applyStakePeriodSideEffects ? 2 : 1;
                Instant now = (Instant)nextConsTime.getAndUpdate(then -> then.plusNanos(maxNanosUsed));
                if (SystemTransactions.this.streamMode != StreamMode.BLOCKS) {
                    SystemTransactions.this.blockRecordManager.startUserTransaction(now, state);
                }
                HandleOutput handleOutput = SystemTransactions.this.executeSystem(state, now, creatorInfo, systemAdminId, body, entityNum, onSuccess, applyStakePeriodSideEffects);
                if (SystemTransactions.this.streamMode != StreamMode.BLOCKS) {
                    List<SingleTransactionRecord> records = ((LegacyListRecordSource)handleOutput.recordSourceOrThrow()).precomputedRecords();
                    SystemTransactions.this.blockRecordManager.endUserTransaction(records.stream(), state);
                }
                if (SystemTransactions.this.streamMode != StreamMode.RECORDS) {
                    handleOutput.blockRecordSourceOrThrow().forEachItem(SystemTransactions.this.blockStreamManager::writeItem);
                }
                return handleOutput;
            }
        };
    }

    private HandleOutput executeSystem(@NonNull State state, @NonNull Instant now, @NonNull NodeInfo creatorInfo, @NonNull AccountID payerId, @NonNull TransactionBody body, long nextEntityNum, @NonNull Consumer<Dispatch> onSuccess, boolean applyStakePeriodSideEffects) {
        ParentTxn parentTxn = this.parentTxnFactory.createSystemTxn(state, creatorInfo, now, TransactionType.INTERNAL_TRANSACTION, payerId, body);
        parentTxn.initBaseBuilder(this.exchangeRateManager.exchangeRates());
        Dispatch dispatch = this.parentTxnFactory.createDispatch(parentTxn, parentTxn.baseBuilder(), ignore -> true, HandleContext.TransactionCategory.NODE);
        this.stakePeriodChanges.advanceTimeTo(parentTxn, applyStakePeriodSideEffects);
        try {
            long prevEntityNum;
            if (dispatch.txnInfo().functionality() == HederaFunctionality.NODE_CREATE) {
                WritableSingletonState countsBefore = dispatch.stack().getWritableStates("EntityIdService").getSingleton(V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID);
                prevEntityNum = Objects.requireNonNull((EntityCounts)countsBefore.get()).numNodes();
                countsBefore.put((Object)Objects.requireNonNull((EntityCounts)countsBefore.get()).copyBuilder().numNodes(nextEntityNum).build());
            } else {
                WritableSingletonState controlledNum = dispatch.stack().getWritableStates("EntityIdService").getSingleton(V0490EntityIdSchema.ENTITY_ID_STATE_ID);
                prevEntityNum = Objects.requireNonNull((EntityNumber)controlledNum.get()).number();
                if (nextEntityNum != 0L) {
                    controlledNum.put((Object)new EntityNumber(nextEntityNum - 1L));
                }
            }
            this.dispatchProcessor.processDispatch(dispatch);
            boolean isSuccess = SUCCESSES.contains(dispatch.streamBuilder().status());
            if (!isSuccess) {
                log.error("Failed to dispatch system transaction {}{} - {}", (Object)body, nextEntityNum == 0L ? "" : " for entity #" + nextEntityNum, (Object)dispatch.streamBuilder().status());
            } else {
                onSuccess.accept(dispatch);
            }
            if (dispatch.txnInfo().functionality() == HederaFunctionality.NODE_CREATE) {
                WritableSingletonState countsBefore = dispatch.stack().getWritableStates("EntityIdService").getSingleton(V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID);
                countsBefore.put((Object)Objects.requireNonNull((EntityCounts)countsBefore.get()).copyBuilder().numNodes(isSuccess ? Math.max(nextEntityNum + 1L, prevEntityNum) : prevEntityNum).build());
            } else {
                WritableSingletonState controlledNum = dispatch.stack().getWritableStates("EntityIdService").getSingleton(V0490EntityIdSchema.ENTITY_ID_STATE_ID);
                if (nextEntityNum != 0L) {
                    controlledNum.put((Object)new EntityNumber(prevEntityNum));
                }
            }
            dispatch.stack().commitFullStack();
            HandleOutput handleOutput = parentTxn.stack().buildHandleOutput(parentTxn.consensusNow(), this.exchangeRateManager.exchangeRates());
            this.recordCache.addRecordSource(creatorInfo.nodeId(), parentTxn.txnInfo().transactionID(), HederaRecordCache.DueDiligenceFailure.NO, handleOutput.preferringBlockRecordSource());
            return handleOutput;
        }
        catch (Exception e) {
            log.error("{} - exception thrown while handling system transaction", (Object)"Possibly CATASTROPHIC failure", (Object)e);
            return HandleOutput.failInvalidStreamItems(parentTxn, this.exchangeRateManager.exchangeRates(), this.streamMode, this.recordCache);
        }
    }

    private static Bytes parseFeeSchedules(@NonNull InputStream in) {
        try {
            byte[] bytes = in.readAllBytes();
            CurrentAndNextFeeSchedule feeSchedules = V0490FileSchema.parseFeeSchedules((byte[])bytes);
            return CurrentAndNextFeeSchedule.PROTOBUF.toBytes((Object)feeSchedules);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Bytes parseSimpleFeesSchedules(@NonNull InputStream in) {
        try {
            byte[] bytes = in.readAllBytes();
            FeeSchedule feeSchedules = V0490FileSchema.parseSimpleFeesSchedules((byte[])bytes);
            return FeeSchedule.PROTOBUF.toBytes((Object)feeSchedules);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Bytes parseThrottles(@NonNull InputStream in) {
        try {
            String json = new String(in.readAllBytes());
            return Bytes.wrap((byte[])V0490FileSchema.parseThrottleDefinitions((String)json));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Bytes parseConfig(@NonNull String purpose, @NonNull InputStream in) {
        try {
            String content = new String(in.readAllBytes());
            return V0490FileSchema.parseConfigList((String)purpose, (String)content);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Map<Long, Key> parseNodeAdminKeys(@NonNull InputStream in) {
        try {
            String json = new String(in.readAllBytes());
            return V053AddressBookSchema.parseEd25519NodeAdminKeys((String)json);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @FunctionalInterface
    public static interface StateChangeStreaming {
        public void doStreamingChanges(@NonNull WritableStates var1, @Nullable WritableStates var2, @NonNull Runnable var3);
    }

    private static enum UseReservedConsensusTimes {
        YES,
        NO;

    }

    private static enum TriggerStakePeriodSideEffects {
        YES,
        NO;

    }

    private record AutoEntityUpdate<T>(@NonNull AutoUpdate<T> autoUpdate, @NonNull String updateFileName, @NonNull Function<InputStream, T> updateParser) {
        void tryIfPresent(@NonNull String postUpgradeLoc, @NonNull SystemContext systemContext) {
            Path path = Paths.get(postUpgradeLoc, this.updateFileName);
            if (!Files.exists(path, new LinkOption[0])) {
                log.info("No post-upgrade file for {} found at {}, not updating", (Object)this.updateFileName, (Object)path.toAbsolutePath());
                return;
            }
            try {
                InputStream fin = Files.newInputStream(path, new OpenOption[0]);
                try {
                    T update;
                    try {
                        update = this.updateParser.apply(fin);
                    }
                    catch (Exception e) {
                        log.error("Failed to parse update file at {}", (Object)path.toAbsolutePath(), (Object)e);
                        if (fin != null) {
                            fin.close();
                        }
                        return;
                    }
                    log.info("Dispatching synthetic update based on contents of {}", (Object)path.toAbsolutePath());
                    this.autoUpdate.doUpdate(systemContext, update);
                }
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2;
                            throwable2.addSuppressed(throwable);
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error("Failed to read update file at {}", (Object)path.toAbsolutePath(), (Object)e);
            }
        }
    }

    @FunctionalInterface
    private static interface AutoUpdate<T> {
        public void doUpdate(@NonNull SystemContext var1, @NonNull T var2);
    }
}

