/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.steps;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.records.BlockRecordManager;
import com.hedera.node.app.records.ReadableBlockRecordStore;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.EndOfStakingPeriodUpdater;
import com.hedera.node.app.service.token.records.TokenContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.steps.ParentTxn;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.StakingConfig;
import com.hedera.node.config.types.StreamMode;
import com.swirlds.common.stream.LinkedObjectStreamUtilities;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.WritableRosterStore;

@Singleton
public class StakePeriodChanges {
    private static final Logger logger = LogManager.getLogger(StakePeriodChanges.class);
    private static final long DEFAULT_STAKING_PERIOD_MINS = 1440L;
    private static final long MINUTES_TO_MILLISECONDS = 60000L;
    private final EndOfStakingPeriodUpdater endOfStakingPeriodUpdater;
    private final ExchangeRateManager exchangeRateManager;
    private final BlockRecordManager blockRecordManager;
    private final BlockStreamManager blockStreamManager;
    private final StreamMode streamMode;

    @Inject
    public StakePeriodChanges(@NonNull ConfigProvider configProvider, @NonNull EndOfStakingPeriodUpdater endOfStakingPeriodUpdater, @NonNull ExchangeRateManager exchangeRateManager, @NonNull BlockRecordManager blockRecordManager, @NonNull BlockStreamManager blockStreamManager) {
        this.endOfStakingPeriodUpdater = Objects.requireNonNull(endOfStakingPeriodUpdater);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.blockRecordManager = Objects.requireNonNull(blockRecordManager);
        this.blockStreamManager = Objects.requireNonNull(blockStreamManager);
        this.streamMode = ((BlockStreamConfig)configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamMode();
    }

    public void advanceTimeTo(@NonNull ParentTxn parentTxn, boolean includeStakePeriodSideEffects) {
        if (includeStakePeriodSideEffects) {
            Instant lastTopLevelTime = this.streamMode == StreamMode.RECORDS ? this.blockRecordManager.consTimeOfLastHandledTxn() : this.blockStreamManager.lastTopLevelConsensusTime();
            try {
                this.processSideEffects(parentTxn.stack(), parentTxn.tokenContextImpl(), this.streamMode, lastTopLevelTime);
            }
            catch (Exception e) {
                logger.error("Failed to process stake period changes", (Throwable)e);
            }
        }
        if (this.streamMode != StreamMode.RECORDS) {
            this.blockStreamManager.setLastTopLevelTime(parentTxn.consensusNow());
        }
        if (this.streamMode != StreamMode.BLOCKS) {
            this.blockRecordManager.setLastTopLevelTime(parentTxn.consensusNow(), parentTxn.state());
        }
    }

    private void processSideEffects(@NonNull SavepointStackImpl stack, @NonNull TokenContext tokenContext, @NonNull StreamMode streamMode, @NonNull Instant lastHandleTimeFromBlockStream) {
        Objects.requireNonNull(stack);
        Objects.requireNonNull(tokenContext);
        Objects.requireNonNull(streamMode);
        Objects.requireNonNull(lastHandleTimeFromBlockStream);
        boolean isStakePeriodBoundary = this.isStakingPeriodBoundary(streamMode, tokenContext, lastHandleTimeFromBlockStream);
        if (isStakePeriodBoundary) {
            try {
                this.exchangeRateManager.updateMidnightRates(stack);
                stack.commitFullStack();
            }
            catch (Exception e) {
                logger.error("CATASTROPHIC failure updating midnight rates", (Throwable)e);
                stack.rollbackFullStack();
            }
            try {
                StreamBuilder streamBuilder = this.endOfStakingPeriodUpdater.updateNodes(tokenContext, this.exchangeRateManager.exchangeRates());
                if (streamBuilder != null) {
                    stack.commitTransaction(streamBuilder);
                }
            }
            catch (Exception e) {
                logger.error("CATASTROPHIC failure updating end-of-day stakes", (Throwable)e);
                stack.rollbackFullStack();
            }
            try {
                WritableRosterStore rosterStore = new WritableRosterStore(stack.getWritableStates("RosterService"));
                if (rosterStore.getCandidateRosterHash() == null || rosterStore.candidateIsWeightRotation()) {
                    LongUnaryOperator weightFunction = ((ReadableStakingInfoStore)tokenContext.readableStore(ReadableStakingInfoStore.class)).weightFunction();
                    Roster rosterToReweight = rosterStore.getCandidateRosterHash() == null ? Objects.requireNonNull(rosterStore.getActiveRoster()) : Objects.requireNonNull(rosterStore.getCandidateRoster());
                    Roster reweightedRoster = new Roster(rosterToReweight.rosterEntries().stream().map(rosterEntry -> rosterEntry.copyBuilder().weight(weightFunction.applyAsLong(rosterEntry.nodeId())).build()).toList());
                    if (!StakePeriodChanges.hasZeroWeight(reweightedRoster)) {
                        rosterStore.putCandidateRoster(reweightedRoster);
                        stack.commitFullStack();
                    }
                }
            }
            catch (Exception e) {
                logger.error("{} setting reweighted candidate roster", (Object)"Possibly CATASTROPHIC failure", (Object)e);
                stack.rollbackFullStack();
            }
        }
    }

    private boolean isStakingPeriodBoundary(@NonNull StreamMode streamMode, @NonNull TokenContext tokenContext, @NonNull Instant lastHandleTimeFromBlockStream) {
        Instant consensusTime = tokenContext.consensusTime();
        if (streamMode == StreamMode.RECORDS) {
            ReadableBlockRecordStore blockStore = (ReadableBlockRecordStore)tokenContext.readableStore(ReadableBlockRecordStore.class);
            Timestamp consTimeOfLastHandled = blockStore.getLastBlockInfo().consTimeOfLastHandledTxnOrThrow();
            if (consensusTime.getEpochSecond() > consTimeOfLastHandled.seconds()) {
                return StakePeriodChanges.isNextStakingPeriod(consensusTime, Instant.ofEpochSecond(consTimeOfLastHandled.seconds(), consTimeOfLastHandled.nanos()), tokenContext);
            }
        } else if (StakePeriodChanges.isNextSecond(lastHandleTimeFromBlockStream, consensusTime)) {
            return StakePeriodChanges.isNextStakingPeriod(consensusTime, lastHandleTimeFromBlockStream, tokenContext);
        }
        return false;
    }

    public static boolean isNextSecond(@NonNull Instant lastHandleTime, Instant consensusTime) {
        return consensusTime.getEpochSecond() > lastHandleTime.getEpochSecond();
    }

    @VisibleForTesting
    public static boolean isNextStakingPeriod(@NonNull Instant currentConsensusTime, @NonNull Instant previousConsensusTime, @NonNull TokenContext tokenContext) {
        return StakePeriodChanges.isNextStakingPeriod(currentConsensusTime, previousConsensusTime, ((StakingConfig)tokenContext.configuration().getConfigData(StakingConfig.class)).periodMins());
    }

    public static boolean isNextStakingPeriod(@NonNull Instant currentConsensusTime, @NonNull Instant previousConsensusTime, long stakingPeriod) {
        if (stakingPeriod == 1440L) {
            return StakePeriodChanges.isLaterUtcDay(currentConsensusTime, previousConsensusTime);
        }
        long periodMs = stakingPeriod * 60000L;
        return LinkedObjectStreamUtilities.getPeriod((Instant)currentConsensusTime, (long)periodMs) > LinkedObjectStreamUtilities.getPeriod((Instant)previousConsensusTime, (long)periodMs);
    }

    private static boolean isLaterUtcDay(@NonNull Instant now, @NonNull Instant then) {
        LocalDate nowDay = LocalDate.ofInstant(now, ZoneOffset.UTC);
        LocalDate thenDay = LocalDate.ofInstant(then, ZoneOffset.UTC);
        return nowDay.isAfter(thenDay);
    }

    private static boolean hasZeroWeight(@NonNull Roster roster) {
        return roster.rosterEntries().stream().mapToLong(RosterEntry::weight).sum() == 0L;
    }
}

