/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.config.internal;

import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.ConfigMapping;
import com.swirlds.config.extensions.sources.MappedConfigSource;
import com.swirlds.platform.config.internal.PlatformConfigUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;

public final class ConfigMappings {
    static final List<ConfigMapping> MAPPINGS = List.of(new ConfigMapping("gossip.connectionServerThreadPriority", "thread.threadPrioritySync"), new ConfigMapping("gossip.hangingThreadDuration", "hangingThreadDuration"), new ConfigMapping("consensus.roundsNonAncient", "state.roundsNonAncient"), new ConfigMapping("consensus.roundsExpired", "state.roundsExpired"), new ConfigMapping("consensus.coinFreq", "coinFreq"), new ConfigMapping("state.signedStateFreq", "signedStateFreq"), new ConfigMapping("state.requireStateLoad", "requireStateLoad"), new ConfigMapping("state.emergencyStateFileName", "emergencyStateFileName"), new ConfigMapping("state.checkSignedStateFromDisk", "checkSignedStateFromDisk"), new ConfigMapping("event.maxEventQueueForCons", "maxEventQueueForCons"), new ConfigMapping("event.eventIntakeQueueThrottleSize", "eventIntakeQueueThrottleSize"), new ConfigMapping("event.eventIntakeQueueSize", "eventIntakeQueueSize"), new ConfigMapping("event.randomEventProbability", "randomEventProbability"), new ConfigMapping("event.staleEventPreventionThreshold", "staleEventPreventionThreshold"), new ConfigMapping("event.rescueChildlessInverseProbability", "rescueChildlessInverseProbability"), new ConfigMapping("event.eventStreamQueueCapacity", "eventStreamQueueCapacity"), new ConfigMapping("event.eventsLogPeriod", "eventsLogPeriod"), new ConfigMapping("event.eventsLogDir", "eventsLogDir"), new ConfigMapping("event.enableEventStreaming", "enableEventStreaming"), new ConfigMapping("metrics.halfLife", "halfLife"), new ConfigMapping("metrics.csvWriteFrequency", "csvWriteFrequency"), new ConfigMapping("metrics.csvOutputFolder", "csvOutputFolder"), new ConfigMapping("metrics.csvFileName", "csvFileName"), new ConfigMapping("metrics.csvAppend", "csvAppend"), new ConfigMapping("metrics.disableMetricsOutput", "disableMetricsOutput"), new ConfigMapping("prometheus.endpointEnabled", "prometheusEndpointEnabled"), new ConfigMapping("prometheus.endpointPortNumber", "prometheusEndpointPortNumber"), new ConfigMapping("prometheus.endpointMaxBacklogAllowed", "prometheusEndpointMaxBacklogAllowed"), new ConfigMapping("paths.settingsUsedDir", "settingsUsedDir"), new ConfigMapping("paths.keysDirPath", "keysDirPath"), new ConfigMapping("paths.appsDirPath", "appsDirPath"), new ConfigMapping("paths.logPath", "logPath"), new ConfigMapping("socket.ipTos", "socketIpTos"), new ConfigMapping("socket.bufferSize", "bufferSize"), new ConfigMapping("socket.timeoutSyncClientSocket", "timeoutSyncClientSocket"), new ConfigMapping("socket.timeoutSyncClientConnect", "timeoutSyncClientConnect"), new ConfigMapping("socket.timeoutServerAcceptConnect", "timeoutServerAcceptConnect"), new ConfigMapping("socket.useLoopbackIp", "useLoopbackIp"), new ConfigMapping("socket.tcpNoDelay", "tcpNoDelay"), new ConfigMapping("socket.deadlockCheckPeriod", "deadlockCheckPeriod"), new ConfigMapping("jvmPauseDetectorSleepMs", "jVMPauseDetectorSleepMs"), new ConfigMapping("jvmPauseReportMs", "jVMPauseReportMs"), new ConfigMapping("reconnect.asyncOutputStreamFlush", "reconnect.asyncOutputStreamFlushMilliseconds"), new ConfigMapping("reconnect.maxAckDelay", "reconnect.maxAckDelayMilliseconds"));

    private ConfigMappings() {
    }

    @NonNull
    public static ConfigSource addConfigMapping(@NonNull ConfigSource configSource) {
        PlatformConfigUtils.logAppliedMappedProperties(configSource.getPropertyNames());
        MappedConfigSource withAliases = new MappedConfigSource(configSource);
        MAPPINGS.forEach(arg_0 -> ((MappedConfigSource)withAliases).addMapping(arg_0));
        return withAliases;
    }
}

