/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.Weight;
import io.helidon.common.mapper.spi.MapperProvider;
import io.helidon.service.registry.Service;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Weight(value=0.1)
@Service.Singleton
class DefaultMapperProvider
implements MapperProvider {
    private static final Map<CacheKey, MapperProvider.ProviderResponse> CACHE = new ConcurrentHashMap<CacheKey, MapperProvider.ProviderResponse>();

    DefaultMapperProvider() {
    }

    @Override
    public MapperProvider.ProviderResponse mapper(Class<?> sourceClass, Class<?> targetClass, String qualifier) {
        return CACHE.computeIfAbsent(new CacheKey(sourceClass, targetClass), key -> {
            if (sourceClass.equals(String.class)) {
                return DefaultMapperProvider.fromString(targetClass);
            }
            if (targetClass.equals(String.class)) {
                return DefaultMapperProvider.toString(targetClass);
            }
            return MapperProvider.ProviderResponse.unsupported();
        });
    }

    private static MapperProvider.ProviderResponse fromString(Class<?> target) {
        if (target.equals(Integer.TYPE) || target.equals(Integer.class)) {
            return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, o -> Integer.parseInt((String)o));
        }
        if (target.equals(Long.TYPE) || target.equals(Long.class)) {
            return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, o -> Long.parseLong((String)o));
        }
        return MapperProvider.ProviderResponse.unsupported();
    }

    private static MapperProvider.ProviderResponse toString(Class<?> source) {
        return new MapperProvider.ProviderResponse(MapperProvider.Support.COMPATIBLE, String::valueOf);
    }

    private record CacheKey(Class<?> source, Class<?> target) {
    }
}

