/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.hyperledger.besu.crypto.SECPPrivateKey;
import org.hyperledger.besu.crypto.SECPPublicKey;

public class KeyPair {
    private final SECPPrivateKey privateKey;
    private final SECPPublicKey publicKey;

    public KeyPair(SECPPrivateKey privateKey, SECPPublicKey publicKey) {
        Preconditions.checkNotNull((Object)privateKey);
        Preconditions.checkNotNull((Object)publicKey);
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    public static KeyPair create(SECPPrivateKey privateKey, ECDomainParameters curve, String algorithm) {
        return new KeyPair(privateKey, SECPPublicKey.create(privateKey, curve, algorithm));
    }

    public static KeyPair generate(KeyPairGenerator keyPairGenerator, String algorithm) {
        java.security.KeyPair rawKeyPair = keyPairGenerator.generateKeyPair();
        BCECPrivateKey privateKey = (BCECPrivateKey)rawKeyPair.getPrivate();
        BCECPublicKey publicKey = (BCECPublicKey)rawKeyPair.getPublic();
        BigInteger privateKeyValue = privateKey.getD();
        byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
        BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
        return new KeyPair(SECPPrivateKey.create(privateKeyValue, algorithm), SECPPublicKey.create(publicKeyValue, algorithm));
    }

    public int hashCode() {
        return Objects.hash(this.privateKey, this.publicKey);
    }

    public boolean equals(Object other) {
        if (!(other instanceof KeyPair)) {
            return false;
        }
        KeyPair that = (KeyPair)other;
        return this.privateKey.equals(that.privateKey) && this.publicKey.equals(that.publicKey);
    }

    public String toString() {
        return "KeyPair{privateKey: " + this.privateKey.toString() + ", publicKey: " + this.publicKey.toString() + "]";
    }

    public SECPPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public SECPPublicKey getPublicKey() {
        return this.publicKey;
    }
}

