/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.hashing.WritableMessageDigest;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.utility.Labeled;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.AbstractVirtualRoot;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.VirtualRoot;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.internal.hash.FullLeafRehashHashListener;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.hash.VirtualHasher;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBlockingIterator;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.LearnerPushVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashListener;
import com.swirlds.virtualmap.internal.reconnect.ReconnectNodeRemover;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.TeacherPushVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.TopToBottomTraversalOrder;
import com.swirlds.virtualmap.internal.reconnect.TwoPhasePessimisticTraversalOrder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.ValueReference;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.reconnect.config.ReconnectConfig;

@ConstructableIgnored
public final class VirtualMap
extends AbstractVirtualRoot
implements Labeled,
VirtualRoot {
    private static final int MAX_REHASHING_BUFFER_SIZE = 10000000;
    private static final int MAX_PBJ_RECORD_SIZE = 0x2000000;
    public static final String LABEL = "state";
    private static final String NO_NULL_KEYS_ALLOWED_MESSAGE = "Null keys are not allowed";
    public static final long CLASS_ID = -5151568835156514733L;
    private static final Logger logger = LogManager.getLogger(VirtualMap.class);
    private static final int MAX_RECONNECT_HASHING_BUFFER_SIZE = 10000000;
    @NonNull
    private final VirtualMapConfig virtualMapConfig;
    @Deprecated(forRemoval=true)
    public static final int MAX_LABEL_CHARS = 512;
    @NonNull
    private final Configuration configuration;
    private VirtualDataSourceBuilder dataSourceBuilder;
    private VirtualDataSource dataSource;
    private VirtualNodeCache cache;
    private VirtualMapMetadata metadata;
    private RecordAccessor records;
    private final VirtualHasher hasher;
    private VirtualPipeline pipeline;
    private final AtomicReference<Hash> hash = new AtomicReference();
    private final AtomicBoolean shouldBeFlushed = new AtomicBoolean(false);
    private final AtomicLong flushCandidateThreshold = new AtomicLong();
    private final CountDownLatch flushLatch = new CountDownLatch(1);
    private final AtomicBoolean flushed = new AtomicBoolean(false);
    private final AtomicBoolean merged = new AtomicBoolean(false);
    private ConcurrentBlockingIterator<VirtualLeafBytes> reconnectIterator = null;
    private CompletableFuture<Hash> reconnectHashingFuture;
    private AtomicBoolean reconnectHashingStarted;
    private VirtualMapMetadata reconnectState;
    private RecordAccessor reconnectRecords;
    private VirtualMap originalMap;
    private ReconnectHashLeafFlusher reconnectFlusher;
    private ReconnectNodeRemover nodeRemover;
    private final long fastCopyVersion;
    private VirtualMapStatistics statistics;
    private final AtomicReference<Thread> currentModifyingThreadRef = new AtomicReference<Object>(null);

    public VirtualMap(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.fastCopyVersion = 0L;
        this.hasher = new VirtualHasher();
        this.virtualMapConfig = Objects.requireNonNull((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class));
        this.flushCandidateThreshold.set(this.virtualMapConfig.copyFlushCandidateThreshold());
    }

    public VirtualMap(@NonNull VirtualDataSourceBuilder dataSourceBuilder, @NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.fastCopyVersion = 0L;
        this.hasher = new VirtualHasher();
        this.virtualMapConfig = Objects.requireNonNull((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class));
        this.flushCandidateThreshold.set(this.virtualMapConfig.copyFlushCandidateThreshold());
        this.dataSourceBuilder = Objects.requireNonNull(dataSourceBuilder);
        this.dataSource = dataSourceBuilder.build(LABEL, null, true, false);
        this.metadata = new VirtualMapMetadata();
        this.postInit();
    }

    private VirtualMap(@NonNull VirtualDataSourceBuilder dataSourceBuilder, @NonNull Configuration configuration, @NonNull java.nio.file.Path snapshotPath) {
        Objects.requireNonNull(snapshotPath);
        this.fastCopyVersion = 0L;
        this.configuration = Objects.requireNonNull(configuration);
        this.hasher = new VirtualHasher();
        this.virtualMapConfig = Objects.requireNonNull((VirtualMapConfig)configuration.getConfigData(VirtualMapConfig.class));
        this.flushCandidateThreshold.set(this.virtualMapConfig.copyFlushCandidateThreshold());
        this.dataSourceBuilder = Objects.requireNonNull(dataSourceBuilder);
        this.dataSource = dataSourceBuilder.build(LABEL, snapshotPath, true, false);
        this.metadata = new VirtualMapMetadata(this.dataSource.getFirstLeafPath(), this.dataSource.getLastLeafPath());
        this.postInit();
    }

    private VirtualMap(VirtualMap source) {
        this.configuration = source.configuration;
        this.metadata = source.metadata.copy();
        this.fastCopyVersion = source.fastCopyVersion + 1L;
        this.dataSourceBuilder = source.dataSourceBuilder;
        this.dataSource = source.dataSource;
        this.cache = source.cache.copy();
        this.hasher = source.hasher;
        this.reconnectHashingFuture = null;
        this.reconnectHashingStarted = null;
        this.reconnectIterator = null;
        this.reconnectRecords = null;
        this.pipeline = source.pipeline;
        this.flushCandidateThreshold.set(source.flushCandidateThreshold.get());
        this.statistics = source.statistics;
        this.virtualMapConfig = source.virtualMapConfig;
        if (this.pipeline.isTerminated()) {
            throw new IllegalStateException("A fast-copy was made of a VirtualMap with a terminated pipeline!");
        }
        this.postInit();
    }

    void postInit() {
        Objects.requireNonNull(this.metadata);
        Objects.requireNonNull(this.dataSource);
        if (this.cache == null) {
            this.cache = new VirtualNodeCache(this.virtualMapConfig);
        }
        this.records = new RecordAccessor(this.metadata, this.cache, this.dataSource);
        if (this.statistics == null) {
            this.statistics = new VirtualMapStatistics(LABEL);
        }
        this.statistics.setSize(this.size());
        if (this.pipeline == null) {
            this.pipeline = new VirtualPipeline(this.virtualMapConfig, LABEL);
        }
        this.pipeline.registerCopy(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fullLeafRehashIfNecessary() {
        Objects.requireNonNull(this.records, "Records must be initialized before rehashing");
        long firstLeafPath = this.dataSource.getFirstLeafPath();
        long lastLeafPath = this.dataSource.getLastLeafPath();
        assert (firstLeafPath == this.metadata.getFirstLeafPath());
        assert (lastLeafPath == this.metadata.getLastLeafPath());
        ConcurrentBlockingIterator<VirtualLeafBytes> rehashIterator = new ConcurrentBlockingIterator<VirtualLeafBytes>(10000000);
        if (firstLeafPath < 0L || lastLeafPath < 0L) {
            logger.info(LogMarker.STARTUP.getMarker(), "VirtualMap is empty, skipping full rehash.");
            return;
        }
        try {
            Hash loadedHash = this.dataSource.loadHash(firstLeafPath);
            VirtualLeafBytes virtualLeafBytes = this.dataSource.loadLeafRecord(firstLeafPath);
            if (virtualLeafBytes == null || loadedHash == null) {
                logger.error(LogMarker.STARTUP.getMarker(), "Loaded leaf bytes or hash for the first leaf path {} is null, skipping full rehash", (Object)firstLeafPath);
                return;
            }
            WritableMessageDigest wmd = new WritableMessageDigest(Cryptography.DEFAULT_DIGEST_TYPE.buildDigest());
            virtualLeafBytes.writeToForHashing((WritableSequentialData)wmd);
            Hash recaclulatedHash = new Hash(wmd.digest(), Cryptography.DEFAULT_DIGEST_TYPE);
            if (loadedHash.equals((Object)recaclulatedHash)) {
                logger.info(LogMarker.STARTUP.getMarker(), "Recalculated hash for the first leaf path is equal to loaded hash, skipping full rehash");
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Doing full rehash for the path range: {} - {}", (Object)firstLeafPath, (Object)lastLeafPath);
        FullLeafRehashHashListener hashListener = new FullLeafRehashHashListener(firstLeafPath, lastLeafPath, this.dataSource, this.statistics, this.virtualMapConfig.reconnectFlushInterval());
        CompletionStage fullRehashFuture = CompletableFuture.supplyAsync(() -> this.hasher.hash(this.records::findHash, rehashIterator, firstLeafPath, lastLeafPath, hashListener, this.virtualMapConfig)).exceptionally(exception -> {
            rehashIterator.close();
            String message = "Full rehash failed";
            logger.error(LogMarker.EXCEPTION.getMarker(), "Full rehash failed", exception);
            throw new MerkleSynchronizationException("Full rehash failed", exception);
        });
        long onePercent = (lastLeafPath - firstLeafPath) / 100L + 1L;
        long start = System.currentTimeMillis();
        try {
            for (long i = firstLeafPath; i <= lastLeafPath; ++i) {
                try {
                    VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(i);
                    assert (leafBytes != null) : "Leaf record should not be null";
                    try {
                        rehashIterator.supply(leafBytes);
                    }
                    catch (MerkleSynchronizationException e) {
                        throw e;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new MerkleSynchronizationException("Interrupted while waiting to supply a new leaf to the hashing iterator buffer", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new MerkleSynchronizationException("Failed to handle a leaf during full rehashing", (Throwable)e);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                if (i % onePercent != 0L) continue;
                logger.info(LogMarker.STARTUP.getMarker(), "Full rehash progress: {}%", (Object)((i - firstLeafPath) / onePercent + 1L));
            }
        }
        finally {
            rehashIterator.close();
        }
        try {
            long millisSpent = System.currentTimeMillis() - start;
            logger.info(LogMarker.STARTUP.getMarker(), "It took {} seconds to feed all leaves to the hasher", (Object)(millisSpent / 1000L));
            this.setHashPrivate((Hash)((CompletableFuture)fullRehashFuture).get((long)this.virtualMapConfig.fullRehashTimeoutMs() - millisSpent, TimeUnit.MILLISECONDS));
        }
        catch (ExecutionException e) {
            String message = "Failed to get hash during full rehashing";
            throw new MerkleSynchronizationException("Failed to get hash during full rehashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "Interrupted while full rehashing";
            throw new MerkleSynchronizationException("Interrupted while full rehashing", (Throwable)e);
        }
        catch (TimeoutException e) {
            String message = "Wasn't able to finish full rehashing in time";
            throw new MerkleSynchronizationException("Wasn't able to finish full rehashing in time", (Throwable)e);
        }
    }

    public VirtualNodeCache getCache() {
        return this.cache;
    }

    public RecordAccessor getRecords() {
        return this.records;
    }

    public VirtualPipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isRegisteredToPipeline(VirtualPipeline pipeline) {
        return pipeline == this.pipeline;
    }

    @Override
    protected void destroyNode() {
        if (this.pipeline != null) {
            this.pipeline.destroyCopy(this);
        } else {
            logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Destroying the virtual map, but its pipeline is null. It may happen during failed reconnect");
            this.closeDataSource();
        }
    }

    public boolean containsKey(Bytes key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        long path = this.records.findPath(key);
        this.statistics.countReadEntities();
        return path != -1L;
    }

    public <V> V get(@NonNull Bytes key, Codec<V> valueCodec) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafBytes rec = this.records.findLeafRecord(key);
        this.statistics.countReadEntities();
        return rec == null ? null : (V)rec.value(valueCodec);
    }

    @Nullable
    public Bytes getBytes(@NonNull Bytes key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafBytes rec = this.records.findLeafRecord(key);
        this.statistics.countReadEntities();
        return rec == null ? null : rec.valueBytes();
    }

    public <V> void put(@NonNull Bytes key, @Nullable V value, @Nullable Codec<V> valueCodec) {
        this.put(key, value, valueCodec, null);
    }

    public void putBytes(@NonNull Bytes keyBytes, @Nullable Bytes valueBytes) {
        this.put(keyBytes, null, null, valueBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> void put(Bytes key, V value, Codec<V> valueCodec, Bytes valueBytes) {
        this.throwIfImmutable();
        assert (!this.isHashed()) : "Cannot modify already hashed node";
        assert (this.currentModifyingThreadRef.compareAndSet(null, Thread.currentThread()));
        try {
            Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
            long path = this.records.findPath(key);
            if (path == -1L) {
                this.add(key, value, valueCodec, valueBytes);
                this.statistics.countAddedEntities();
                this.statistics.setSize(this.metadata.getSize());
                return;
            }
            VirtualLeafBytes<V> leaf = valueCodec != null ? new VirtualLeafBytes<V>(path, key, value, valueCodec) : new VirtualLeafBytes(path, key, valueBytes);
            this.cache.putLeaf(leaf);
            this.statistics.countUpdatedEntities();
        }
        finally {
            assert (this.currentModifyingThreadRef.compareAndSet(Thread.currentThread(), null));
        }
    }

    public <V> V remove(@NonNull Bytes key, @NonNull Codec<V> valueCodec) {
        Objects.requireNonNull(valueCodec);
        Bytes removedValueBytes = this.remove(key);
        try {
            return (V)(removedValueBytes == null ? null : valueCodec.parse(removedValueBytes.toReadableSequentialData(), false, false, 512, 0x2000000));
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to deserialize a value from bytes", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bytes remove(@NonNull Bytes key) {
        this.throwIfImmutable();
        Objects.requireNonNull(key);
        assert (this.currentModifyingThreadRef.compareAndSet(null, Thread.currentThread()));
        try {
            long lastLeafParent;
            VirtualLeafBytes leafToDelete = this.records.findLeafRecord(key);
            if (leafToDelete == null) {
                Bytes bytes = null;
                return bytes;
            }
            this.cache.deleteLeaf(leafToDelete);
            this.statistics.countRemovedEntities();
            long lastLeafPath = this.metadata.getLastLeafPath();
            long firstLeafPath = this.metadata.getFirstLeafPath();
            long leafToDeletePath = leafToDelete.path();
            if (leafToDeletePath != lastLeafPath) {
                VirtualLeafBytes lastLeaf = this.records.findLeafRecord(lastLeafPath);
                assert (lastLeaf != null);
                this.cache.clearLeafPath(lastLeafPath);
                this.cache.putLeaf(lastLeaf.withPath(leafToDeletePath));
            }
            if ((lastLeafParent = Path.getParentPath(lastLeafPath)) == 0L) {
                if (firstLeafPath == lastLeafPath) {
                    this.metadata.setFirstLeafPath(-1L);
                    this.metadata.setLastLeafPath(-1L);
                } else {
                    this.metadata.setLastLeafPath(1L);
                    VirtualLeafBytes leaf = this.records.findLeafRecord(1L);
                    this.cache.putLeaf(leaf);
                }
            } else {
                long lastLeafSibling = Path.getSiblingPath(lastLeafPath);
                VirtualLeafBytes sibling = this.records.findLeafRecord(lastLeafSibling);
                assert (sibling != null);
                this.cache.clearLeafPath(lastLeafSibling);
                this.cache.putLeaf(sibling.withPath(lastLeafParent));
                this.metadata.setFirstLeafPath(lastLeafParent);
                this.metadata.setLastLeafPath(lastLeafSibling - 1L);
            }
            if (this.statistics != null) {
                this.statistics.setSize(this.metadata.getSize());
            }
            Bytes bytes = leafToDelete.valueBytes();
            return bytes;
        }
        finally {
            assert (this.currentModifyingThreadRef.compareAndSet(Thread.currentThread(), null));
        }
    }

    @Override
    public void onShutdown(boolean immediately) {
        if (immediately) {
            this.hasher.shutdown();
        }
        this.closeDataSource();
    }

    private void closeDataSource() {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (Exception e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Could not close the dataSource after all copies were destroyed", (Throwable)e);
            }
        }
    }

    @Override
    public void merge() {
        long start = System.currentTimeMillis();
        if (!this.isDestroyed()) {
            throw new IllegalStateException("merge is legal only after this node is destroyed");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("merge is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before it is merged");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("this copy has already been merged");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("a flushed copy can not be merged");
        }
        this.cache.merge();
        this.merged.set(true);
        long end = System.currentTimeMillis();
        this.statistics.recordMerge(end - start);
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Merged in {} ms", (Object)(end - start));
    }

    @Override
    public boolean isMerged() {
        return this.merged.get();
    }

    public void enableFlush() {
        this.shouldBeFlushed.set(true);
    }

    public void setFlushCandidateThreshold(long value) {
        this.flushCandidateThreshold.set(value);
    }

    long getFlushCandidateThreshold() {
        return this.flushCandidateThreshold.get();
    }

    @Override
    public boolean shouldBeFlushed() {
        if (this.shouldBeFlushed.get()) {
            return true;
        }
        long threshold = this.flushCandidateThreshold.get();
        return threshold > 0L && this.estimatedSize() >= threshold;
    }

    @Override
    public boolean isFlushed() {
        return this.flushed.get();
    }

    @Override
    public void waitUntilFlushed() throws InterruptedException {
        if (!this.flushLatch.await(1L, TimeUnit.MINUTES)) {
            this.pipeline.logDebugInfo();
            this.flushLatch.await();
        }
    }

    @Override
    public void flush() {
        if (!this.isImmutable()) {
            throw new IllegalStateException("mutable copies can not be flushed");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("This map has already been flushed");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("a merged copy can not be flushed");
        }
        long start = System.currentTimeMillis();
        this.flush(this.cache, this.metadata, this.dataSource);
        this.cache.release();
        long end = System.currentTimeMillis();
        this.flushed.set(true);
        this.flushLatch.countDown();
        this.statistics.recordFlush(end - start);
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushed {} v{} in {} ms", (Object)LABEL, (Object)this.cache.getFastCopyVersion(), (Object)(end - start));
    }

    private void flush(VirtualNodeCache cacheToFlush, VirtualMapMetadata stateToUse, VirtualDataSource ds) {
        try {
            Stream<VirtualLeafBytes> dirtyLeaves = cacheToFlush.dirtyLeavesForFlush(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath());
            Stream<VirtualLeafBytes> deletedLeaves = cacheToFlush.deletedLeaves();
            Stream<VirtualHashRecord> dirtyHashes = cacheToFlush.dirtyHashesForFlush(stateToUse.getLastLeafPath());
            ds.saveRecords(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath(), dirtyHashes, dirtyLeaves, deletedLeaves, false);
        }
        catch (ClosedByInterruptException ex) {
            logger.info(LogMarker.TESTING_EXCEPTIONS_ACCEPTABLE_RECONNECT.getMarker(), "flush interrupted - this is probably not an error if this happens shortly after a reconnect");
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error while flushing VirtualMap", (Throwable)ex);
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public long estimatedSize() {
        return this.cache.getEstimatedSize();
    }

    public VirtualDataSource getDataSource() {
        return this.dataSource;
    }

    public VirtualMapMetadata getMetadata() {
        return this.metadata;
    }

    @Deprecated(forRemoval=true)
    public long getClassId() {
        return -5151568835156514733L;
    }

    public int getVersion() {
        return 4;
    }

    public String getLabel() {
        return LABEL;
    }

    public boolean isSelfHashing() {
        return true;
    }

    @Override
    @NonNull
    public Hash getHash() {
        if (this.hash.get() == null) {
            this.pipeline.hashCopy(this);
        }
        return this.hash.get();
    }

    private void setHashPrivate(@Nullable Hash value) {
        this.hash.set(value);
    }

    @Override
    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("data type is self hashing");
    }

    public void invalidateHash() {
        throw new UnsupportedOperationException("this node is self hashing");
    }

    @Override
    public boolean isHashed() {
        return this.hash.get() != null;
    }

    @Override
    public void computeHash() {
        if (this.hash.get() != null) {
            return;
        }
        long start = System.currentTimeMillis();
        this.cache.prepareForHashing();
        VirtualHashListener hashListener = new VirtualHashListener(){

            @Override
            public void onNodeHashed(long path, Hash hash) {
                VirtualMap.this.cache.putHash(path, hash);
            }
        };
        Hash virtualHash = this.hasher.hash(this.records::findHash, this.cache.dirtyLeavesForHash(this.metadata.getFirstLeafPath(), this.metadata.getLastLeafPath()).iterator(), this.metadata.getFirstLeafPath(), this.metadata.getLastLeafPath(), hashListener, this.virtualMapConfig);
        if (virtualHash == null) {
            Hash rootHash = this.metadata.getSize() == 0L ? null : this.records.findHash(0L);
            virtualHash = rootHash != null ? rootHash : this.hasher.emptyRootHash();
        }
        this.cache.seal();
        this.setHashPrivate(virtualHash);
        long end = System.currentTimeMillis();
        this.statistics.recordHash(end - start);
    }

    @Override
    public RecordAccessor detach() {
        java.nio.file.Path snapshotPath = this.dataSourceSnapshot();
        VirtualDataSource dataSourceCopy = this.dataSourceBuilder.build(this.getLabel(), snapshotPath, false, false);
        VirtualNodeCache cacheSnapshot = this.cache.snapshot();
        return new RecordAccessor(this.metadata.copy(), cacheSnapshot, dataSourceCopy);
    }

    private java.nio.file.Path dataSourceSnapshot() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Can't make data source copy: virtual map copy is already destroyed");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("Can't make data source copy: virtual map copy is mutable");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("Can't make data source copy: virtual map copy isn't hashed");
        }
        return this.dataSourceBuilder.snapshot(null, this.dataSource);
    }

    public TeacherTreeView buildTeacherView(@NonNull ReconnectConfig reconnectConfig) {
        return switch (this.virtualMapConfig.reconnectMode()) {
            case "push" -> new TeacherPushVirtualTreeView(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.metadata, this.pipeline);
            case "pullTopToBottom" -> new TeacherPullVirtualTreeView(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.metadata, this.pipeline);
            case "pullTwoPhasePessimistic" -> new TeacherPullVirtualTreeView(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.metadata, this.pipeline);
            default -> throw new UnsupportedOperationException("Unknown reconnect mode: " + this.virtualMapConfig.reconnectMode());
        };
    }

    private void setupWithOriginalNode(@NonNull VirtualMap originalMap) {
        this.originalMap = originalMap;
        this.dataSourceBuilder = originalMap.dataSourceBuilder;
        originalMap.dataSource.stopAndDisableBackgroundCompaction();
        this.reconnectState = new VirtualMapMetadata();
        this.reconnectRecords = (RecordAccessor)originalMap.pipeline.pausePipelineAndRun("copy", () -> {
            originalMap.dataSource.stopAndDisableBackgroundCompaction();
            java.nio.file.Path snapshotPath = this.dataSourceBuilder.snapshot(null, originalMap.dataSource);
            this.dataSource = this.dataSourceBuilder.build(originalMap.getLabel(), snapshotPath, true, false);
            assert (originalMap.isHashed()) : "The system should have made sure this was hashed by this point!";
            VirtualNodeCache snapshotCache = originalMap.cache.snapshot();
            this.flush(snapshotCache, originalMap.metadata, this.dataSource);
            return new RecordAccessor(this.reconnectState, snapshotCache, this.dataSource);
        });
        this.reconnectIterator = new ConcurrentBlockingIterator(10000000);
        this.reconnectHashingFuture = new CompletableFuture();
        this.reconnectHashingStarted = new AtomicBoolean(false);
        this.dataSource.copyStatisticsFrom(originalMap.dataSource);
        this.statistics = originalMap.statistics;
    }

    public VirtualMap newReconnectRoot() {
        VirtualMap newRoot = new VirtualMap(this.configuration);
        this.getHash();
        newRoot.setupWithOriginalNode(this);
        return newRoot;
    }

    public LearnerTreeView buildLearnerView(@NonNull ReconnectConfig reconnectConfig, @NonNull ReconnectMapStats mapStats) {
        assert (this.originalMap != null);
        VirtualMapMetadata originalState = this.originalMap.getMetadata();
        this.reconnectFlusher = new ReconnectHashLeafFlusher(this.dataSource, this.virtualMapConfig.reconnectFlushInterval(), this.statistics);
        this.nodeRemover = new ReconnectNodeRemover(this.originalMap.getRecords(), originalState.getFirstLeafPath(), originalState.getLastLeafPath(), this.reconnectFlusher);
        return switch (this.virtualMapConfig.reconnectMode()) {
            case "push" -> new LearnerPushVirtualTreeView(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, mapStats);
            case "pullTopToBottom" -> {
                TopToBottomTraversalOrder topToBottom = new TopToBottomTraversalOrder();
                yield new LearnerPullVirtualTreeView(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, topToBottom, mapStats);
            }
            case "pullTwoPhasePessimistic" -> {
                TwoPhasePessimisticTraversalOrder twoPhasePessimistic = new TwoPhasePessimisticTraversalOrder();
                yield new LearnerPullVirtualTreeView(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, twoPhasePessimistic, mapStats);
            }
            default -> throw new UnsupportedOperationException("Unknown reconnect mode: " + this.virtualMapConfig.reconnectMode());
        };
    }

    public void registerMetrics(@NonNull Metrics metrics) {
        this.statistics.registerMetrics(metrics);
        this.pipeline.registerMetrics(metrics);
        this.dataSource.registerMetrics(metrics);
    }

    public void handleReconnectLeaf(@NonNull VirtualLeafBytes<?> leafRecord) {
        try {
            this.reconnectIterator.supply(leafRecord);
        }
        catch (MerkleSynchronizationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MerkleSynchronizationException("Interrupted while waiting to supply a new leaf to the hashing iterator buffer", (Throwable)e);
        }
        catch (Exception e) {
            throw new MerkleSynchronizationException("Failed to handle a leaf during reconnect on the learner", (Throwable)e);
        }
    }

    public void prepareReconnectHashing(long firstLeafPath, long lastLeafPath) {
        assert (this.reconnectFlusher != null) : "Cannot prepare reconnect hashing, since reconnect is not started";
        ReconnectHashListener hashListener = new ReconnectHashListener(this.reconnectFlusher);
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("virtualmap")).setThreadName("hasher")).setRunnable(() -> this.reconnectHashingFuture.complete(this.hasher.hash(this.reconnectRecords::findHash, this.reconnectIterator, firstLeafPath, lastLeafPath, hashListener, this.virtualMapConfig))).setExceptionHandler((thread, exception) -> {
            this.reconnectIterator.close();
            String message = "VirtualMap failed to hash during reconnect";
            logger.error(LogMarker.EXCEPTION.getMarker(), "VirtualMap failed to hash during reconnect", exception);
            this.reconnectHashingFuture.completeExceptionally(new MerkleSynchronizationException("VirtualMap failed to hash during reconnect", exception));
        })).build().start();
        this.reconnectHashingStarted.set(true);
    }

    public void endLearnerReconnect() {
        try {
            logger.info(LogMarker.RECONNECT.getMarker(), "call reconnectIterator.close()");
            this.reconnectIterator.close();
            if (this.reconnectHashingStarted.get()) {
                logger.info(LogMarker.RECONNECT.getMarker(), "call setHashPrivate()");
                this.setHashPrivate(this.reconnectHashingFuture.get());
            } else {
                logger.warn(LogMarker.RECONNECT.getMarker(), "virtual map hashing thread was never started");
            }
            logger.info(LogMarker.RECONNECT.getMarker(), "call postInit()");
            this.nodeRemover = null;
            this.originalMap = null;
            this.metadata = new VirtualMapMetadata(this.reconnectState.getSize());
            this.postInit();
        }
        catch (ExecutionException e) {
            throw new MerkleSynchronizationException((Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MerkleSynchronizationException((Exception)e);
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "endLearnerReconnect() complete");
    }

    public void warm(@NonNull Bytes key) {
        this.records.findLeafRecord(key);
    }

    private <V> void add(@NonNull Bytes key, @Nullable V value, @Nullable Codec<V> valueCodec, @Nullable Bytes valueBytes) {
        long leafPath;
        this.throwIfImmutable();
        assert (!this.isHashed()) : "Cannot modify already hashed node";
        long lastLeafPath = this.metadata.getLastLeafPath();
        if (lastLeafPath == -1L) {
            leafPath = Path.getLeftChildPath(0L);
            this.metadata.setLastLeafPath(leafPath);
            this.metadata.setFirstLeafPath(leafPath);
        } else if (Path.isLeft(lastLeafPath)) {
            leafPath = Path.getRightChildPath(0L);
            this.metadata.setLastLeafPath(leafPath);
        } else {
            long firstLeafPath = this.metadata.getFirstLeafPath();
            long nextFirstLeafPath = firstLeafPath + 1L;
            VirtualLeafBytes oldLeaf = this.records.findLeafRecord(firstLeafPath);
            Objects.requireNonNull(oldLeaf);
            this.cache.clearLeafPath(firstLeafPath);
            this.cache.putLeaf(oldLeaf.withPath(Path.getLeftChildPath(firstLeafPath)));
            leafPath = Path.getRightChildPath(firstLeafPath);
            this.metadata.setLastLeafPath(leafPath);
            this.metadata.setFirstLeafPath(nextFirstLeafPath);
        }
        this.statistics.setSize(this.metadata.getSize());
        VirtualLeafBytes<V> newLeaf = valueCodec != null ? new VirtualLeafBytes<V>(leafPath, key, value, valueCodec) : new VirtualLeafBytes(leafPath, key, valueBytes);
        this.cache.putLeaf(newLeaf);
    }

    @Override
    public long getFastCopyVersion() {
        return this.fastCopyVersion;
    }

    public VirtualMap copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        VirtualMap copy = new VirtualMap(this);
        this.setImmutable(true);
        if (this.isHashed()) {
            this.cache.seal();
        }
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSnapshot(@NonNull java.nio.file.Path outputDirectory) throws IOException {
        ValueReference cacheSnapshot = new ValueReference();
        java.nio.file.Path snapshotPath = (java.nio.file.Path)this.pipeline.pausePipelineAndRun("detach", () -> {
            cacheSnapshot.setValue((Object)this.cache.snapshot());
            return this.dataSourceSnapshot();
        });
        VirtualDataSource dataSourceCopy = null;
        try {
            dataSourceCopy = this.dataSourceBuilder.build(LABEL, snapshotPath, false, true);
            this.flush((VirtualNodeCache)cacheSnapshot.getValue(), this.metadata, dataSourceCopy);
            this.dataSourceBuilder.snapshot(outputDirectory, dataSourceCopy);
        }
        finally {
            FileUtils.deleteDirectory((java.nio.file.Path)snapshotPath);
            if (dataSourceCopy != null) {
                dataSourceCopy.close();
            }
        }
    }

    public static VirtualMap loadFromDirectory(@NonNull java.nio.file.Path snapshotPath, @NonNull Configuration configuration, @NonNull Supplier<VirtualDataSourceBuilder> dataSourceBuilderSupplier) {
        VirtualMap virtualMap = new VirtualMap(dataSourceBuilderSupplier.get(), configuration, snapshotPath);
        virtualMap.fullLeafRehashIfNecessary();
        return virtualMap;
    }

    public long size() {
        return this.metadata.getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0L;
    }

    public static class ClassVersion {
        public static final int NO_VIRTUAL_ROOT_NODE = 4;
    }
}

