/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Arrays;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.hyperledger.besu.nativelib.secp256k1.LibSecp256k1;

public class MiscCryptoUtils {
    private static final int EVM_ADDRESS_SIZE = 20;
    private static final int ECDSA_UNCOMPRESSED_KEY_SIZE = 64;
    private static final int ECDSA_UNCOMPRESSED_KEY_SIZE_WITH_HEADER_BYTE = 65;
    private static final ThreadLocal<ThreadLocalCache> CACHE = ThreadLocal.withInitial(ThreadLocalCache::new);

    private MiscCryptoUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static byte[] keccak256DigestOf(byte[] msg) {
        return new Keccak.Digest256().digest(msg);
    }

    public static Bytes keccak256DigestOf(Bytes msg) {
        Keccak.Digest256 digest = new Keccak.Digest256();
        msg.writeTo((MessageDigest)digest);
        return Bytes.wrap((byte[])digest.digest());
    }

    public static byte[] decompressSecp256k1(byte[] compressedKey) {
        ThreadLocalCache cache = CACHE.get();
        LibSecp256k1.secp256k1_pubkey publicKey = cache.pubKey;
        int keyParseResult = LibSecp256k1.secp256k1_ec_pubkey_parse((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)publicKey, (byte[])compressedKey, (long)compressedKey.length);
        if (keyParseResult != 1) {
            throw new IllegalArgumentException("Failed to parse public key");
        }
        ByteBuffer outputBuffer = cache.uncompressedPublicKeyByteBuffer;
        LongByReference outputLength = cache.length;
        outputLength.setValue(65L);
        int keySerializeResult = LibSecp256k1.secp256k1_ec_pubkey_serialize((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)outputBuffer, (LongByReference)outputLength, (LibSecp256k1.secp256k1_pubkey)publicKey, (int)2);
        if (keySerializeResult != 1) {
            throw new IllegalArgumentException("Failed to serialize public key");
        }
        byte[] rawKey = new byte[64];
        outputBuffer.get(1, rawKey);
        return rawKey;
    }

    public static byte[] compressSecp256k1(byte[] decompressedKey) {
        ThreadLocalCache cache = CACHE.get();
        byte[] decompressedBytes = cache.uncompressedPublicKeyInput;
        System.arraycopy(decompressedKey, 0, decompressedBytes, 1, 64);
        LibSecp256k1.secp256k1_pubkey publicKey = cache.pubKey;
        int keyParseResult = LibSecp256k1.secp256k1_ec_pubkey_parse((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)publicKey, (byte[])decompressedBytes, (long)decompressedBytes.length);
        if (keyParseResult != 1) {
            throw new IllegalArgumentException("Failed to parse public key");
        }
        ByteBuffer outputBuffer = ByteBuffer.allocate(33);
        LongByReference outputLength = cache.length;
        outputLength.setValue(33L);
        int keySerializeResult = LibSecp256k1.secp256k1_ec_pubkey_serialize((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)outputBuffer, (LongByReference)outputLength, (LibSecp256k1.secp256k1_pubkey)publicKey, (int)258);
        if (keySerializeResult != 1) {
            throw new IllegalArgumentException("Failed to serialize public key");
        }
        return outputBuffer.array();
    }

    public static byte[] extractEvmAddressFromDecompressedECDSAKey(byte[] decompressedKey) {
        byte[] publicKeyHash = MiscCryptoUtils.keccak256DigestOf(decompressedKey);
        return Arrays.copyOfRange(publicKeyHash, publicKeyHash.length - 20, publicKeyHash.length);
    }

    private record ThreadLocalCache(LibSecp256k1.secp256k1_pubkey pubKey, byte[] uncompressedPublicKeyInput, ByteBuffer uncompressedPublicKeyByteBuffer, LongByReference length) {
        public ThreadLocalCache() {
            this(new LibSecp256k1.secp256k1_pubkey(), new byte[65], ByteBuffer.allocate(65), new LongByReference());
            this.uncompressedPublicKeyInput[0] = 4;
        }
    }
}

