/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.throttles.BucketThrottle;
import com.hedera.node.app.hapi.utils.throttles.CongestibleThrottle;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;

public class DeterministicThrottle
implements CongestibleThrottle {
    private static final long NANOS_PER_SECOND = 1000000000L;
    @Nullable
    private final String name;
    @Nullable
    private Instant lastDecisionTime;
    private final BucketThrottle delegate;

    public static DeterministicThrottle withTps(int tps) {
        return new DeterministicThrottle(BucketThrottle.withTps(tps), null);
    }

    public static DeterministicThrottle withTpsNamed(int tps, String name) {
        return new DeterministicThrottle(BucketThrottle.withTps(tps), name);
    }

    public static DeterministicThrottle withMtps(long mtps) {
        return new DeterministicThrottle(BucketThrottle.withMtps(mtps), null);
    }

    public static DeterministicThrottle withMtpsNamed(long mtps, String name) {
        return new DeterministicThrottle(BucketThrottle.withMtps(mtps), name);
    }

    public static DeterministicThrottle withTpsAndBurstPeriod(int tps, int burstPeriod) {
        return new DeterministicThrottle(BucketThrottle.withTpsAndBurstPeriod(tps, burstPeriod), null);
    }

    public static DeterministicThrottle withTpsAndBurstPeriodNamed(int tps, int burstPeriod, String name) {
        return new DeterministicThrottle(BucketThrottle.withTpsAndBurstPeriod(tps, burstPeriod), name);
    }

    public static DeterministicThrottle withMtpsAndBurstPeriod(long mtps, int burstPeriod) {
        return new DeterministicThrottle(BucketThrottle.withMtpsAndBurstPeriod(mtps, burstPeriod), null);
    }

    public static DeterministicThrottle withMtpsAndBurstPeriodNamed(long mtps, int burstPeriod, String name) {
        return new DeterministicThrottle(BucketThrottle.withMtpsAndBurstPeriod(mtps, burstPeriod), name);
    }

    public static DeterministicThrottle withTpsAndBurstPeriodMs(int tps, long burstPeriodMs) {
        return new DeterministicThrottle(BucketThrottle.withTpsAndBurstPeriodMs(tps, burstPeriodMs), null);
    }

    public static DeterministicThrottle withTpsAndBurstPeriodMsNamed(int tps, long burstPeriodMs, String name) {
        return new DeterministicThrottle(BucketThrottle.withTpsAndBurstPeriodMs(tps, burstPeriodMs), name);
    }

    public static DeterministicThrottle withMtpsAndBurstPeriodMs(long mtps, long burstPeriodMs) {
        return new DeterministicThrottle(BucketThrottle.withMtpsAndBurstPeriodMs(mtps, burstPeriodMs), null);
    }

    public static DeterministicThrottle withMtpsAndBurstPeriodMsNamed(long mtps, long burstPeriodMs, String name) {
        return new DeterministicThrottle(BucketThrottle.withMtpsAndBurstPeriodMs(mtps, burstPeriodMs), name);
    }

    private DeterministicThrottle(BucketThrottle delegate, @Nullable String name) {
        this.name = name;
        this.delegate = delegate;
        this.lastDecisionTime = null;
    }

    public static long capacityRequiredFor(int nTransactions) {
        if (CommonUtils.productWouldOverflow(nTransactions, BucketThrottle.capacityUnitsPerTxn())) {
            return -1L;
        }
        return (long)nTransactions * BucketThrottle.capacityUnitsPerTxn();
    }

    public long clampedCapacityRequiredFor(int nTransactions) {
        long nominal = DeterministicThrottle.capacityRequiredFor(nTransactions);
        long limit = this.delegate.bucket().brimfulCapacity();
        return nominal >= 0L ? Math.min(nominal, limit) : limit;
    }

    public boolean allowInstantaneous(int numReqs) {
        return this.delegate.allowInstantaneous(numReqs);
    }

    public void leakInstantaneous(int numReqs) {
        this.delegate.leakInstantaneous(numReqs);
    }

    public boolean allow(int numReqs, @NonNull Instant now) {
        Objects.requireNonNull(now);
        long elapsedNanos = DeterministicThrottle.nanosBetween(this.lastDecisionTime, now);
        if (elapsedNanos < 0L) {
            throw new IllegalArgumentException("Throttle timeline must advance, but " + String.valueOf(now) + " is not after " + String.valueOf(this.lastDecisionTime));
        }
        this.lastDecisionTime = now;
        return this.delegate.allow(numReqs, elapsedNanos);
    }

    public void leakCapacity(long amount) {
        this.delegate.leakCapacity(amount);
    }

    public void reclaimLastAllowedUse() {
        this.delegate.reclaimLastAllowedUse();
    }

    public void resetLastAllowedUse() {
        this.delegate.resetLastAllowedUse();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public long mtps() {
        return this.delegate.mtps();
    }

    @Override
    public long used() {
        return this.delegate.bucket().capacityUsed();
    }

    @Override
    public long capacity() {
        return this.delegate.bucket().brimfulCapacity();
    }

    public long capacityFree() {
        return this.delegate.bucket().brimfulCapacityFree();
    }

    public ThrottleUsageSnapshot usageSnapshot() {
        return new ThrottleUsageSnapshot(this.delegate.bucket().capacityUsed(), this.lastDecisionTime == null ? null : new Timestamp(this.lastDecisionTime.getEpochSecond(), this.lastDecisionTime.getNano()));
    }

    public double percentUsed(Instant now) {
        if (this.lastDecisionTime == null) {
            return 0.0;
        }
        long elapsedNanos = Math.max(0L, DeterministicThrottle.nanosBetween(this.lastDecisionTime, now));
        return this.delegate.percentUsed(elapsedNanos);
    }

    @Override
    public double instantaneousPercentUsed() {
        if (this.lastDecisionTime == null) {
            return 0.0;
        }
        return this.delegate.instantaneousPercentUsed();
    }

    public int instantaneousBps() {
        if (this.lastDecisionTime == null) {
            return 0;
        }
        return this.delegate.instantaneousBps();
    }

    public void resetUsageTo(@NonNull ThrottleUsageSnapshot usageSnapshot) {
        Objects.requireNonNull(usageSnapshot);
        this.lastDecisionTime = usageSnapshot.lastDecisionTime() == null ? null : Instant.ofEpochSecond(usageSnapshot.lastDecisionTime().seconds(), usageSnapshot.lastDecisionTime().nanos());
        this.delegate.bucket().resetUsed(usageSnapshot.used());
    }

    public void resetUsage() {
        this.resetLastAllowedUse();
        this.delegate.bucket().resetUsed(0L);
        this.lastDecisionTime = null;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeterministicThrottle that = (DeterministicThrottle)obj;
        return this.delegate.bucket().brimfulCapacity() == that.delegate.bucket().brimfulCapacity() && this.delegate.mtps() == that.delegate.mtps();
    }

    public int hashCode() {
        return Objects.hash(this.delegate.bucket().brimfulCapacity(), this.delegate.mtps(), this.name, this.lastDecisionTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeterministicThrottle{");
        if (this.name != null) {
            sb.append("name='").append(this.name).append("', ");
        }
        return sb.append("mtps=").append(this.delegate.mtps()).append(", ").append("capacity=").append(this.capacity()).append(" (used=").append(this.used()).append(")").append((String)(this.lastDecisionTime == null ? "" : ", last decision @ " + String.valueOf(this.lastDecisionTime))).append("}").toString();
    }

    public BucketThrottle delegate() {
        return this.delegate;
    }

    public Instant lastDecisionTime() {
        return this.lastDecisionTime;
    }

    static long nanosBetween(@Nullable Instant start, @NonNull Instant end) {
        Objects.requireNonNull(end);
        if (start == null) {
            return 0L;
        }
        long elapsedSeconds = Math.subtractExact(end.getEpochSecond(), start.getEpochSecond());
        long elapsedNanos = Math.multiplyExact(elapsedSeconds, 1000000000L);
        return Math.addExact(elapsedNanos, (long)(end.getNano() - start.getNano()));
    }

    public void leakUntil(Instant now) {
        Objects.requireNonNull(now);
        long elapsedNanos = DeterministicThrottle.nanosBetween(this.lastDecisionTime, now);
        if (elapsedNanos < 0L) {
            throw new IllegalArgumentException("Throttle timeline must advance, but " + String.valueOf(now) + " is not after " + String.valueOf(this.lastDecisionTime));
        }
        this.lastDecisionTime = now;
        this.delegate.leakFor(elapsedNanos);
    }
}

