/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.eventhandling;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.metrics.statistics.AverageTimeStat;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.state.signed.ReservedSignedState;

public class DefaultTransactionPrehandler
implements TransactionPrehandler {
    private static final Logger logger = LogManager.getLogger(DefaultTransactionPrehandler.class);
    public static final Consumer<ScopedSystemTransaction<StateSignatureTransaction>> NO_OP_CONSUMER = systemTransactions -> {};
    private final Supplier<ReservedSignedState> latestStateSupplier;
    private final AverageTimeStat preHandleTime;
    private final ConsensusStateEventHandler consensusStateEventHandler;
    private final Time time;

    public DefaultTransactionPrehandler(@NonNull PlatformContext platformContext, @NonNull Supplier<ReservedSignedState> latestStateSupplier, @NonNull ConsensusStateEventHandler consensusStateEventHandler) {
        this.time = platformContext.getTime();
        this.latestStateSupplier = Objects.requireNonNull(latestStateSupplier);
        this.preHandleTime = new AverageTimeStat(platformContext.getMetrics(), ChronoUnit.MICROS, "internal", "preHandleMicros", "average time it takes to perform preHandle (in microseconds)");
        this.consensusStateEventHandler = consensusStateEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Queue<ScopedSystemTransaction<StateSignatureTransaction>> prehandleApplicationTransactions(@NonNull PlatformEvent event) {
        long startTime = this.time.nanoTime();
        ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>> scopedSystemTransactions = new ConcurrentLinkedQueue<ScopedSystemTransaction<StateSignatureTransaction>>();
        Consumer<ScopedSystemTransaction<StateSignatureTransaction>> consumer = scopedSystemTransactions::add;
        ReservedSignedState latestImmutableState = null;
        try {
            latestImmutableState = this.latestStateSupplier.get();
            while (latestImmutableState == null) {
                latestImmutableState = this.latestStateSupplier.get();
            }
            try {
                this.consensusStateEventHandler.onPreHandle((Event)event, (State)latestImmutableState.get().getState(), consumer);
            }
            catch (Throwable t) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "error invoking ConsensusStateEventHandler.onPreHandle() for event {}", (Object)event, (Object)t);
            }
        }
        finally {
            event.signalPrehandleCompletion();
            latestImmutableState.close();
            this.preHandleTime.update(startTime, this.time.nanoTime());
        }
        return scopedSystemTransactions;
    }
}

