/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.file.FileAppendTransactionBody;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.file.FileSignatureWaivers;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.impl.WritableFileStore;
import com.hedera.node.app.service.file.impl.WritableUpgradeFileStore;
import com.hedera.node.app.service.file.impl.utils.FileServiceUtils;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;

@Singleton
public class FileAppendHandler
implements TransactionHandler {
    private final FileSignatureWaivers fileSignatureWaivers;

    @Inject
    public FileAppendHandler(FileSignatureWaivers fileSignatureWaivers) {
        this.fileSignatureWaivers = fileSignatureWaivers;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        FileAppendTransactionBody transactionBody = body.fileAppendOrThrow();
        if (transactionBody.fileID() == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody body = context.body();
        FileAppendTransactionBody op = body.fileAppendOrThrow();
        ReadableFileStore fileStore = (ReadableFileStore)context.createStore(ReadableFileStore.class);
        FileID transactionFileId = Objects.requireNonNull(op.fileID());
        FileServiceUtils.preValidate(transactionFileId, fileStore, context);
        boolean areSignaturesWaived = this.fileSignatureWaivers.areFileAppendSignaturesWaived(body, context.payer());
        if (areSignaturesWaived) {
            return;
        }
        File file = fileStore.getFileLeaf(transactionFileId);
        FileServiceUtils.validateAndAddRequiredKeys(file, null, context);
    }

    public void handle(@NonNull HandleContext handleContext) throws HandleException {
        Objects.requireNonNull(handleContext);
        FileAppendTransactionBody fileAppend = handleContext.body().fileAppendOrThrow();
        FileID target = fileAppend.fileID();
        Bytes data = fileAppend.contents();
        FilesConfig fileServiceConfig = (FilesConfig)handleContext.configuration().getConfigData(FilesConfig.class);
        if (target == null) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        if (target.fileNum() >= fileServiceConfig.softwareUpdateRange().left() && target.fileNum() <= fileServiceConfig.softwareUpdateRange().right()) {
            this.handleAppendUpgradeFile(fileAppend, handleContext);
            return;
        }
        WritableFileStore fileStore = (WritableFileStore)handleContext.storeFactory().writableStore(WritableFileStore.class);
        Optional<File> optionalFile = fileStore.get(target);
        if (optionalFile.isEmpty()) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        File file = optionalFile.get();
        HandleException.validateTrue((file.hasKeys() && !file.keys().keys().isEmpty() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.UNAUTHORIZED);
        if (file.deleted()) {
            throw new HandleException(ResponseCodeEnum.FILE_DELETED);
        }
        byte[] contents = CommonPbjConverters.asBytes((Bytes)file.contents());
        byte[] newContents = ArrayUtils.addAll((byte[])contents, (byte[])CommonPbjConverters.asBytes((Bytes)data));
        FileServiceUtils.validateContent(newContents, fileServiceConfig);
        File.Builder fileBuilder = new File.Builder().fileId(file.fileId()).expirationSecond(file.expirationSecond()).keys(file.keys()).contents(Bytes.wrap((byte[])newContents)).memo(file.memo()).deleted(file.deleted());
        fileStore.put(fileBuilder.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        long effectiveLifeTime;
        TransactionBody body = feeContext.body();
        FileAppendTransactionBody op = body.fileAppendOrThrow();
        FileID fileID = op.fileIDOrThrow();
        ReadableFileStore fileStore = (ReadableFileStore)feeContext.readableStore(ReadableFileStore.class);
        Configuration config = feeContext.configuration();
        FilesConfig fileServiceConfig = (FilesConfig)config.getConfigData(FilesConfig.class);
        long dataLength = op.contents().length();
        File file = fileStore.getFileLeaf(fileID);
        if (file == null) {
            return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction(24L).calculate();
        }
        long fileNum = fileID.fileNum();
        Long firstSoftwareUpdateFile = fileServiceConfig.softwareUpdateRange().left();
        Long lastSoftwareUpdateFile = fileServiceConfig.softwareUpdateRange().right();
        if (firstSoftwareUpdateFile <= fileNum && fileNum <= lastSoftwareUpdateFile) {
            effectiveLifeTime = 7776000L;
        } else {
            long effCreationTime = body.transactionIDOrThrow().transactionValidStartOrThrow().seconds();
            long effExpiration = file != null && file.expirationSecond() > 0L ? file.expirationSecond() : effCreationTime;
            effectiveLifeTime = effExpiration - effCreationTime;
        }
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction(24L + dataLength).addStorageBytesSeconds(dataLength * effectiveLifeTime).calculate();
    }

    private void handleAppendUpgradeFile(FileAppendTransactionBody fileAppend, HandleContext handleContext) {
        WritableUpgradeFileStore fileStore = (WritableUpgradeFileStore)handleContext.storeFactory().writableStore(WritableUpgradeFileStore.class);
        File file = fileStore.peek(fileAppend.fileID());
        if (file == null || fileAppend.fileID() == null) {
            throw new HandleException(ResponseCodeEnum.INVALID_FILE_ID);
        }
        fileStore.append(fileAppend.contents(), fileAppend.fileID());
    }
}

