/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.concurrency.limits.AimdLimit;
import io.helidon.common.concurrency.limits.AimdLimitConfigBlueprint;
import io.helidon.config.Config;
import io.helidon.config.ConfigBuilderSupport;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.concurrency.limits.AimdLimitConfigBlueprint")
public interface AimdLimitConfig
extends AimdLimitConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AimdLimitConfig instance) {
        return (Builder)AimdLimitConfig.builder().from(instance);
    }

    public static AimdLimitConfig create(Config config) {
        return ((Builder)AimdLimitConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static AimdLimitConfig create(io.helidon.common.config.Config config) {
        return AimdLimitConfig.create(Config.config((io.helidon.common.config.Config)config));
    }

    public static AimdLimitConfig create() {
        return AimdLimitConfig.builder().buildPrototype();
    }

    @Override
    public double backoffRatio();

    @Override
    public int initialLimit();

    @Override
    public int maxLimit();

    @Override
    public int minLimit();

    @Override
    public Duration timeout();

    @Override
    public Optional<Supplier<Long>> clock();

    @Override
    public String name();

    @Override
    public int queueLength();

    @Override
    public Duration queueTimeout();

    @Override
    public boolean fair();

    @Override
    public boolean enableMetrics();

    public static class Builder
    extends BuilderBase<Builder, AimdLimitConfig>
    implements io.helidon.common.Builder<Builder, AimdLimit> {
        private Builder() {
        }

        public AimdLimitConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AimdLimitConfigImpl(this);
        }

        public AimdLimit build() {
            return AimdLimit.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends AimdLimitConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean enableMetrics = false;
        private boolean fair = false;
        private Config config;
        private double backoffRatio = 0.9;
        private Duration queueTimeout = Duration.parse("PT1S");
        private Duration timeout = Duration.parse("PT5S");
        private int initialLimit = 20;
        private int maxLimit = 200;
        private int minLimit = 20;
        private int queueLength = 0;
        private String name = "aimd";
        private Supplier<Long> clock;

        protected BuilderBase() {
        }

        public BUILDER from(AimdLimitConfig prototype) {
            this.backoffRatio(prototype.backoffRatio());
            this.initialLimit(prototype.initialLimit());
            this.maxLimit(prototype.maxLimit());
            this.minLimit(prototype.minLimit());
            this.timeout(prototype.timeout());
            this.clock(prototype.clock());
            this.name(prototype.name());
            this.queueLength(prototype.queueLength());
            this.queueTimeout(prototype.queueTimeout());
            this.fair(prototype.fair());
            this.enableMetrics(prototype.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.backoffRatio(builder.backoffRatio());
            this.initialLimit(builder.initialLimit());
            this.maxLimit(builder.maxLimit());
            this.minLimit(builder.minLimit());
            this.timeout(builder.timeout());
            builder.clock().ifPresent(this::clock);
            this.name(builder.name());
            this.queueLength(builder.queueLength());
            this.queueTimeout(builder.queueTimeout());
            this.fair(builder.fair());
            this.enableMetrics(builder.enableMetrics());
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(io.helidon.common.config.Config config) {
            return (BUILDER)this.config(Config.config((io.helidon.common.config.Config)config));
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("backoff-ratio").as(Double.class).ifPresent(this::backoffRatio);
            config.get("initial-limit").as(Integer.class).ifPresent(this::initialLimit);
            config.get("max-limit").as(Integer.class).ifPresent(this::maxLimit);
            config.get("min-limit").as(Integer.class).ifPresent(this::minLimit);
            config.get("timeout").as(Duration.class).ifPresent(this::timeout);
            config.get("queue-length").as(Integer.class).ifPresent(this::queueLength);
            config.get("queue-timeout").as(Duration.class).ifPresent(this::queueTimeout);
            config.get("fair").as(Boolean.class).ifPresent(this::fair);
            config.get("enable-metrics").as(Boolean.class).ifPresent(this::enableMetrics);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER backoffRatio(double backoffRatio) {
            this.backoffRatio = backoffRatio;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER initialLimit(int initialLimit) {
            this.initialLimit = initialLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxLimit(int maxLimit) {
            this.maxLimit = maxLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER minLimit(int minLimit) {
            this.minLimit = minLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER timeout(Duration timeout) {
            Objects.requireNonNull(timeout);
            this.timeout = timeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearClock() {
            this.clock = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clock(Supplier<Long> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueLength(int queueLength) {
            this.queueLength = queueLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueTimeout(Duration queueTimeout) {
            Objects.requireNonNull(queueTimeout);
            this.queueTimeout = queueTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER fair(boolean fair) {
            this.fair = fair;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableMetrics(boolean enableMetrics) {
            this.enableMetrics = enableMetrics;
            return (BUILDER)((BuilderBase)this.self());
        }

        public double backoffRatio() {
            return this.backoffRatio;
        }

        public int initialLimit() {
            return this.initialLimit;
        }

        public int maxLimit() {
            return this.maxLimit;
        }

        public int minLimit() {
            return this.minLimit;
        }

        public Duration timeout() {
            return this.timeout;
        }

        public Optional<Supplier<Long>> clock() {
            return Optional.ofNullable(this.clock);
        }

        public String name() {
            return this.name;
        }

        public int queueLength() {
            return this.queueLength;
        }

        public Duration queueTimeout() {
            return this.queueTimeout;
        }

        public boolean fair() {
            return this.fair;
        }

        public boolean enableMetrics() {
            return this.enableMetrics;
        }

        public Optional<io.helidon.common.config.Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "AimdLimitConfigBuilder{backoffRatio=" + this.backoffRatio + ",initialLimit=" + this.initialLimit + ",maxLimit=" + this.maxLimit + ",minLimit=" + this.minLimit + ",timeout=" + String.valueOf(this.timeout) + ",clock=" + String.valueOf(this.clock) + ",name=" + this.name + ",queueLength=" + this.queueLength + ",queueTimeout=" + String.valueOf(this.queueTimeout) + ",fair=" + this.fair + ",enableMetrics=" + this.enableMetrics + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER clock(Optional<Supplier<Long>> clock) {
            Objects.requireNonNull(clock);
            this.clock = clock.map(Supplier.class::cast).orElse(this.clock);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class AimdLimitConfigImpl
        implements AimdLimitConfig,
        Supplier<AimdLimit> {
            private final boolean enableMetrics;
            private final boolean fair;
            private final double backoffRatio;
            private final Duration queueTimeout;
            private final Duration timeout;
            private final int initialLimit;
            private final int maxLimit;
            private final int minLimit;
            private final int queueLength;
            private final Optional<Supplier<Long>> clock;
            private final String name;

            protected AimdLimitConfigImpl(BuilderBase<?, ?> builder) {
                this.backoffRatio = builder.backoffRatio();
                this.initialLimit = builder.initialLimit();
                this.maxLimit = builder.maxLimit();
                this.minLimit = builder.minLimit();
                this.timeout = builder.timeout();
                this.clock = builder.clock().map(Function.identity());
                this.name = builder.name();
                this.queueLength = builder.queueLength();
                this.queueTimeout = builder.queueTimeout();
                this.fair = builder.fair();
                this.enableMetrics = builder.enableMetrics();
            }

            public AimdLimit build() {
                return AimdLimit.create(this);
            }

            @Override
            public AimdLimit get() {
                return this.build();
            }

            @Override
            public double backoffRatio() {
                return this.backoffRatio;
            }

            @Override
            public int initialLimit() {
                return this.initialLimit;
            }

            @Override
            public int maxLimit() {
                return this.maxLimit;
            }

            @Override
            public int minLimit() {
                return this.minLimit;
            }

            @Override
            public Duration timeout() {
                return this.timeout;
            }

            @Override
            public Optional<Supplier<Long>> clock() {
                return this.clock;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public int queueLength() {
                return this.queueLength;
            }

            @Override
            public Duration queueTimeout() {
                return this.queueTimeout;
            }

            @Override
            public boolean fair() {
                return this.fair;
            }

            @Override
            public boolean enableMetrics() {
                return this.enableMetrics;
            }

            public String toString() {
                return "AimdLimitConfig{backoffRatio=" + this.backoffRatio + ",initialLimit=" + this.initialLimit + ",maxLimit=" + this.maxLimit + ",minLimit=" + this.minLimit + ",timeout=" + String.valueOf(this.timeout) + ",clock=" + String.valueOf(this.clock) + ",name=" + this.name + ",queueLength=" + this.queueLength + ",queueTimeout=" + String.valueOf(this.queueTimeout) + ",fair=" + this.fair + ",enableMetrics=" + this.enableMetrics + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AimdLimitConfig)) {
                    return false;
                }
                AimdLimitConfig other = (AimdLimitConfig)o;
                return this.backoffRatio == other.backoffRatio() && this.initialLimit == other.initialLimit() && this.maxLimit == other.maxLimit() && this.minLimit == other.minLimit() && Objects.equals(this.timeout, other.timeout()) && Objects.equals(this.clock, other.clock()) && Objects.equals(this.name, other.name()) && this.queueLength == other.queueLength() && Objects.equals(this.queueTimeout, other.queueTimeout()) && this.fair == other.fair() && this.enableMetrics == other.enableMetrics();
            }

            public int hashCode() {
                return Objects.hash(this.backoffRatio, this.initialLimit, this.maxLimit, this.minLimit, this.timeout, this.clock, this.name, this.queueLength, this.queueTimeout, this.fair, this.enableMetrics);
            }
        }
    }
}

