/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces.impl.common;

import com.hedera.hapi.platform.event.GossipEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.EventOrigin;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pces.impl.common.PcesFile;
import org.hiero.consensus.pces.impl.common.PcesFileVersion;

public class PcesFileIterator
implements IOIterator<PlatformEvent> {
    private final long lowerBound;
    private final SerializableDataInputStream stream;
    private boolean hasPartialEvent = false;
    private PlatformEvent next;
    private boolean streamClosed = false;
    private PcesFileVersion fileVersion;

    public PcesFileIterator(@NonNull PcesFile fileDescriptor, long lowerBound) throws IOException {
        this.lowerBound = lowerBound;
        this.stream = new SerializableDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(fileDescriptor.getPath().toFile())));
        try {
            int fileVersionNumber = this.stream.readInt();
            this.fileVersion = PcesFileVersion.fromVersionNumber(fileVersionNumber);
            if (this.fileVersion == null) {
                throw new IOException("unsupported file version: " + fileVersionNumber);
            }
        }
        catch (EOFException e) {
            this.closeFile();
        }
    }

    private void findNext() throws IOException {
        while (this.next == null && !this.streamClosed) {
            if (this.stream.available() == 0) {
                this.closeFile();
                return;
            }
            try {
                switch (this.fileVersion) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case PROTOBUF_EVENTS: 
                }
                PlatformEvent candidate = new PlatformEvent((GossipEvent)this.stream.readPbjRecord(GossipEvent.PROTOBUF), EventOrigin.STORAGE);
                if (candidate.getBirthRound() < this.lowerBound) continue;
                this.next = candidate;
            }
            catch (IOException e) {
                this.hasPartialEvent = true;
                this.closeFile();
            }
            catch (NullPointerException e) {
                this.hasPartialEvent = true;
                this.closeFile();
                throw new IOException("GossipEvent read from the file is malformed", e);
            }
        }
    }

    private void closeFile() throws IOException {
        this.stream.close();
        this.streamClosed = true;
    }

    public boolean hasPartialEvent() {
        return this.hasPartialEvent;
    }

    public boolean hasNext() throws IOException {
        this.findNext();
        return this.next != null;
    }

    @NonNull
    public PlatformEvent next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no files remain in this iterator");
        }
        try {
            PlatformEvent platformEvent = this.next;
            return platformEvent;
        }
        finally {
            this.next = null;
        }
    }
}

