/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.grpc;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GrpcCompression {
    private static final System.Logger LOGGER = System.getLogger(GrpcCompression.class.getName());
    public static final String IDENTITY = "identity";
    private static final Map<String, Compressor> COMPRESSOR_MAP = Map.of("identity", IdentityGrpcTransformer.INSTANCE, "gzip", GzipGrpcTransformer.INSTANCE);
    private static final Map<String, Decompressor> DECOMPRESSOR_MAP = Map.of("identity", IdentityGrpcTransformer.INSTANCE, "gzip", GzipGrpcTransformer.INSTANCE);

    public static Set<String> getCompressorNames() {
        return COMPRESSOR_MAP.keySet();
    }

    public static Compressor getCompressor(String name) {
        return COMPRESSOR_MAP.get(name);
    }

    public static Set<String> getDecompressorNames() {
        return DECOMPRESSOR_MAP.keySet();
    }

    public static Decompressor getDecompressor(String name) {
        return DECOMPRESSOR_MAP.get(name);
    }

    public static Decompressor determineDecompressor(List<String> encodingList) {
        if (encodingList == null || encodingList.isEmpty()) {
            if (GrpcCompression.getDecompressor(IDENTITY) != null) {
                if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    LOGGER.log(System.Logger.Level.DEBUG, "GrpcCompression.determineDecompressor: identity (by default) for " + String.valueOf(encodingList));
                }
                return GrpcCompression.getDecompressor(IDENTITY);
            }
            throw new IllegalStateException("GRPC peer didn't provide grpc-encoding header and 'identity' is unsupported, only the following are supported: " + String.valueOf(GrpcCompression.getDecompressorNames()));
        }
        if (encodingList.size() > 1) {
            throw new IllegalStateException("GRPC peer specified multiple encodings at once: " + String.valueOf(encodingList));
        }
        String encoding = encodingList.get(0);
        if (GrpcCompression.getDecompressor(encoding) != null) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "GrpcCompression.determineDecompressor: " + encoding + " for " + String.valueOf(encodingList));
            }
            return GrpcCompression.getDecompressor(encoding);
        }
        throw new IllegalStateException("GRPC peer uses an unsupported encoding: '" + encoding + "' while only the following are supported: " + String.valueOf(GrpcCompression.getDecompressorNames()));
    }

    public static String determineCompressorName(List<String> acceptEncoding, String encoding) {
        List<String> supportedAcceptEncodings = acceptEncoding.stream().filter(ae -> GrpcCompression.getCompressorNames().stream().anyMatch(sae -> ae.equals(sae) || ae.startsWith(sae + ";"))).toList();
        if (supportedAcceptEncodings.isEmpty()) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "GrpcCompression.determineCompressorName: identity (by default) with preferred " + encoding + ", acceptEncoding: " + String.valueOf(acceptEncoding) + ", and supportedAcceptEncoding: " + String.valueOf(supportedAcceptEncodings));
            }
            return IDENTITY;
        }
        if (supportedAcceptEncodings.contains(encoding)) {
            if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                LOGGER.log(System.Logger.Level.DEBUG, "GrpcCompression.determineCompressorName: " + encoding + " (as preferred), acceptEncoding: " + String.valueOf(acceptEncoding) + ", and supportedAcceptEncoding: " + String.valueOf(supportedAcceptEncodings));
            }
            return encoding;
        }
        if (LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
            LOGGER.log(System.Logger.Level.DEBUG, "GrpcCompression.determineCompressorName: " + supportedAcceptEncodings.get(0) + " with preferred " + encoding + ", acceptEncoding: " + String.valueOf(acceptEncoding) + ", and supportedAcceptEncoding: " + String.valueOf(supportedAcceptEncodings));
        }
        return supportedAcceptEncodings.get(0);
    }

    public static interface Compressor {
        public Bytes compress(Bytes var1);
    }

    public static interface Decompressor {
        public Bytes decompress(Bytes var1);
    }

    private static class IdentityGrpcTransformer
    implements GrpcTransformer {
        private static final String NAME = "identity";
        private static final GrpcTransformer INSTANCE = new IdentityGrpcTransformer();

        private IdentityGrpcTransformer() {
        }

        @Override
        public Bytes compress(Bytes bytes) {
            return bytes;
        }

        @Override
        public Bytes decompress(Bytes bytes) {
            return bytes;
        }
    }

    public static interface GrpcTransformer
    extends Compressor,
    Decompressor {
    }

    private static class GzipGrpcTransformer
    implements GrpcTransformer {
        private static final String NAME = "gzip";
        private static final GrpcTransformer INSTANCE = new GzipGrpcTransformer();

        private GzipGrpcTransformer() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Bytes compress(Bytes bytes) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                Bytes bytes2;
                try (GZIPOutputStream gos = new GZIPOutputStream(baos);){
                    bytes.writeTo(gos);
                    gos.finish();
                    bytes2 = Bytes.wrap(baos.toByteArray());
                }
                return bytes2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public Bytes decompress(Bytes bytes) {
            byte[] buffer = new byte[1024];
            try (GZIPInputStream gis = new GZIPInputStream(bytes.toInputStream());){
                Bytes bytes2;
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                    int len;
                    while ((len = gis.read(buffer, 0, buffer.length)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    bytes2 = Bytes.wrap(baos.toByteArray());
                }
                return bytes2;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

