/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.stream.proto;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RuntimeVersion;
import com.google.protobuf.UninitializedMessageException;
import com.hedera.services.stream.proto.HashAlgorithm;
import com.hedera.services.stream.proto.HashObjectOrBuilder;
import com.hedera.services.stream.proto.HashObjectOuterClass;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class HashObject
extends GeneratedMessage
implements HashObjectOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ALGORITHM_FIELD_NUMBER = 1;
    private int algorithm_ = 0;
    public static final int LENGTH_FIELD_NUMBER = 2;
    private int length_ = 0;
    public static final int HASH_FIELD_NUMBER = 3;
    private ByteString hash_ = ByteString.EMPTY;
    private byte memoizedIsInitialized = (byte)-1;
    private static final HashObject DEFAULT_INSTANCE;
    private static final Parser<HashObject> PARSER;

    private HashObject(GeneratedMessage.Builder<?> builder) {
        super(builder);
    }

    private HashObject() {
        this.algorithm_ = 0;
        this.hash_ = ByteString.EMPTY;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return HashObjectOuterClass.internal_static_proto_HashObject_descriptor;
    }

    protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
        return HashObjectOuterClass.internal_static_proto_HashObject_fieldAccessorTable.ensureFieldAccessorsInitialized(HashObject.class, Builder.class);
    }

    @Override
    public int getAlgorithmValue() {
        return this.algorithm_;
    }

    @Override
    public HashAlgorithm getAlgorithm() {
        HashAlgorithm result = HashAlgorithm.forNumber(this.algorithm_);
        return result == null ? HashAlgorithm.UNRECOGNIZED : result;
    }

    @Override
    public int getLength() {
        return this.length_;
    }

    @Override
    public ByteString getHash() {
        return this.hash_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.algorithm_ != HashAlgorithm.HASH_ALGORITHM_UNKNOWN.getNumber()) {
            output.writeEnum(1, this.algorithm_);
        }
        if (this.length_ != 0) {
            output.writeInt32(2, this.length_);
        }
        if (!this.hash_.isEmpty()) {
            output.writeBytes(3, this.hash_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.algorithm_ != HashAlgorithm.HASH_ALGORITHM_UNKNOWN.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)1, (int)this.algorithm_);
        }
        if (this.length_ != 0) {
            size += CodedOutputStream.computeInt32Size((int)2, (int)this.length_);
        }
        if (!this.hash_.isEmpty()) {
            size += CodedOutputStream.computeBytesSize((int)3, (ByteString)this.hash_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HashObject)) {
            return super.equals(obj);
        }
        HashObject other = (HashObject)obj;
        if (this.algorithm_ != other.algorithm_) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (!this.getHash().equals((Object)other.getHash())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + HashObject.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.algorithm_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getLength();
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getHash().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static HashObject parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data);
    }

    public static HashObject parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HashObject parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data);
    }

    public static HashObject parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HashObject parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data);
    }

    public static HashObject parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (HashObject)PARSER.parseFrom(data, extensionRegistry);
    }

    public static HashObject parseFrom(InputStream input) throws IOException {
        return (HashObject)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input);
    }

    public static HashObject parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HashObject)GeneratedMessage.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HashObject parseDelimitedFrom(InputStream input) throws IOException {
        return (HashObject)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static HashObject parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HashObject)GeneratedMessage.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static HashObject parseFrom(CodedInputStream input) throws IOException {
        return (HashObject)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static HashObject parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (HashObject)GeneratedMessage.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return HashObject.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(HashObject prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(AbstractMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static HashObject getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<HashObject> parser() {
        return PARSER;
    }

    public Parser<HashObject> getParserForType() {
        return PARSER;
    }

    public HashObject getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    static {
        RuntimeVersion.validateProtobufGencodeVersion((RuntimeVersion.RuntimeDomain)RuntimeVersion.RuntimeDomain.PUBLIC, (int)4, (int)33, (int)5, (String)"", (String)"HashObject");
        DEFAULT_INSTANCE = new HashObject();
        PARSER = new AbstractParser<HashObject>(){

            public HashObject parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = HashObject.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };
    }

    public static final class Builder
    extends GeneratedMessage.Builder<Builder>
    implements HashObjectOrBuilder {
        private int bitField0_;
        private int algorithm_ = 0;
        private int length_;
        private ByteString hash_ = ByteString.EMPTY;

        public static final Descriptors.Descriptor getDescriptor() {
            return HashObjectOuterClass.internal_static_proto_HashObject_descriptor;
        }

        protected GeneratedMessage.FieldAccessorTable internalGetFieldAccessorTable() {
            return HashObjectOuterClass.internal_static_proto_HashObject_fieldAccessorTable.ensureFieldAccessorsInitialized(HashObject.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(AbstractMessage.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.algorithm_ = 0;
            this.length_ = 0;
            this.hash_ = ByteString.EMPTY;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return HashObjectOuterClass.internal_static_proto_HashObject_descriptor;
        }

        public HashObject getDefaultInstanceForType() {
            return HashObject.getDefaultInstance();
        }

        public HashObject build() {
            HashObject result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public HashObject buildPartial() {
            HashObject result = new HashObject(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(HashObject result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.algorithm_ = this.algorithm_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.length_ = this.length_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.hash_ = this.hash_;
            }
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof HashObject) {
                return this.mergeFrom((HashObject)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(HashObject other) {
            if (other == HashObject.getDefaultInstance()) {
                return this;
            }
            if (other.algorithm_ != 0) {
                this.setAlgorithmValue(other.getAlgorithmValue());
            }
            if (other.getLength() != 0) {
                this.setLength(other.getLength());
            }
            if (!other.getHash().isEmpty()) {
                this.setHash(other.getHash());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 8: {
                            this.algorithm_ = input.readEnum();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 16: {
                            this.length_ = input.readInt32();
                            this.bitField0_ |= 2;
                            continue block11;
                        }
                        case 26: {
                            this.hash_ = input.readBytes();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public int getAlgorithmValue() {
            return this.algorithm_;
        }

        public Builder setAlgorithmValue(int value) {
            this.algorithm_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public HashAlgorithm getAlgorithm() {
            HashAlgorithm result = HashAlgorithm.forNumber(this.algorithm_);
            return result == null ? HashAlgorithm.UNRECOGNIZED : result;
        }

        public Builder setAlgorithm(HashAlgorithm value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 1;
            this.algorithm_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAlgorithm() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.algorithm_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getLength() {
            return this.length_;
        }

        public Builder setLength(int value) {
            this.length_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearLength() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.length_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public ByteString getHash() {
            return this.hash_;
        }

        public Builder setHash(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.hash_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearHash() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.hash_ = HashObject.getDefaultInstance().getHash();
            this.onChanged();
            return this;
        }
    }
}

