/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.block.api;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.hiero.block.api.codec.PublishStreamResponseJsonCodec;
import org.hiero.block.api.codec.PublishStreamResponseProtoCodec;
import org.hiero.block.api.schema.PublishStreamResponseSchema;

public final class PublishStreamResponse {
    public static final Codec<PublishStreamResponse> PROTOBUF = new PublishStreamResponseProtoCodec();
    public static final JsonCodec<PublishStreamResponse> JSON = new PublishStreamResponseJsonCodec();
    public static final PublishStreamResponse DEFAULT = PublishStreamResponse.newBuilder().build();
    private final OneOf<ResponseOneOfType> response;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public PublishStreamResponse(OneOf<ResponseOneOfType> response) {
        this.$unknownFields = null;
        if (response == null) {
            throw new NullPointerException("Parameter 'response' must be supplied and can not be null");
        }
        this.response = response;
    }

    public PublishStreamResponse(OneOf<ResponseOneOfType> response, List<UnknownField> $unknownFields) {
        List<UnknownField> list = this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        if (response == null) {
            throw new NullPointerException("Parameter 'response' must be supplied and can not be null");
        }
        this.response = response;
    }

    public OneOf<ResponseOneOfType> response() {
        return this.response;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            if (this.response.kind() == ResponseOneOfType.ACKNOWLEDGEMENT) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamResponseSchema.ACKNOWLEDGEMENT, (Object)((BlockAcknowledgement)this.response.as()), BlockAcknowledgement.PROTOBUF);
            }
            if (this.response.kind() == ResponseOneOfType.END_STREAM) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamResponseSchema.END_STREAM, (Object)((EndOfStream)this.response.as()), EndOfStream.PROTOBUF);
            }
            if (this.response.kind() == ResponseOneOfType.SKIP_BLOCK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamResponseSchema.SKIP_BLOCK, (Object)((SkipBlock)this.response.as()), SkipBlock.PROTOBUF);
            }
            if (this.response.kind() == ResponseOneOfType.RESEND_BLOCK) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamResponseSchema.RESEND_BLOCK, (Object)((ResendBlock)this.response.as()), ResendBlock.PROTOBUF);
            }
            if (this.response.kind() == ResponseOneOfType.NODE_BEHIND_PUBLISHER) {
                _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)PublishStreamResponseSchema.NODE_BEHIND_PUBLISHER, (Object)((BehindPublisher)this.response.as()), BehindPublisher.PROTOBUF);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.response != null && !this.response.equals(PublishStreamResponse.DEFAULT.response)) {
                result = 31 * result + this.response.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        PublishStreamResponse thatObj = (PublishStreamResponse)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.response == null && thatObj.response != null) {
            return false;
        }
        if (this.response != null && !this.response.equals(thatObj.response)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "PublishStreamResponse[response=" + String.valueOf(this.response) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    @Nullable
    public BlockAcknowledgement acknowledgement() {
        return this.response.kind() == ResponseOneOfType.ACKNOWLEDGEMENT ? (BlockAcknowledgement)this.response.value() : null;
    }

    public boolean hasAcknowledgement() {
        return this.response.kind() == ResponseOneOfType.ACKNOWLEDGEMENT;
    }

    public BlockAcknowledgement acknowledgementOrElse(@NonNull BlockAcknowledgement defaultValue) {
        return this.hasAcknowledgement() ? this.acknowledgement() : defaultValue;
    }

    @NonNull
    public BlockAcknowledgement acknowledgementOrThrow() {
        return Objects.requireNonNull(this.acknowledgement(), "Field acknowledgement is null");
    }

    @Nullable
    public EndOfStream endStream() {
        return this.response.kind() == ResponseOneOfType.END_STREAM ? (EndOfStream)this.response.value() : null;
    }

    public boolean hasEndStream() {
        return this.response.kind() == ResponseOneOfType.END_STREAM;
    }

    public EndOfStream endStreamOrElse(@NonNull EndOfStream defaultValue) {
        return this.hasEndStream() ? this.endStream() : defaultValue;
    }

    @NonNull
    public EndOfStream endStreamOrThrow() {
        return Objects.requireNonNull(this.endStream(), "Field endStream is null");
    }

    @Nullable
    public SkipBlock skipBlock() {
        return this.response.kind() == ResponseOneOfType.SKIP_BLOCK ? (SkipBlock)this.response.value() : null;
    }

    public boolean hasSkipBlock() {
        return this.response.kind() == ResponseOneOfType.SKIP_BLOCK;
    }

    public SkipBlock skipBlockOrElse(@NonNull SkipBlock defaultValue) {
        return this.hasSkipBlock() ? this.skipBlock() : defaultValue;
    }

    @NonNull
    public SkipBlock skipBlockOrThrow() {
        return Objects.requireNonNull(this.skipBlock(), "Field skipBlock is null");
    }

    @Nullable
    public ResendBlock resendBlock() {
        return this.response.kind() == ResponseOneOfType.RESEND_BLOCK ? (ResendBlock)this.response.value() : null;
    }

    public boolean hasResendBlock() {
        return this.response.kind() == ResponseOneOfType.RESEND_BLOCK;
    }

    public ResendBlock resendBlockOrElse(@NonNull ResendBlock defaultValue) {
        return this.hasResendBlock() ? this.resendBlock() : defaultValue;
    }

    @NonNull
    public ResendBlock resendBlockOrThrow() {
        return Objects.requireNonNull(this.resendBlock(), "Field resendBlock is null");
    }

    @Nullable
    public BehindPublisher nodeBehindPublisher() {
        return this.response.kind() == ResponseOneOfType.NODE_BEHIND_PUBLISHER ? (BehindPublisher)this.response.value() : null;
    }

    public boolean hasNodeBehindPublisher() {
        return this.response.kind() == ResponseOneOfType.NODE_BEHIND_PUBLISHER;
    }

    public BehindPublisher nodeBehindPublisherOrElse(@NonNull BehindPublisher defaultValue) {
        return this.hasNodeBehindPublisher() ? this.nodeBehindPublisher() : defaultValue;
    }

    @NonNull
    public BehindPublisher nodeBehindPublisherOrThrow() {
        return Objects.requireNonNull(this.nodeBehindPublisher(), "Field nodeBehindPublisher is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.response, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum ResponseOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        ACKNOWLEDGEMENT(1, "acknowledgement"),
        END_STREAM(2, "end_stream"),
        SKIP_BLOCK(3, "skip_block"),
        RESEND_BLOCK(4, "resend_block"),
        NODE_BEHIND_PUBLISHER(5, "node_behind_publisher");

        private final int protoOrdinal;
        private final String protoName;

        private ResponseOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static ResponseOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> ACKNOWLEDGEMENT;
                case 2 -> END_STREAM;
                case 3 -> SKIP_BLOCK;
                case 4 -> RESEND_BLOCK;
                case 5 -> NODE_BEHIND_PUBLISHER;
                default -> UNSET;
            };
        }

        public static ResponseOneOfType fromString(String name) {
            return switch (name) {
                case "acknowledgement", "ACKNOWLEDGEMENT" -> ACKNOWLEDGEMENT;
                case "end_stream", "END_STREAM" -> END_STREAM;
                case "skip_block", "SKIP_BLOCK" -> SKIP_BLOCK;
                case "resend_block", "RESEND_BLOCK" -> RESEND_BLOCK;
                case "node_behind_publisher", "NODE_BEHIND_PUBLISHER" -> NODE_BEHIND_PUBLISHER;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }

        public static ResponseOneOfType fromObject(Object obj) {
            if (obj == null) {
                return ResponseOneOfType.fromProtobufOrdinal(0);
            }
            if (obj instanceof ResponseOneOfType) {
                ResponseOneOfType pbjEnum = (ResponseOneOfType)((Object)obj);
                return pbjEnum;
            }
            return UNSET;
        }

        public static List<ResponseOneOfType> fromObjects(List<?> list) {
            return list.stream().map(ResponseOneOfType::fromObject).toList();
        }

        public static int toProtoOrdinal(Object obj) {
            if (obj instanceof ResponseOneOfType) {
                ResponseOneOfType pbjEnum = (ResponseOneOfType)((Object)obj);
                return pbjEnum.protoOrdinal();
            }
            if (obj instanceof Integer) {
                Integer i = (Integer)obj;
                return i;
            }
            throw new IllegalArgumentException("Neither ResponseOneOfType, nor Integer, but: " + obj.getClass().getName());
        }

        public static List<Integer> toProtoOrdinals(List<?> list) {
            return list.stream().map(ResponseOneOfType::toProtoOrdinal).toList();
        }

        public static int compare(Object o1, Object o2) {
            int i2;
            int i1;
            if (o1 instanceof ResponseOneOfType) {
                ResponseOneOfType e1 = (ResponseOneOfType)((Object)o1);
                if (o2 instanceof ResponseOneOfType) {
                    ResponseOneOfType e2 = (ResponseOneOfType)((Object)o2);
                    return e1.compareTo(e2);
                }
            }
            if (o1 == null && o2 != null) {
                return -1;
            }
            if (o1 != null && o2 == null) {
                return 1;
            }
            if (o1 instanceof ResponseOneOfType) {
                ResponseOneOfType e1 = (ResponseOneOfType)((Object)o1);
                i1 = e1.protoOrdinal();
            } else if (o1 instanceof Integer) {
                Integer ii1 = (Integer)o1;
                i1 = ii1;
            } else {
                throw new IllegalArgumentException("o1 is neither ResponseOneOfType, nor Integer. It's: " + o1.getClass().getName());
            }
            if (o2 instanceof ResponseOneOfType) {
                ResponseOneOfType e2 = (ResponseOneOfType)((Object)o2);
                i2 = e2.protoOrdinal();
            } else if (o2 instanceof Integer) {
                Integer ii2 = (Integer)o2;
                i2 = ii2;
            } else {
                throw new IllegalArgumentException("o2 is neither ResponseOneOfType, nor Integer. It's: " + o2.getClass().getName());
            }
            return Integer.compare(i1, i2);
        }
    }

    public static final class BlockAcknowledgement {
        public static final Codec<BlockAcknowledgement> PROTOBUF = new PublishStreamResponseProtoCodec.BlockAcknowledgementProtoCodec();
        public static final JsonCodec<BlockAcknowledgement> JSON = new PublishStreamResponseJsonCodec.BlockAcknowledgementJsonCodec();
        public static final BlockAcknowledgement DEFAULT = BlockAcknowledgement.newBuilder().build();
        private final long blockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public BlockAcknowledgement(long blockNumber) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
        }

        public BlockAcknowledgement(long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamResponseSchema.BlockAcknowledgementSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.blockNumber != BlockAcknowledgement.DEFAULT.blockNumber) {
                    result = 31 * result + Long.hashCode(this.blockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            BlockAcknowledgement thatObj = (BlockAcknowledgement)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.blockNumber != thatObj.blockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "BlockAcknowledgement[blockNumber=" + this.blockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.blockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private long blockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(long blockNumber) {
                this.$unknownFields = null;
                this.blockNumber = blockNumber;
            }

            public Builder(long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.blockNumber = blockNumber;
            }

            public BlockAcknowledgement build() {
                return new BlockAcknowledgement(this.blockNumber);
            }

            public Builder blockNumber(long blockNumber) {
                this.blockNumber = blockNumber;
                return this;
            }

            public long blockNumber() {
                return this.blockNumber;
            }
        }
    }

    public static final class EndOfStream {
        public static final Codec<EndOfStream> PROTOBUF = new PublishStreamResponseProtoCodec.EndOfStreamProtoCodec();
        public static final JsonCodec<EndOfStream> JSON = new PublishStreamResponseJsonCodec.EndOfStreamJsonCodec();
        public static final EndOfStream DEFAULT = EndOfStream.newBuilder().build();
        private final Object status;
        private final long blockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public EndOfStream(Code status, long blockNumber) {
            this.$unknownFields = null;
            this.status = status;
            this.blockNumber = blockNumber;
        }

        public EndOfStream(Object status, long blockNumber) {
            this.$unknownFields = null;
            this.status = status;
            this.blockNumber = blockNumber;
        }

        public EndOfStream(Code status, long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.status = status;
            this.blockNumber = blockNumber;
        }

        public EndOfStream(Object status, long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.status = status;
            this.blockNumber = blockNumber;
        }

        public Code status() {
            return Code.fromObject(this.status);
        }

        public int statusProtoOrdinal() {
            return Code.toProtoOrdinal(this.status);
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)PublishStreamResponseSchema.EndOfStreamSchema.STATUS, (Object)this.status);
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamResponseSchema.EndOfStreamSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.status != null && !this.status.equals(EndOfStream.DEFAULT.status)) {
                    result = 31 * result + Integer.hashCode(EnumWithProtoMetadata.protoOrdinal((Object)this.status));
                }
                if (this.blockNumber != EndOfStream.DEFAULT.blockNumber) {
                    result = 31 * result + Long.hashCode(this.blockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            EndOfStream thatObj = (EndOfStream)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.status == null && thatObj.status != null) {
                return false;
            }
            if (this.status != null && !this.status.equals(thatObj.status)) {
                return false;
            }
            if (this.blockNumber != thatObj.blockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "EndOfStream[status=" + String.valueOf(this.status) + ", blockNumber=" + this.blockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.status, this.blockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static enum Code implements EnumWithProtoMetadata
        {
            UNKNOWN(0, "UNKNOWN"),
            SUCCESS(1, "SUCCESS"),
            INVALID_REQUEST(2, "INVALID_REQUEST"),
            ERROR(3, "ERROR"),
            TIMEOUT(4, "TIMEOUT"),
            DUPLICATE_BLOCK(5, "DUPLICATE_BLOCK"),
            BAD_BLOCK_PROOF(6, "BAD_BLOCK_PROOF"),
            PERSISTENCE_FAILED(7, "PERSISTENCE_FAILED"),
            UNRECOGNIZED(-1, "UNRECOGNIZED");

            private final int protoOrdinal;
            private final String protoName;

            private Code(int protoOrdinal, String protoName) {
                this.protoOrdinal = protoOrdinal;
                this.protoName = protoName;
            }

            public int protoOrdinal() {
                return this.protoOrdinal;
            }

            public String protoName() {
                return this.protoName;
            }

            public static Code fromProtobufOrdinal(int ordinal) {
                return switch (ordinal) {
                    case 0 -> UNKNOWN;
                    case 1 -> SUCCESS;
                    case 2 -> INVALID_REQUEST;
                    case 3 -> ERROR;
                    case 4 -> TIMEOUT;
                    case 5 -> DUPLICATE_BLOCK;
                    case 6 -> BAD_BLOCK_PROOF;
                    case 7 -> PERSISTENCE_FAILED;
                    default -> UNRECOGNIZED;
                };
            }

            public static Code fromString(String name) {
                return switch (name) {
                    case "UNKNOWN" -> UNKNOWN;
                    case "SUCCESS" -> SUCCESS;
                    case "INVALID_REQUEST" -> INVALID_REQUEST;
                    case "ERROR" -> ERROR;
                    case "TIMEOUT" -> TIMEOUT;
                    case "DUPLICATE_BLOCK" -> DUPLICATE_BLOCK;
                    case "BAD_BLOCK_PROOF" -> BAD_BLOCK_PROOF;
                    case "PERSISTENCE_FAILED" -> PERSISTENCE_FAILED;
                    default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
                };
            }

            public static Code fromObject(Object obj) {
                if (obj == null) {
                    return Code.fromProtobufOrdinal(0);
                }
                if (obj instanceof Code) {
                    Code pbjEnum = (Code)((Object)obj);
                    return pbjEnum;
                }
                return UNRECOGNIZED;
            }

            public static List<Code> fromObjects(List<?> list) {
                return list.stream().map(Code::fromObject).toList();
            }

            public static int toProtoOrdinal(Object obj) {
                if (obj instanceof Code) {
                    Code pbjEnum = (Code)((Object)obj);
                    return pbjEnum.protoOrdinal();
                }
                if (obj instanceof Integer) {
                    Integer i = (Integer)obj;
                    return i;
                }
                throw new IllegalArgumentException("Neither Code, nor Integer, but: " + obj.getClass().getName());
            }

            public static List<Integer> toProtoOrdinals(List<?> list) {
                return list.stream().map(Code::toProtoOrdinal).toList();
            }

            public static int compare(Object o1, Object o2) {
                int i2;
                int i1;
                if (o1 instanceof Code) {
                    Code e1 = (Code)((Object)o1);
                    if (o2 instanceof Code) {
                        Code e2 = (Code)((Object)o2);
                        return e1.compareTo(e2);
                    }
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1 instanceof Code) {
                    Code e1 = (Code)((Object)o1);
                    i1 = e1.protoOrdinal();
                } else if (o1 instanceof Integer) {
                    Integer ii1 = (Integer)o1;
                    i1 = ii1;
                } else {
                    throw new IllegalArgumentException("o1 is neither Code, nor Integer. It's: " + o1.getClass().getName());
                }
                if (o2 instanceof Code) {
                    Code e2 = (Code)((Object)o2);
                    i2 = e2.protoOrdinal();
                } else if (o2 instanceof Integer) {
                    Integer ii2 = (Integer)o2;
                    i2 = ii2;
                } else {
                    throw new IllegalArgumentException("o2 is neither Code, nor Integer. It's: " + o2.getClass().getName());
                }
                return Integer.compare(i1, i2);
            }
        }

        public static final class Builder {
            private Object status = Code.fromProtobufOrdinal(0);
            private long blockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(Code status, long blockNumber) {
                this.$unknownFields = null;
                this.status = status;
                this.blockNumber = blockNumber;
            }

            public Builder(Object status, long blockNumber) {
                this.$unknownFields = null;
                this.status = status;
                this.blockNumber = blockNumber;
            }

            public Builder(Code status, long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.status = status;
                this.blockNumber = blockNumber;
            }

            public Builder(Object status, long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.status = status;
                this.blockNumber = blockNumber;
            }

            public EndOfStream build() {
                return new EndOfStream(this.status, this.blockNumber);
            }

            public Builder status(Code status) {
                this.status = status;
                return this;
            }

            public Builder blockNumber(long blockNumber) {
                this.blockNumber = blockNumber;
                return this;
            }

            public Code status() {
                return Code.fromObject(this.status);
            }

            public int statusProtoOrdinal() {
                return Code.toProtoOrdinal(this.status);
            }

            public long blockNumber() {
                return this.blockNumber;
            }
        }
    }

    public static final class SkipBlock {
        public static final Codec<SkipBlock> PROTOBUF = new PublishStreamResponseProtoCodec.SkipBlockProtoCodec();
        public static final JsonCodec<SkipBlock> JSON = new PublishStreamResponseJsonCodec.SkipBlockJsonCodec();
        public static final SkipBlock DEFAULT = SkipBlock.newBuilder().build();
        private final long blockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public SkipBlock(long blockNumber) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
        }

        public SkipBlock(long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamResponseSchema.SkipBlockSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.blockNumber != SkipBlock.DEFAULT.blockNumber) {
                    result = 31 * result + Long.hashCode(this.blockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            SkipBlock thatObj = (SkipBlock)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.blockNumber != thatObj.blockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "SkipBlock[blockNumber=" + this.blockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.blockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private long blockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(long blockNumber) {
                this.$unknownFields = null;
                this.blockNumber = blockNumber;
            }

            public Builder(long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.blockNumber = blockNumber;
            }

            public SkipBlock build() {
                return new SkipBlock(this.blockNumber);
            }

            public Builder blockNumber(long blockNumber) {
                this.blockNumber = blockNumber;
                return this;
            }

            public long blockNumber() {
                return this.blockNumber;
            }
        }
    }

    public static final class ResendBlock {
        public static final Codec<ResendBlock> PROTOBUF = new PublishStreamResponseProtoCodec.ResendBlockProtoCodec();
        public static final JsonCodec<ResendBlock> JSON = new PublishStreamResponseJsonCodec.ResendBlockJsonCodec();
        public static final ResendBlock DEFAULT = ResendBlock.newBuilder().build();
        private final long blockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public ResendBlock(long blockNumber) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
        }

        public ResendBlock(long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamResponseSchema.ResendBlockSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.blockNumber != ResendBlock.DEFAULT.blockNumber) {
                    result = 31 * result + Long.hashCode(this.blockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            ResendBlock thatObj = (ResendBlock)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.blockNumber != thatObj.blockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "ResendBlock[blockNumber=" + this.blockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.blockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private long blockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(long blockNumber) {
                this.$unknownFields = null;
                this.blockNumber = blockNumber;
            }

            public Builder(long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.blockNumber = blockNumber;
            }

            public ResendBlock build() {
                return new ResendBlock(this.blockNumber);
            }

            public Builder blockNumber(long blockNumber) {
                this.blockNumber = blockNumber;
                return this;
            }

            public long blockNumber() {
                return this.blockNumber;
            }
        }
    }

    public static final class BehindPublisher {
        public static final Codec<BehindPublisher> PROTOBUF = new PublishStreamResponseProtoCodec.BehindPublisherProtoCodec();
        public static final JsonCodec<BehindPublisher> JSON = new PublishStreamResponseJsonCodec.BehindPublisherJsonCodec();
        public static final BehindPublisher DEFAULT = BehindPublisher.newBuilder().build();
        private final long blockNumber;
        private int $hashCode = -1;
        private int $protobufEncodedSize = -1;
        private final List<UnknownField> $unknownFields;

        public BehindPublisher(long blockNumber) {
            this.$unknownFields = null;
            this.blockNumber = blockNumber;
        }

        public BehindPublisher(long blockNumber, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.blockNumber = blockNumber;
        }

        public long blockNumber() {
            return this.blockNumber;
        }

        @NonNull
        public List<UnknownField> getUnknownFields() {
            return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
        }

        public int protobufSize() {
            if (this.$protobufEncodedSize == -1) {
                int _size = 0;
                _size += ProtoWriterTools.sizeOfLong((FieldDefinition)PublishStreamResponseSchema.BehindPublisherSchema.BLOCK_NUMBER, (long)this.blockNumber, (boolean)true);
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        UnknownField uf = this.$unknownFields.get(i);
                        _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                        _size += Math.toIntExact(uf.bytes().length());
                    }
                }
                this.$protobufEncodedSize = _size;
            }
            return this.$protobufEncodedSize;
        }

        public int hashCode() {
            if (this.$hashCode == -1) {
                int result = 1;
                if (this.blockNumber != BehindPublisher.DEFAULT.blockNumber) {
                    result = 31 * result + Long.hashCode(this.blockNumber);
                }
                if (this.$unknownFields != null) {
                    for (int i = 0; i < this.$unknownFields.size(); ++i) {
                        result = 31 * result + this.$unknownFields.get(i).hashCode();
                    }
                }
                long hashCode = result;
                hashCode += hashCode << 30;
                hashCode ^= hashCode >>> 27;
                hashCode += hashCode << 16;
                hashCode ^= hashCode >>> 20;
                hashCode += hashCode << 5;
                hashCode ^= hashCode >>> 18;
                hashCode += hashCode << 10;
                hashCode ^= hashCode >>> 24;
                hashCode += hashCode << 30;
                this.$hashCode = (int)hashCode;
            }
            return this.$hashCode;
        }

        public boolean equals(Object that) {
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            BehindPublisher thatObj = (BehindPublisher)that;
            if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
                return false;
            }
            if (this.blockNumber != thatObj.blockNumber) {
                return false;
            }
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                    return false;
                }
                if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                    return false;
                }
            } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
                return false;
            }
            return true;
        }

        public String toString() {
            String $ufstr = null;
            if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    this.$unknownFields.get(i).printToString(sb);
                }
                $ufstr = sb.toString();
            }
            return "BehindPublisher[blockNumber=" + this.blockNumber + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
        }

        public Builder copyBuilder() {
            return new Builder(this.blockNumber, this.$unknownFields);
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static final class Builder {
            private long blockNumber = 0L;
            private final List<UnknownField> $unknownFields;

            public Builder() {
                this.$unknownFields = null;
            }

            public Builder(long blockNumber) {
                this.$unknownFields = null;
                this.blockNumber = blockNumber;
            }

            public Builder(long blockNumber, List<UnknownField> $unknownFields) {
                this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
                this.blockNumber = blockNumber;
            }

            public BehindPublisher build() {
                return new BehindPublisher(this.blockNumber);
            }

            public Builder blockNumber(long blockNumber) {
                this.blockNumber = blockNumber;
                return this;
            }

            public long blockNumber() {
                return this.blockNumber;
            }
        }
    }

    public static final class Builder {
        private OneOf<ResponseOneOfType> response = PublishStreamResponseProtoCodec.RESPONSE_UNSET;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(OneOf<ResponseOneOfType> response) {
            this.$unknownFields = null;
            this.response = response;
        }

        public Builder(OneOf<ResponseOneOfType> response, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.response = response;
        }

        public PublishStreamResponse build() {
            return new PublishStreamResponse(this.response);
        }

        public void clearResponse() {
            this.response = PublishStreamResponseProtoCodec.RESPONSE_UNSET;
        }

        public Builder acknowledgement(@Nullable BlockAcknowledgement acknowledgement) {
            this.response = new OneOf((Enum)ResponseOneOfType.ACKNOWLEDGEMENT, (Object)acknowledgement);
            return this;
        }

        public Builder acknowledgement(BlockAcknowledgement.Builder builder) {
            this.response = new OneOf((Enum)ResponseOneOfType.ACKNOWLEDGEMENT, (Object)builder.build());
            return this;
        }

        public Builder endStream(@Nullable EndOfStream endStream) {
            this.response = new OneOf((Enum)ResponseOneOfType.END_STREAM, (Object)endStream);
            return this;
        }

        public Builder endStream(EndOfStream.Builder builder) {
            this.response = new OneOf((Enum)ResponseOneOfType.END_STREAM, (Object)builder.build());
            return this;
        }

        public Builder skipBlock(@Nullable SkipBlock skipBlock) {
            this.response = new OneOf((Enum)ResponseOneOfType.SKIP_BLOCK, (Object)skipBlock);
            return this;
        }

        public Builder skipBlock(SkipBlock.Builder builder) {
            this.response = new OneOf((Enum)ResponseOneOfType.SKIP_BLOCK, (Object)builder.build());
            return this;
        }

        public Builder resendBlock(@Nullable ResendBlock resendBlock) {
            this.response = new OneOf((Enum)ResponseOneOfType.RESEND_BLOCK, (Object)resendBlock);
            return this;
        }

        public Builder resendBlock(ResendBlock.Builder builder) {
            this.response = new OneOf((Enum)ResponseOneOfType.RESEND_BLOCK, (Object)builder.build());
            return this;
        }

        public Builder nodeBehindPublisher(@Nullable BehindPublisher nodeBehindPublisher) {
            this.response = new OneOf((Enum)ResponseOneOfType.NODE_BEHIND_PUBLISHER, (Object)nodeBehindPublisher);
            return this;
        }

        public Builder nodeBehindPublisher(BehindPublisher.Builder builder) {
            this.response = new OneOf((Enum)ResponseOneOfType.NODE_BEHIND_PUBLISHER, (Object)builder.build());
            return this;
        }

        public OneOf<ResponseOneOfType> response() {
            return this.response;
        }
    }
}

