/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import org.hiero.base.crypto.DetRandomProvider;
import org.hiero.consensus.crypto.CertificateUtils;
import org.hiero.consensus.crypto.KeyCertPurpose;
import org.hiero.consensus.crypto.KeyGeneratingException;
import org.hiero.consensus.crypto.SigningFactory;
import org.hiero.consensus.crypto.SigningSchema;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public class KeysAndCertsGenerator {
    private static final int MASTER_KEY_MULTIPLIER = 157;
    private static final int SWIRLD_ID_MULTIPLIER = 163;
    private static final int BITS_IN_BYTE = 8;
    private static final int SIG_SEED = 2;
    private static final int AGR_SEED = 0;

    private KeysAndCertsGenerator() {
    }

    public static KeysAndCerts generate(NodeId nodeId) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, KeyGeneratingException {
        return KeysAndCertsGenerator.generate(nodeId, SigningSchema.RSA);
    }

    public static KeysAndCerts generate(NodeId nodeId, @NonNull SigningSchema schema) throws NoSuchAlgorithmException, NoSuchProviderException, KeyStoreException, KeyGeneratingException {
        int j;
        byte[] masterKey = new byte[32];
        byte[] swirldId = new byte[48];
        int i = (int)nodeId.id();
        for (j = 0; j < masterKey.length; ++j) {
            masterKey[j] = (byte)(j * 157);
        }
        for (j = 0; j < swirldId.length; ++j) {
            swirldId[j] = (byte)(j * 163);
        }
        masterKey[0] = (byte)i;
        masterKey[1] = (byte)(i >> 8);
        byte[] memberId = KeysAndCertsGenerator.intToBytes(i);
        SecureRandom sigDetRandom = DetRandomProvider.getDetRandom();
        sigDetRandom.setSeed(masterKey);
        sigDetRandom.setSeed(swirldId);
        sigDetRandom.setSeed(memberId);
        sigDetRandom.setSeed(2L);
        SecureRandom agrDetRandom = DetRandomProvider.getDetRandom();
        agrDetRandom.setSeed(masterKey);
        agrDetRandom.setSeed(swirldId);
        agrDetRandom.setSeed(memberId);
        agrDetRandom.setSeed(0L);
        return KeysAndCertsGenerator.generate(nodeId, schema, sigDetRandom, agrDetRandom);
    }

    @NonNull
    public static KeysAndCerts generate(@NonNull NodeId nodeId, @NonNull SigningSchema schema, @NonNull SecureRandom sigDetRandom, @NonNull SecureRandom agrDetRandom) throws NoSuchAlgorithmException, NoSuchProviderException, KeyGeneratingException {
        KeyPairGenerator agrKeyGen = KeyPairGenerator.getInstance("EC", "SunEC");
        agrKeyGen.initialize(384, agrDetRandom);
        KeyPair sigKeyPair = SigningFactory.generateKeyPair(schema, sigDetRandom);
        KeyPair agrKeyPair = agrKeyGen.generateKeyPair();
        String dnS = CertificateUtils.distinguishedName(KeyCertPurpose.SIGNING.storeName(nodeId));
        String dnA = CertificateUtils.distinguishedName(KeyCertPurpose.AGREEMENT.storeName(nodeId));
        X509Certificate sigCert = CertificateUtils.generateCertificate(dnS, sigKeyPair, dnS, sigKeyPair, sigDetRandom, schema.getSigningAlgorithm());
        X509Certificate agrCert = CertificateUtils.generateCertificate(dnA, agrKeyPair, dnS, sigKeyPair, agrDetRandom, schema.getSigningAlgorithm());
        return new KeysAndCerts(sigKeyPair, agrKeyPair, sigCert, agrCert);
    }

    @NonNull
    public static KeyPair generateAgreementKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "SunEC");
        keyPairGenerator.initialize(384, secureRandom);
        return keyPairGenerator.generateKeyPair();
    }

    private static byte[] intToBytes(int value) {
        byte[] dst = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int shift = i * 8;
            dst[i] = (byte)(0xFF & value >> shift);
        }
        return dst;
    }
}

