/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.transaction;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.InstantSource;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import org.hiero.base.CompareTo;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.TimestampedTransaction;
import org.hiero.consensus.transaction.TransactionLimits;
import org.hiero.consensus.transaction.TransactionPoolMetrics;

public class TransactionPoolNexus
implements EventTransactionSupplier {
    public static final Duration DEFAULT_MAXIMUM_PERMISSIBLE_UNHEALTHY_DURATION = Duration.ofSeconds(1L);
    private final Duration maximumPermissibleUnhealthyDuration;
    private final Queue<TimestampedTransaction> bufferedTransactions = new LinkedList<TimestampedTransaction>();
    private final Queue<TimestampedTransaction> priorityBufferedTransactions = new LinkedList<TimestampedTransaction>();
    private int bufferedSignatureTransactionCount = 0;
    private final int maxTransactionBytesPerEvent;
    private final int throttleTransactionQueueSize;
    private final TransactionPoolMetrics transactionPoolMetrics;
    private final int maximumTransactionSize;
    private PlatformStatus platformStatus = PlatformStatus.STARTING_UP;
    private boolean healthy = true;
    private final InstantSource time;

    public TransactionPoolNexus(@NonNull TransactionLimits transactionLimits, int throttleTransactionQueueSize, @NonNull Duration maximumPermissibleUnhealthyDuration, @NonNull Metrics metrics, @NonNull InstantSource time) {
        this.maxTransactionBytesPerEvent = transactionLimits.maxTransactionBytesPerEvent();
        this.throttleTransactionQueueSize = throttleTransactionQueueSize;
        this.maximumPermissibleUnhealthyDuration = Objects.requireNonNull(maximumPermissibleUnhealthyDuration, "maximumPermissibleUnhealthyDuration");
        this.time = Objects.requireNonNull(time, "time must not be null");
        this.transactionPoolMetrics = new TransactionPoolMetrics(metrics, this::getBufferedTransactionCount, this::getPriorityBufferedTransactionCount);
        this.maximumTransactionSize = transactionLimits.transactionMaxBytes();
    }

    public synchronized boolean submitApplicationTransaction(@NonNull Bytes appTransaction) {
        if (!this.healthy || this.platformStatus != PlatformStatus.ACTIVE) {
            return false;
        }
        if (appTransaction == null) {
            return false;
        }
        if (appTransaction.length() > (long)this.maximumTransactionSize) {
            return false;
        }
        return this.submitTransaction(appTransaction, false);
    }

    public synchronized void submitPriorityTransaction(@NonNull Bytes transaction) {
        this.submitTransaction(transaction, true);
    }

    private synchronized boolean submitTransaction(@NonNull Bytes transaction, boolean priority) {
        Objects.requireNonNull(transaction);
        if (!priority && this.bufferedTransactions.size() + this.priorityBufferedTransactions.size() > this.throttleTransactionQueueSize) {
            this.transactionPoolMetrics.recordRejectedAppTransaction();
            return false;
        }
        if (priority) {
            ++this.bufferedSignatureTransactionCount;
            this.transactionPoolMetrics.recordSubmittedPlatformTransaction();
        } else {
            this.transactionPoolMetrics.recordAcceptedAppTransaction();
        }
        TimestampedTransaction timestampedTransaction = new TimestampedTransaction(transaction, this.time.instant());
        if (priority) {
            this.priorityBufferedTransactions.add(timestampedTransaction);
        } else {
            this.bufferedTransactions.add(timestampedTransaction);
        }
        return true;
    }

    public synchronized void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatus = platformStatus;
        if (platformStatus == PlatformStatus.BEHIND) {
            this.clear();
        }
    }

    @Nullable
    private TimestampedTransaction getNextTransaction(long currentEventSize) {
        long maxSize = (long)this.maxTransactionBytesPerEvent - currentEventSize;
        if (maxSize <= 0L) {
            return null;
        }
        if (!this.priorityBufferedTransactions.isEmpty() && this.priorityBufferedTransactions.peek().transaction().length() <= maxSize) {
            --this.bufferedSignatureTransactionCount;
            return this.priorityBufferedTransactions.poll();
        }
        if (!this.bufferedTransactions.isEmpty() && this.bufferedTransactions.peek().transaction().length() <= maxSize) {
            return this.bufferedTransactions.poll();
        }
        return null;
    }

    @NonNull
    public synchronized List<TimestampedTransaction> getTransactionsForEvent() {
        TimestampedTransaction timestampedTransaction;
        if (this.bufferedTransactions.isEmpty() && this.priorityBufferedTransactions.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<TimestampedTransaction> selectedTrans = new LinkedList<TimestampedTransaction>();
        long currEventSize = 0L;
        while ((timestampedTransaction = this.getNextTransaction(currEventSize)) != null) {
            currEventSize += timestampedTransaction.transaction().length();
            selectedTrans.add(timestampedTransaction);
        }
        return selectedTrans;
    }

    public synchronized boolean hasBufferedSignatureTransactions() {
        return this.bufferedSignatureTransactionCount > 0;
    }

    private synchronized int getBufferedTransactionCount() {
        return this.bufferedTransactions.size();
    }

    private synchronized int getPriorityBufferedTransactionCount() {
        return this.priorityBufferedTransactions.size();
    }

    public synchronized void reportUnhealthyDuration(@NonNull Duration duration) {
        this.healthy = CompareTo.isLessThan((Comparable)duration, (Object)this.maximumPermissibleUnhealthyDuration);
    }

    synchronized void clear() {
        this.bufferedTransactions.clear();
        this.priorityBufferedTransactions.clear();
        this.bufferedSignatureTransactionCount = 0;
    }
}

