/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.components;

import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.listeners.PlatformStatusChangeListener;
import com.swirlds.platform.listeners.PlatformStatusChangeNotification;
import com.swirlds.platform.listeners.ReconnectCompleteListener;
import com.swirlds.platform.listeners.ReconnectCompleteNotification;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteListener;
import com.swirlds.platform.listeners.StateWriteToDiskCompleteNotification;
import com.swirlds.platform.system.state.notifications.AsyncFatalIssListener;
import com.swirlds.platform.system.state.notifications.IssListener;
import com.swirlds.platform.system.state.notifications.StateHashedListener;
import com.swirlds.platform.system.state.notifications.StateHashedNotification;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.notification.Notification;
import org.hiero.consensus.model.status.PlatformStatus;

public record DefaultAppNotifier(@NonNull NotificationEngine notificationEngine) implements AppNotifier
{
    @Override
    public void sendStateWrittenToDiskNotification(@NonNull StateWriteToDiskCompleteNotification notification) {
        this.notificationEngine.dispatch(StateWriteToDiskCompleteListener.class, (Notification)notification);
    }

    @Override
    public void sendStateHashedNotification(@NonNull StateHashedNotification notification) {
        this.notificationEngine.dispatch(StateHashedListener.class, (Notification)notification);
    }

    @Override
    public void sendReconnectCompleteNotification(@NonNull ReconnectCompleteNotification notification) {
        this.notificationEngine.dispatch(ReconnectCompleteListener.class, (Notification)notification);
    }

    @Override
    public void sendPlatformStatusChangeNotification(@NonNull PlatformStatus newStatus) {
        this.notificationEngine.dispatch(PlatformStatusChangeListener.class, (Notification)new PlatformStatusChangeNotification(newStatus));
    }

    @Override
    public void sendIssNotification(@NonNull IssNotification notification) {
        this.notificationEngine.dispatch(IssListener.class, (Notification)notification);
        if (IssNotification.IssType.CATASTROPHIC_ISS == notification.getIssType() || IssNotification.IssType.SELF_ISS == notification.getIssType()) {
            this.notificationEngine.dispatch(AsyncFatalIssListener.class, (Notification)notification);
        }
    }
}

