/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.swirlds.platform.recovery.internal.EventStreamLowerBound;
import com.swirlds.platform.recovery.internal.EventStreamPathIterator;
import com.swirlds.platform.recovery.internal.EventStreamSingleFileIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.CesEvent;

public class EventStreamMultiFileIterator
implements IOIterator<CesEvent> {
    private final Iterator<Path> fileIterator;
    private long fileCount;
    private long byteCount;
    private Hash startHash;
    private final List<CesEvent> skippedEvents;
    private EventStreamSingleFileIterator eventIterator;
    private long damagedFileCount = 0L;

    public EventStreamMultiFileIterator(@NonNull Iterator<Path> fileIterator, @NonNull EventStreamLowerBound bound) throws IOException {
        Objects.requireNonNull(bound, "the lower bound must not be null");
        this.fileIterator = Objects.requireNonNull(fileIterator, "the file iterator must not be null");
        this.startHash = null;
        this.skippedEvents = new ArrayList<CesEvent>();
        while (this.hasNext() && bound.compareTo(this.peek()) < 0) {
            this.skippedEvents.add(this.next());
        }
    }

    public EventStreamMultiFileIterator(@NonNull Path eventStreamDirectory, @NonNull EventStreamLowerBound bound) throws IOException {
        this(new EventStreamPathIterator(eventStreamDirectory, bound), bound);
    }

    public void close() {
        if (this.eventIterator != null) {
            this.eventIterator.close();
        }
    }

    public boolean hasNext() throws IOException {
        if (this.eventIterator == null || !this.eventIterator.hasNext()) {
            boolean toleratePartialFile;
            if (!this.fileIterator.hasNext()) {
                return false;
            }
            Hash previousHash = this.eventIterator == null ? null : this.eventIterator.getEndHash();
            Path nextFile = this.fileIterator.next();
            ++this.fileCount;
            boolean bl = toleratePartialFile = !this.fileIterator.hasNext();
            if (this.eventIterator != null) {
                this.byteCount += this.eventIterator.getBytesRead();
                this.eventIterator.close();
                if (this.eventIterator.isDamaged()) {
                    ++this.damagedFileCount;
                }
            }
            this.eventIterator = new EventStreamSingleFileIterator(nextFile, toleratePartialFile);
            if (this.startHash == null) {
                this.startHash = this.eventIterator.getStartHash();
            }
            if (previousHash != null && !this.eventIterator.getStartHash().equals((Object)previousHash)) {
                throw new IOException("missing event stream file prior to `%s` detected".formatted(nextFile));
            }
        }
        return true;
    }

    public CesEvent peek() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.eventIterator.peek();
    }

    public CesEvent next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.eventIterator.next();
    }

    public Hash getStartHash() {
        return this.startHash;
    }

    public List<CesEvent> getSkippedEvents() {
        return this.skippedEvents;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getBytesRead() {
        return this.byteCount + this.eventIterator.getBytesRead();
    }

    public long getDamagedFileCount() {
        long damageCount = this.damagedFileCount;
        if (this.eventIterator != null && this.eventIterator.isDamaged()) {
            ++damageCount;
        }
        return damageCount;
    }
}

