/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.hashgraph.impl.metrics;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Objects;
import org.hiero.consensus.hashgraph.impl.EventImpl;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.SpeedometerMetric;
import org.hiero.consensus.metrics.statistics.AverageStat;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.Transaction;

public class ConsensusEngineMetrics {
    private final NodeId selfId;
    private static final SpeedometerMetric.Config EVENTS_CREATED_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "cEvents_per_sec").withDescription("number of events per second created by this node").withFormat("%,16.2f");
    private final SpeedometerMetric eventsCreatedPerSecond;
    private static final RunningAverageMetric.Config AVG_CREATED_RECEIVED_TIME_CONFIG = new RunningAverageMetric.Config("platform", "secC2R").withDescription("time from another member creating an event to receiving it and verifying the signature (in seconds)").withFormat("%,10.3f");
    private final RunningAverageMetric avgCreatedReceivedTime;
    private static final SpeedometerMetric.Config EVENTS_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "events_per_sec").withDescription("number of unique events received per second (created by self and others)").withFormat("%,16.2f");
    private final SpeedometerMetric eventsPerSecond;
    private static final RunningAverageMetric.Config AVG_BYTES_PER_TRANSACTION_CONFIG = new RunningAverageMetric.Config("platform", "bytes_per_trans").withDescription("number of bytes in each transactions").withFormat("%,16.0f");
    private final RunningAverageMetric avgBytesPerTransaction;
    private static final RunningAverageMetric.Config AVG_TRANSACTIONS_PER_EVENT_CONFIG = new RunningAverageMetric.Config("platform", "trans_per_event").withDescription("number of app transactions in each event").withFormat("%,17.1f");
    private final RunningAverageMetric avgTransactionsPerEvent;
    private static final String DETAILS = "(from unique events created by self and others)";
    private static final SpeedometerMetric.Config BYTES_PER_SECOND_TRANS_CONFIG = new SpeedometerMetric.Config("platform", "bytes_per_sec_trans").withDescription("number of bytes in the transactions received per second (from unique events created by self and others)").withFormat("%,16.2f");
    private final SpeedometerMetric bytesPerSecondTrans;
    private static final SpeedometerMetric.Config TRANSACTIONS_PER_SECOND_CONFIG = new SpeedometerMetric.Config("platform", "trans_per_sec").withDescription("number of app transactions received per second (from unique events created by self and others)").withFormat("%,13.2f");
    private final SpeedometerMetric transactionsPerSecond;
    private static final Counter.Config NUM_TRANS_CONFIG = new Counter.Config("internal", "trans").withDescription("number of transactions received so far");
    private final Counter numTrans;
    private final AverageStat averageOtherParentAgeDiff;
    private static final LongAccumulator.Config STALE_EVENTS_CONFIG = new LongAccumulator.Config("internal", "staleEvents").withAccumulator(Long::sum).withDescription("number of stale self events");
    private final LongAccumulator staleEventCount;
    private static final LongAccumulator.Config STALE_APP_TRANSACTIONS_CONFIG = new LongAccumulator.Config("internal", "staleTransactions").withAccumulator(Long::sum).withDescription("number of transactions in stale self events");
    private final LongAccumulator staleTransactionCount;

    public ConsensusEngineMetrics(NodeId selfId, Metrics metrics) {
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.eventsCreatedPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)EVENTS_CREATED_PER_SECOND_CONFIG);
        this.averageOtherParentAgeDiff = new AverageStat(metrics, "platform", "opAgeDiff", "average age difference (in birth rounds) between an event created by this node and its other parent", "%,5.3f", 0.1);
        this.avgCreatedReceivedTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_CREATED_RECEIVED_TIME_CONFIG);
        this.eventsPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)EVENTS_PER_SECOND_CONFIG);
        this.avgBytesPerTransaction = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_BYTES_PER_TRANSACTION_CONFIG);
        this.avgTransactionsPerEvent = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_TRANSACTIONS_PER_EVENT_CONFIG);
        this.bytesPerSecondTrans = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)BYTES_PER_SECOND_TRANS_CONFIG);
        this.transactionsPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)TRANSACTIONS_PER_SECOND_CONFIG);
        this.numTrans = (Counter)metrics.getOrCreate((MetricConfig)NUM_TRANS_CONFIG);
        this.staleEventCount = (LongAccumulator)metrics.getOrCreate((MetricConfig)STALE_EVENTS_CONFIG);
        this.staleTransactionCount = (LongAccumulator)metrics.getOrCreate((MetricConfig)STALE_APP_TRANSACTIONS_CONFIG);
    }

    public void eventAdded(EventImpl event) {
        if (Objects.equals(event.getCreatorId(), this.selfId)) {
            this.eventsCreatedPerSecond.cycle();
            if (!event.getBaseEvent().getOtherParents().isEmpty()) {
                this.averageOtherParentAgeDiff.update(event.getBirthRound() - event.getBaseEvent().getOtherParents().stream().map(ed -> ed.eventDescriptor().birthRound()).max(Long::compareTo).orElse(0L));
            }
        } else {
            this.avgCreatedReceivedTime.update((double)event.getTimeCreated().until(event.getBaseEvent().getTimeReceived(), ChronoUnit.NANOS) * 1.0E-9);
        }
        this.eventsPerSecond.cycle();
        long appSize = 0L;
        int numAppTrans = 0;
        Iterator iterator = event.getBaseEvent().transactionIterator();
        while (iterator.hasNext()) {
            Transaction transaction = (Transaction)iterator.next();
            ++numAppTrans;
            appSize += transaction.getSize();
            this.avgBytesPerTransaction.update((double)transaction.getSize());
        }
        this.avgTransactionsPerEvent.update((double)numAppTrans);
        this.bytesPerSecondTrans.update((double)appSize);
        this.transactionsPerSecond.update((double)numAppTrans);
        if (event.getBaseEvent().getTransactionCount() != 0) {
            this.numTrans.add((long)event.getBaseEvent().getTransactionCount());
        }
    }

    public void reportStaleEvent(@NonNull PlatformEvent event) {
        if (!this.selfId.equals((Object)event.getCreatorId())) {
            return;
        }
        this.staleEventCount.update(1L);
        this.staleTransactionCount.update((long)event.getTransactionCount());
    }
}

