/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hapi.utils.throttles.DiscreteLeakyBucket;
import java.math.BigInteger;

public class BucketThrottle {
    private static final int DEFAULT_BURST_PERIOD = 1;
    static final long MS_PER_SEC = 1000L;
    static final long MTPS_PER_TPS = 1000L;
    public static final long NTPS_PER_MTPS = 1000000L;
    static final long CAPACITY_UNITS_PER_TXN = 1000000000000L;
    public static final long CAPACITY_UNITS_PER_NANO_TXN = 1000L;
    private final long mtps;
    private final DiscreteLeakyBucket bucket;
    private long lastAllowedUnits = 0L;

    public static long capacityUnitsPerTxn() {
        return 1000000000000L;
    }

    public static long capacityUnitsPerMs(long mtps) {
        return mtps * 1000000L * 1000L / 1000L;
    }

    static BucketThrottle withTps(int tps) {
        return new BucketThrottle((long)tps * 1000L, 1000L);
    }

    static BucketThrottle withMtps(long mtps) {
        return new BucketThrottle(mtps, 1000L);
    }

    static BucketThrottle withTpsAndBurstPeriod(int tps, int burstPeriod) {
        return new BucketThrottle((long)tps * 1000L, (long)burstPeriod * 1000L);
    }

    static BucketThrottle withTpsAndBurstPeriodMs(int tps, long burstPeriodMs) {
        return new BucketThrottle((long)tps * 1000L, burstPeriodMs);
    }

    static BucketThrottle withMtpsAndBurstPeriod(long mtps, int burstPeriod) {
        return new BucketThrottle(mtps, (long)burstPeriod * 1000L);
    }

    public static BucketThrottle withMtpsAndBurstPeriodMs(long mtps, long burstPeriodMs) {
        return new BucketThrottle(mtps, burstPeriodMs);
    }

    private BucketThrottle(long mtps, long burstPeriodMs) {
        this.mtps = mtps;
        this.validateCapacityForRequested(mtps, burstPeriodMs);
        long capacity = mtps * 1000000L * 1000L / 1000L * burstPeriodMs;
        this.bucket = DiscreteLeakyBucket.ofFixedCapacity(capacity);
        if (this.bucket.brimfulCapacity() < 1000000000000L) {
            throw new IllegalArgumentException("A throttle with " + mtps + " MTPS and " + burstPeriodMs + "ms burst period can never allow a transaction");
        }
    }

    private void validateCapacityForRequested(long requestedMtps, long burstPeriodMs) {
        if (CommonUtils.productWouldOverflow(requestedMtps, 1000000000L)) {
            throw new IllegalArgumentException("Base bucket capacity calculation outside numeric range");
        }
        long unscaledCapacity = requestedMtps * 1000000L * 1000L / 1000L;
        if (CommonUtils.productWouldOverflow(unscaledCapacity, burstPeriodMs)) {
            throw new IllegalArgumentException("Scaled bucket capacity calculation outside numeric range");
        }
    }

    boolean allow(int numReqs, long elapsedNanos) {
        this.leakFor(elapsedNanos);
        return this.allowInstantaneous(numReqs);
    }

    void leakCapacity(long capacity) {
        this.bucket.leak(capacity);
    }

    void leakFor(long elapsedNanos) {
        long leakedUnits = this.effectiveLeak(elapsedNanos);
        this.bucket.leak(leakedUnits);
    }

    boolean allowInstantaneous(int numReqs) {
        if (CommonUtils.productWouldOverflow(numReqs, 1000000000000L)) {
            return false;
        }
        long requiredUnits = (long)numReqs * 1000000000000L;
        if (requiredUnits > this.bucket.brimfulCapacityFree()) {
            return false;
        }
        this.bucket.useCapacity(requiredUnits);
        this.lastAllowedUnits += requiredUnits;
        return true;
    }

    void leakInstantaneous(int numReqs) {
        if (CommonUtils.productWouldOverflow(numReqs, 1000000000000L)) {
            return;
        }
        this.bucket.leak((long)numReqs * 1000000000000L);
    }

    double percentUsed(long givenElapsedNanos) {
        long used = this.bucket.capacityUsed();
        return 100.0 * (double)(used - Math.min(used, this.effectiveLeak(givenElapsedNanos))) / (double)this.bucket.brimfulCapacity();
    }

    public double instantaneousPercentUsed() {
        return 100.0 * (double)this.bucket.capacityUsed() / (double)this.bucket.brimfulCapacity();
    }

    public int instantaneousBps() {
        return BigInteger.valueOf(this.bucket.capacityUsed()).multiply(BigInteger.valueOf(10000L)).divide(BigInteger.valueOf(this.bucket.brimfulCapacity())).intValueExact();
    }

    private long effectiveLeak(long elapsedNanos) {
        return CommonUtils.productWouldOverflow(elapsedNanos, this.mtps) ? this.bucket.brimfulCapacity() : elapsedNanos * this.mtps;
    }

    void resetLastAllowedUse() {
        this.lastAllowedUnits = 0L;
    }

    void reclaimLastAllowedUse() {
        this.bucket.leak(this.lastAllowedUnits);
        this.lastAllowedUnits = 0L;
    }

    public DiscreteLeakyBucket bucket() {
        return this.bucket;
    }

    public long mtps() {
        return this.mtps;
    }
}

