/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.hash;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hash;

public class FullLeafRehashHashListener
implements VirtualHashListener {
    private static final Logger logger = LogManager.getLogger(FullLeafRehashHashListener.class);
    private final VirtualDataSource dataSource;
    private final long firstLeafPath;
    private final long lastLeafPath;
    private List<VirtualHashRecord> hashes;
    private final int flushInterval;
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final VirtualMapStatistics statistics;

    public FullLeafRehashHashListener(long firstLeafPath, long lastLeafPath, @NonNull VirtualDataSource dataSource, @NonNull VirtualMapStatistics statistics, int flushInterval) {
        if (firstLeafPath != -1L && (firstLeafPath <= 0L || firstLeafPath > lastLeafPath)) {
            throw new IllegalArgumentException("The first leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        if (lastLeafPath != -1L && lastLeafPath <= 0L) {
            throw new IllegalArgumentException("The last leaf path is invalid. firstLeafPath=" + firstLeafPath + ", lastLeafPath=" + lastLeafPath);
        }
        this.firstLeafPath = firstLeafPath;
        this.lastLeafPath = lastLeafPath;
        this.dataSource = Objects.requireNonNull(dataSource);
        this.statistics = Objects.requireNonNull(statistics);
        this.flushInterval = flushInterval;
    }

    @Override
    public synchronized void onHashingStarted(long firstLeafPath, long lastLeafPath) {
        assert (this.hashes == null) : "Hashing must not be started yet";
        this.hashes = new ArrayList<VirtualHashRecord>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNodeHashed(long path, Hash hash) {
        List<VirtualHashRecord> dirtyHashesToFlush;
        assert (this.hashes != null) : "onNodeHashed called without onHashingStarted";
        FullLeafRehashHashListener fullLeafRehashHashListener = this;
        synchronized (fullLeafRehashHashListener) {
            this.hashes.add(new VirtualHashRecord(path, hash));
            if (this.hashes.size() >= this.flushInterval && this.flushInProgress.compareAndSet(false, true)) {
                dirtyHashesToFlush = this.hashes;
                this.hashes = new ArrayList<VirtualHashRecord>();
            } else {
                dirtyHashesToFlush = null;
            }
        }
        if (dirtyHashesToFlush != null) {
            this.flush(dirtyHashesToFlush);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHashingCompleted() {
        List<VirtualHashRecord> finalNodesToFlush;
        FullLeafRehashHashListener fullLeafRehashHashListener = this;
        synchronized (fullLeafRehashHashListener) {
            finalNodesToFlush = this.hashes;
            this.hashes = null;
        }
        assert (!this.flushInProgress.get()) : "Flush must not be in progress when hashing is complete";
        this.flushInProgress.set(true);
        this.flush(finalNodesToFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(@NonNull List<VirtualHashRecord> hashesToFlush) {
        assert (this.flushInProgress.get()) : "Flush in progress flag must be set";
        try {
            logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushing {} hashes", (Object)hashesToFlush.size());
            long start = System.currentTimeMillis();
            try {
                this.dataSource.saveRecords(this.firstLeafPath, this.lastLeafPath, hashesToFlush.stream(), Stream.empty(), Stream.empty(), true);
                long end = System.currentTimeMillis();
                this.statistics.recordFlush(end - start);
                logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushed in {} ms", (Object)(end - start));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        finally {
            this.flushInProgress.set(false);
        }
    }
}

