/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.intake.impl.signature;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.base.time.Time;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.crypto.SignatureVerifier;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.intake.impl.signature.EventSignatureValidator;
import org.hiero.consensus.model.event.EventOrigin;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterEntryNotFoundException;
import org.hiero.consensus.roster.RosterHistory;
import org.hiero.consensus.roster.RosterUtils;

public class DefaultEventSignatureValidator
implements EventSignatureValidator {
    private static final Logger logger = LogManager.getLogger(DefaultEventSignatureValidator.class);
    private static final Duration MINIMUM_LOG_PERIOD = Duration.ofMinutes(1L);
    private final SignatureVerifier signatureVerifier;
    private RosterHistory rosterHistory;
    private EventWindow eventWindow;
    private final IntakeEventCounter intakeEventCounter;
    private final RateLimitedLogger rateLimitedLogger;
    private static final LongAccumulator.Config VALIDATION_FAILED_CONFIG = new LongAccumulator.Config("platform", "eventsFailedSignatureValidation").withDescription("Events for which signature validation failed").withUnit("events");
    private final LongAccumulator validationFailedAccumulator;

    public DefaultEventSignatureValidator(@NonNull Metrics metrics, @NonNull Time time, @NonNull SignatureVerifier signatureVerifier, @Nullable RosterHistory rosterHistory, @NonNull IntakeEventCounter intakeEventCounter) {
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
        this.rosterHistory = Objects.requireNonNull(rosterHistory);
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.rateLimitedLogger = new RateLimitedLogger(logger, time, MINIMUM_LOG_PERIOD);
        this.validationFailedAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)VALIDATION_FAILED_CONFIG);
        this.eventWindow = EventWindow.getGenesisEventWindow();
    }

    private boolean isSignatureValid(@NonNull PlatformEvent event) {
        PublicKey publicKey;
        RosterEntry rosterEntry;
        Roster applicableRoster = this.rosterHistory.getRosterForRound(event.getBirthRound());
        if (applicableRoster == null) {
            this.rateLimitedLogger.error(LogMarker.EXCEPTION.getMarker(), "Cannot validate events for birth round {} without a roster", new Object[]{event.getBirthRound()});
            return false;
        }
        NodeId eventCreatorId = event.getCreatorId();
        try {
            rosterEntry = RosterUtils.getRosterEntry((Roster)applicableRoster, (long)eventCreatorId.id());
        }
        catch (RosterEntryNotFoundException e) {
            this.rateLimitedLogger.error(LogMarker.EXCEPTION.getMarker(), "Node {} doesn't exist in applicable roster. Event: {}", new Object[]{eventCreatorId, event});
            return false;
        }
        X509Certificate cert = RosterUtils.fetchGossipCaCertificate((RosterEntry)rosterEntry);
        PublicKey publicKey2 = publicKey = cert == null ? null : cert.getPublicKey();
        if (publicKey == null) {
            this.rateLimitedLogger.error(LogMarker.EXCEPTION.getMarker(), "Cannot find publicKey for creator with ID: {}", new Object[]{eventCreatorId});
            return false;
        }
        boolean isSignatureValid = this.signatureVerifier.verifySignature(event.getHash().getBytes(), event.getSignature(), publicKey);
        if (!isSignatureValid) {
            this.rateLimitedLogger.error(LogMarker.EXCEPTION.getMarker(), "Event failed signature check. Event: {}, Signature: {}, Hash: {}", new Object[]{event, event.getSignature().toHex(), event.getHash()});
        }
        return isSignatureValid;
    }

    @Override
    @Nullable
    public PlatformEvent validateSignature(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
            return null;
        }
        if (event.getOrigin() == EventOrigin.RUNTIME) {
            return event;
        }
        if (this.isSignatureValid(event)) {
            return event;
        }
        this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
        this.validationFailedAccumulator.update(1L);
        return null;
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
    }

    @Override
    public void updateRosterHistory(@NonNull RosterHistory rosterHistory) {
        this.rosterHistory = Objects.requireNonNull(rosterHistory);
    }
}

