/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.client.helidon;

import com.hedera.pbj.grpc.client.helidon.PbjGrpcClient;
import com.hedera.pbj.grpc.client.helidon.PbjGrpcDatagramReader;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcCompression;
import com.hedera.pbj.runtime.grpc.GrpcException;
import com.hedera.pbj.runtime.grpc.GrpcStatus;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.StreamTimeoutException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class PbjGrpcCall<RequestT, ReplyT>
implements GrpcCall<RequestT, ReplyT> {
    private static final BufferData EMPTY_BUFFER_DATA = BufferData.empty();
    private static final HeaderName GRPC_STATUS = HeaderNames.createFromLowercase((String)"grpc-status");
    private static final HeaderName GRPC_MESSAGE = HeaderNames.createFromLowercase((String)"grpc-message");
    private static final HeaderName GRPC_ENCODING = HeaderNames.createFromLowercase((String)"grpc-encoding");
    private static final HeaderName GRPC_ACCEPT_ENCODING = HeaderNames.createFromLowercase((String)"grpc-accept-encoding");
    private final PbjGrpcClient grpcClient;
    private final Codec<RequestT> requestCodec;
    private final Codec<ReplyT> replyCodec;
    private final Pipeline<ReplyT> pipeline;
    private final Http2ClientStream clientStream;
    private final String grpcOutgoingEncoding;

    PbjGrpcCall(PbjGrpcClient grpcClient, Http2ClientStream clientStream, ServiceInterface.RequestOptions requestOptions, String fullMethodName, Codec<RequestT> requestCodec, Codec<ReplyT> replyCodec, Pipeline<ReplyT> pipeline) {
        this.grpcClient = grpcClient;
        this.requestCodec = requestCodec;
        this.replyCodec = replyCodec;
        this.pipeline = pipeline;
        this.clientStream = clientStream;
        this.grpcOutgoingEncoding = GrpcCompression.getCompressor((String)grpcClient.getConfig().encoding()) != null ? grpcClient.getConfig().encoding() : "identity";
        WritableHeaders headers = WritableHeaders.create();
        String authority = (String)requestOptions.authority().orElseThrow(() -> new IllegalStateException("gRPC request requires an :authority value."));
        headers.add(Http2Headers.AUTHORITY_NAME, new String[]{authority});
        headers.add(Http2Headers.METHOD_NAME, new String[]{"POST"});
        headers.add(Http2Headers.PATH_NAME, new String[]{"/" + fullMethodName});
        headers.add(Http2Headers.SCHEME_NAME, new String[]{"http"});
        headers.add(HeaderValues.create((HeaderName)HeaderNames.CONTENT_TYPE, (String)requestOptions.contentType()));
        headers.add(HeaderValues.create((HeaderName)GRPC_ACCEPT_ENCODING, (String)String.join((CharSequence)",", grpcClient.getConfig().acceptEncodings())));
        headers.add(HeaderValues.create((HeaderName)GRPC_ENCODING, (String)this.grpcOutgoingEncoding));
        clientStream.writeHeaders(Http2Headers.create((WritableHeaders)headers), false);
        grpcClient.getWebClient().executor().submit(this::receiveRepliesLoop);
    }

    public void sendRequest(RequestT request, boolean endOfStream) {
        Bytes requestBytes = this.requestCodec.toBytes(request);
        Bytes bytes = GrpcCompression.getCompressor((String)this.grpcOutgoingEncoding).compress(requestBytes);
        BufferData bufferData = BufferData.create((int)(5 + Math.toIntExact(bytes.length())));
        bufferData.write("identity".equals(this.grpcOutgoingEncoding) ? 0 : 1);
        bufferData.writeUnsignedInt32((long)Math.toIntExact(bytes.length()));
        bufferData.write(bytes.toByteArray());
        this.clientStream.writeData(bufferData, endOfStream);
    }

    public void completeRequests() {
        this.clientStream.writeData(EMPTY_BUFFER_DATA, true);
    }

    private boolean isStreamOpen() {
        return this.clientStream.streamState() != Http2StreamState.HALF_CLOSED_REMOTE && this.clientStream.streamState() != Http2StreamState.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receiveRepliesLoop() {
        try {
            Http2Headers http2Headers = null;
            do {
                try {
                    http2Headers = this.clientStream.readHeaders();
                }
                catch (StreamTimeoutException ignored) {
                    this.clientStream.sendPing();
                }
            } while (http2Headers == null && this.isStreamOpen());
            GrpcCompression.Decompressor decompressor = GrpcCompression.determineDecompressor(http2Headers != null && http2Headers.httpHeaders() != null ? PbjGrpcCall.fetchHeader(http2Headers.httpHeaders(), GRPC_ENCODING) : null);
            PbjGrpcDatagramReader datagramReader = new PbjGrpcDatagramReader();
            while (this.isStreamOpen() && !this.clientStream.trailers().isDone() && this.clientStream.hasEntity()) {
                PbjGrpcDatagramReader.Datagram datagram;
                Http2FrameData frameData;
                try {
                    frameData = this.clientStream.readOne(this.grpcClient.getConfig().readTimeout());
                }
                catch (StreamTimeoutException e) {
                    this.clientStream.sendPing();
                    continue;
                }
                if (frameData == null) continue;
                BufferData bufferData = frameData.data();
                datagramReader.add(bufferData);
                while ((datagram = datagramReader.extractNextDatagram()) != null) {
                    if (datagram.compressedFlag() != 0 && datagram.compressedFlag() != 1) {
                        throw new IllegalStateException("GRPC datagram compressed flag " + datagram.compressedFlag() + " is unsupported. Only 0 and 1 are valid.");
                    }
                    BufferData data = datagram.data();
                    byte[] array = data.readBytes();
                    Bytes bytes = Bytes.wrap((byte[])array);
                    Bytes replyBytes = datagram.compressedFlag() == 1 ? decompressor.decompress(bytes) : bytes;
                    try {
                        Object reply = this.replyCodec.parse(replyBytes);
                        this.pipeline.onNext(reply);
                    }
                    catch (ParseException e) {
                        this.pipeline.onError((Throwable)e);
                        this.clientStream.close();
                        return;
                    }
                }
            }
            if (this.processHeaders(this.clientStream.readHeaders().httpHeaders())) {
                return;
            }
            Headers trailers = (Headers)this.clientStream.trailers().get(this.grpcClient.getConfig().readTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (this.processHeaders(trailers)) {
                return;
            }
        }
        catch (Throwable t) {
            this.pipeline.onError(t);
            return;
        }
        {
            this.pipeline.onComplete();
            return;
        }
        finally {
            this.clientStream.close();
        }
    }

    private static List<String> fetchHeader(Headers headers, HeaderName header) {
        return headers.contains(header) ? headers.get(header).allValues() : List.of();
    }

    private boolean processHeaders(Headers headers) {
        boolean onErrorCalled = false;
        String message = PbjGrpcCall.fetchHeader(headers, GRPC_MESSAGE).stream().collect(Collectors.joining(". "));
        for (String value : PbjGrpcCall.fetchHeader(headers, GRPC_STATUS)) {
            try {
                int grpcStatus = Integer.parseInt(value);
                if (grpcStatus == 0) continue;
                this.pipeline.onError((Throwable)new GrpcException(grpcStatus < GrpcStatus.values().length ? GrpcStatus.values()[grpcStatus] : GrpcStatus.UNKNOWN, message));
                onErrorCalled = true;
            }
            catch (NumberFormatException ignored) {
                this.pipeline.onError((Throwable)new RuntimeException(String.format("Invalid GRPC_STATUS: %s with message %s", value, message)));
                onErrorCalled = true;
            }
        }
        return onErrorCalled;
    }
}

